/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.updater;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.delegates.BrowserAppDelegateWithReference;
import org.mozilla.gecko.util.IOUtils;
import org.mozilla.gecko.util.ThreadUtils;

public class PostUpdateHandler
extends BrowserAppDelegateWithReference {
    private static final String LOGTAG = "PostUpdateHandler";

    @Override
    public void onStart(final BrowserApp browserApp) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp((Context)browserApp);
                if (!"20160716030215".equals(sharedPreferences.getString("app.update.last_build_id", null))) {
                    Log.d((String)PostUpdateHandler.LOGTAG, (String)("Build ID changed since last start: '20160716030215', '" + sharedPreferences.getString("app.update.last_build_id", null) + "'"));
                    PostUpdateHandler.this.copyFeaturesFromAPK(browserApp);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFeaturesFromAPK(BrowserApp browserApp) {
        Log.d((String)LOGTAG, (String)"Copying system add-ons from APK to dataDir");
        String string2 = browserApp.getApplicationInfo().dataDir;
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp((Context)browserApp);
        AssetManager assetManager = browserApp.getContext().getAssets();
        try {
            String[] stringArray = assetManager.list("features");
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = "features/" + stringArray[i];
                Log.d((String)LOGTAG, (String)("Copying '" + string3 + "' from APK to dataDir"));
                InputStream inputStream = assetManager.open(string3);
                File file = this.getDataFile(string2, string3);
                if (file == null) continue;
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
                    continue;
                }
            }
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Error retrieving packaged system add-ons from APK", (Throwable)iOException);
        }
        sharedPreferences.edit().putString("app.update.last_build_id", "20160716030215").apply();
    }

    private File getDataFile(String string2, String string3) {
        File file = new File(string2, string3);
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            Log.d((String)LOGTAG, (String)("Creating " + file2.getAbsolutePath()));
            if (!file2.mkdirs()) {
                Log.e((String)LOGTAG, (String)("Unable to create directories: " + file2.getAbsolutePath()));
                return null;
            }
        }
        return file;
    }
}

