/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.widget.ImageView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.favicons.FaviconGenerator;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.util.ThreadUtils;

public class FaviconView
extends ImageView {
    private static final String LOGTAG = "GeckoFaviconView";
    private static String DEFAULT_FAVICON_KEY = FaviconView.class.getSimpleName() + "DefaultFavicon";
    private static final int DEFAULT_CORNER_RADIUS_DP = 4;
    private Bitmap mIconBitmap;
    private Bitmap mUnscaledBitmap;
    private String mIconKey;
    private int mActualWidth;
    private int mActualHeight;
    private boolean mScalingExpected;
    private int mDominantColor;
    private static final Paint sBackgroundPaint = new Paint(1);
    private final RectF mBackgroundRect;
    private final float mBackgroundCornerRadius;
    private final boolean isDominantBorderEnabled;
    private final boolean isOverrideScaleTypeEnabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FaviconView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.FaviconView, 0, 0);
        try {
            this.isDominantBorderEnabled = typedArray.getBoolean(R.styleable.FaviconView_dominantBorderEnabled, true);
            this.isOverrideScaleTypeEnabled = typedArray.getBoolean(R.styleable.FaviconView_overrideScaleType, true);
        }
        finally {
            typedArray.recycle();
        }
        if (this.isOverrideScaleTypeEnabled) {
            this.setScaleType(ImageView.ScaleType.CENTER);
        }
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        this.mBackgroundRect = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
        this.mBackgroundCornerRadius = TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)displayMetrics);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        if (n == this.mActualWidth && n2 == this.mActualHeight) {
            return;
        }
        this.mActualWidth = n;
        this.mActualHeight = n2;
        this.mBackgroundRect.right = n;
        this.mBackgroundRect.bottom = n2;
        this.formatImage();
    }

    public void onDraw(Canvas canvas) {
        if (this.isDominantBorderEnabled) {
            sBackgroundPaint.setColor(this.mDominantColor & Integer.MAX_VALUE);
            canvas.drawRoundRect(this.mBackgroundRect, this.mBackgroundCornerRadius, this.mBackgroundCornerRadius, sBackgroundPaint);
        }
        super.onDraw(canvas);
    }

    private void formatImage() {
        if (this.mIconBitmap == null || this.mActualWidth == 0 || this.mActualHeight == 0) {
            this.showNoImage();
            return;
        }
        if (this.mScalingExpected && this.mActualWidth != this.mIconBitmap.getWidth()) {
            this.scaleBitmap();
            this.mScalingExpected = false;
        }
        this.setImageBitmap(this.mIconBitmap);
        if (Math.abs(this.mIconBitmap.getWidth() - this.mActualWidth) > 3) {
            this.mDominantColor = Favicons.getFaviconColor(this.mIconKey);
            if (this.mDominantColor == -1) {
                this.mDominantColor = 0;
            }
        } else {
            this.mDominantColor = 0;
        }
    }

    private void scaleBitmap() {
        int n = this.mIconBitmap.getWidth() * 2;
        this.mIconBitmap = this.mActualWidth > n ? Bitmap.createScaledBitmap((Bitmap)this.mIconBitmap, (int)n, (int)n, (boolean)true) : Bitmap.createScaledBitmap((Bitmap)this.mIconBitmap, (int)this.mActualWidth, (int)this.mActualWidth, (boolean)true);
    }

    private void updateImageInternal(Bitmap bitmap, String string2, boolean bl) {
        if (bitmap == null) {
            Log.w((String)LOGTAG, (String)"updateImageInternal() called without bitmap");
            this.showDefaultFavicon(null);
            return;
        }
        if (this.mUnscaledBitmap == bitmap) {
            return;
        }
        this.mUnscaledBitmap = bitmap;
        this.mIconBitmap = bitmap;
        this.mIconKey = string2;
        this.mScalingExpected = bl;
        this.formatImage();
    }

    public void showDefaultFavicon(final String string2) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                final Bitmap bitmap = FaviconGenerator.generate(FaviconView.this.getContext(), string2);
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FaviconView.this.updateAndScaleImage(bitmap, DEFAULT_FAVICON_KEY);
                    }
                });
            }
        });
    }

    private void showNoImage() {
        this.setImageDrawable(null);
        this.mDominantColor = 0;
    }

    public void clearImage() {
        this.showNoImage();
        this.mUnscaledBitmap = null;
        this.mIconBitmap = null;
        this.mIconKey = null;
        this.mScalingExpected = false;
    }

    public void updateAndScaleImage(Bitmap bitmap, String string2) {
        this.updateImageInternal(bitmap, string2, true);
    }

    public void updateImage(Bitmap bitmap, String string2) {
        this.updateImageInternal(bitmap, string2, false);
    }

    public Bitmap getBitmap() {
        return this.mIconBitmap;
    }

    static {
        sBackgroundPaint.setStyle(Paint.Style.FILL);
    }
}

