/*
 * Decompiled with CFR 0.152.
 */
package com.keepsafe.switchboard;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.Nullable;

public class Preferences {
    private static final String switchBoardSettings = "com.keepsafe.switchboard.settings";
    private static final String CONFIG_JSON = "config-json";
    private static final String OVERRIDE_PREFIX = "experiment.override.";

    @Nullable
    public static String getDynamicConfigJson(Context context) {
        SharedPreferences sharedPreferences = context.getApplicationContext().getSharedPreferences(switchBoardSettings, 0);
        return sharedPreferences.getString(CONFIG_JSON, null);
    }

    public static void setDynamicConfigJson(Context context, String string) {
        SharedPreferences.Editor editor = context.getApplicationContext().getSharedPreferences(switchBoardSettings, 0).edit();
        editor.putString(CONFIG_JSON, string);
        editor.apply();
    }

    @Nullable
    public static Boolean getOverrideValue(Context context, String string) {
        String string2;
        SharedPreferences sharedPreferences = context.getApplicationContext().getSharedPreferences(switchBoardSettings, 0);
        if (sharedPreferences.contains(string2 = OVERRIDE_PREFIX + string)) {
            return sharedPreferences.getBoolean(string2, false);
        }
        return null;
    }

    public static void setOverrideValue(Context context, String string, boolean bl) {
        SharedPreferences.Editor editor = context.getApplicationContext().getSharedPreferences(switchBoardSettings, 0).edit();
        editor.putBoolean(OVERRIDE_PREFIX + string, bl);
        editor.apply();
    }

    public static void clearOverrideValue(Context context, String string) {
        SharedPreferences.Editor editor = context.getApplicationContext().getSharedPreferences(switchBoardSettings, 0).edit();
        editor.remove(OVERRIDE_PREFIX + string);
        editor.apply();
    }
}

