/*
 * Decompiled with CFR 0.152.
 */
package com.keepsafe.switchboard;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.keepsafe.switchboard.DeviceUuidFactory;
import com.keepsafe.switchboard.Preferences;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.zip.CRC32;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SwitchBoard {
    private static final String TAG = "SwitchBoard";
    public static boolean DEBUG = true;
    private static final String KEY_DATA = "data";
    private static final String KEY_NAME = "name";
    private static final String KEY_MATCH = "match";
    private static final String KEY_BUCKETS = "buckets";
    private static final String KEY_VALUES = "values";
    private static final String KEY_APP_ID = "appId";
    private static final String KEY_COUNTRY = "country";
    private static final String KEY_DEVICE = "device";
    private static final String KEY_LANG = "lang";
    private static final String KEY_MANUFACTURER = "manufacturer";
    private static final String KEY_VERSION = "version";
    private static final String KEY_MIN = "min";
    private static final String KEY_MAX = "max";

    static void loadConfig(Context context, @NonNull String string) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            Log.e((String)TAG, (String)"Exception creating server URL", (Throwable)malformedURLException);
            return;
        }
        String string2 = SwitchBoard.readFromUrlGET(uRL);
        if (DEBUG) {
            Log.d((String)TAG, (String)("Result: " + string2));
        }
        if (string2 == null) {
            return;
        }
        Preferences.setDynamicConfigJson(context, string2);
    }

    public static boolean isInBucket(Context context, int n, int n2) {
        int n3 = SwitchBoard.getUserBucket(context);
        return n3 >= n && n3 < n2;
    }

    public static boolean isInExperiment(Context context, String string) {
        Boolean bl = Preferences.getOverrideValue(context, string);
        if (bl != null) {
            return bl;
        }
        String string2 = Preferences.getDynamicConfigJson(context);
        if (string2 == null) {
            return false;
        }
        try {
            JSONArray jSONArray = new JSONObject(string2).getJSONArray(KEY_DATA);
            JSONObject jSONObject = null;
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                String string3 = jSONObject2.getString(KEY_NAME);
                if (!string3.equals(string)) continue;
                jSONObject = jSONObject2;
                break;
            }
            if (jSONObject == null) {
                return false;
            }
            if (!SwitchBoard.isMatch(context, jSONObject.optJSONObject(KEY_MATCH))) {
                return false;
            }
            JSONObject jSONObject3 = jSONObject.getJSONObject(KEY_BUCKETS);
            boolean bl2 = SwitchBoard.isInBucket(context, jSONObject3.getInt(KEY_MIN), jSONObject3.getInt(KEY_MAX));
            if (DEBUG) {
                Log.d((String)TAG, (String)(string + " = " + bl2));
            }
            return bl2;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    private static List<String> getExperimentNames(Context context) throws JSONException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = Preferences.getDynamicConfigJson(context);
        JSONArray jSONArray = new JSONObject(string).getJSONArray(KEY_DATA);
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            arrayList.add(jSONObject.getString(KEY_NAME));
        }
        return arrayList;
    }

    @Nullable
    private static JSONObject getExperiment(Context context, String string) throws JSONException {
        String string2 = Preferences.getDynamicConfigJson(context);
        JSONArray jSONArray = new JSONObject(string2).getJSONArray(KEY_DATA);
        JSONObject jSONObject = null;
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            if (!jSONObject2.getString(KEY_NAME).equals(string)) continue;
            jSONObject = jSONObject2;
            break;
        }
        return jSONObject;
    }

    private static boolean isMatch(Context context, @Nullable JSONObject jSONObject) {
        String string;
        if (jSONObject == null) {
            return true;
        }
        if (jSONObject.has(KEY_APP_ID)) {
            string = context.getPackageName();
            try {
                if (!string.matches(jSONObject.getString(KEY_APP_ID))) {
                    return false;
                }
            }
            catch (JSONException jSONException) {
                Log.e((String)TAG, (String)"Exception matching appId", (Throwable)jSONException);
            }
        }
        if (jSONObject.has(KEY_COUNTRY)) {
            try {
                string = Locale.getDefault().getISO3Country();
                if (!string.matches(jSONObject.getString(KEY_COUNTRY))) {
                    return false;
                }
            }
            catch (MissingResourceException | JSONException throwable) {
                Log.e((String)TAG, (String)"Exception matching country", (Throwable)throwable);
            }
        }
        if (jSONObject.has(KEY_DEVICE)) {
            string = Build.DEVICE;
            try {
                if (!string.matches(jSONObject.getString(KEY_DEVICE))) {
                    return false;
                }
            }
            catch (JSONException jSONException) {
                Log.e((String)TAG, (String)"Exception matching device", (Throwable)jSONException);
            }
        }
        if (jSONObject.has(KEY_LANG)) {
            try {
                string = Locale.getDefault().getISO3Language();
                if (!string.matches(jSONObject.getString(KEY_LANG))) {
                    return false;
                }
            }
            catch (MissingResourceException | JSONException throwable) {
                Log.e((String)TAG, (String)"Exception matching lang", (Throwable)throwable);
            }
        }
        if (jSONObject.has(KEY_MANUFACTURER)) {
            string = Build.MANUFACTURER;
            try {
                if (!string.matches(jSONObject.getString(KEY_MANUFACTURER))) {
                    return false;
                }
            }
            catch (JSONException jSONException) {
                Log.e((String)TAG, (String)"Exception matching manufacturer", (Throwable)jSONException);
            }
        }
        if (jSONObject.has(KEY_VERSION)) {
            try {
                string = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
                if (!string.matches(jSONObject.getString(KEY_VERSION))) {
                    return false;
                }
            }
            catch (PackageManager.NameNotFoundException | JSONException throwable) {
                Log.e((String)TAG, (String)"Exception matching version", (Throwable)throwable);
            }
        }
        return true;
    }

    public static List<String> getActiveExperiments(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = Preferences.getDynamicConfigJson(context);
        if (string == null) {
            return arrayList;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            List<String> list = SwitchBoard.getExperimentNames(context);
            for (int i = 0; i < list.size(); ++i) {
                String string2 = list.get(i);
                Boolean bl = Preferences.getOverrideValue(context, string2);
                if (bl == null) {
                    bl = SwitchBoard.isInExperiment(context, string2);
                }
                if (!bl.booleanValue()) continue;
                arrayList.add(string2);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return arrayList;
    }

    public static boolean hasExperimentValues(Context context, String string) {
        return SwitchBoard.getExperimentValuesFromJson(context, string) != null;
    }

    @Nullable
    public static JSONObject getExperimentValuesFromJson(Context context, String string) {
        String string2 = Preferences.getDynamicConfigJson(context);
        if (string2 == null) {
            return null;
        }
        try {
            JSONObject jSONObject = SwitchBoard.getExperiment(context, string);
            if (jSONObject == null) {
                return null;
            }
            return jSONObject.getJSONObject(KEY_VALUES);
        }
        catch (JSONException jSONException) {
            Log.e((String)TAG, (String)"Could not create JSON object from config string", (Throwable)jSONException);
            return null;
        }
    }

    @Nullable
    private static String readFromUrlGET(URL uRL) {
        try {
            String string;
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setUseCaches(false);
            InputStream inputStream = httpURLConnection.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader, 8192);
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
            bufferedReader.close();
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private static int getUserBucket(Context context) {
        DeviceUuidFactory deviceUuidFactory = new DeviceUuidFactory(context);
        String string = deviceUuidFactory.getDeviceUuid().toString();
        CRC32 cRC32 = new CRC32();
        cRC32.update(string.getBytes());
        long l = cRC32.getValue();
        return (int)(l % 100L);
    }
}

