/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.view.MenuItem;
import android.view.View;
import android.widget.Toast;
import org.mozilla.gecko.ActionModeCompatView;
import org.mozilla.gecko.menu.GeckoMenu;
import org.mozilla.gecko.menu.GeckoMenuItem;
import org.mozilla.gecko.widget.GeckoPopupMenu;

class ActionModeCompat
implements GeckoPopupMenu.OnMenuItemClickListener,
GeckoPopupMenu.OnMenuItemLongClickListener,
View.OnClickListener {
    private final String LOGTAG = "GeckoActionModeCompat";
    private final Callback mCallback;
    private final ActionModeCompatView mView;
    private final Presenter mPresenter;

    public ActionModeCompat(Presenter presenter, Callback callback, ActionModeCompatView actionModeCompatView) {
        this.mPresenter = presenter;
        this.mCallback = callback;
        this.mView = actionModeCompatView;
        this.mView.initForMode(this);
    }

    public void finish() {
        GeckoMenu geckoMenu = this.mView.getMenu();
        geckoMenu.clear();
        geckoMenu.close();
        if (this.mCallback != null) {
            this.mCallback.onDestroyActionMode(this);
        }
    }

    public CharSequence getTitle() {
        return this.mView.getTitle();
    }

    public void setTitle(CharSequence charSequence) {
        this.mView.setTitle(charSequence);
    }

    public void setTitle(int n) {
        this.mView.setTitle(n);
    }

    public GeckoMenu getMenu() {
        return this.mView.getMenu();
    }

    public void invalidate() {
        if (this.mCallback != null) {
            this.mCallback.onPrepareActionMode(this, this.mView.getMenu());
        }
        this.mView.invalidate();
    }

    public void animateIn() {
        this.mView.animateIn();
    }

    @Override
    public boolean onMenuItemClick(MenuItem menuItem) {
        if (this.mCallback != null) {
            return this.mCallback.onActionItemClicked(this, menuItem);
        }
        return false;
    }

    @Override
    public boolean onMenuItemLongClick(MenuItem menuItem) {
        this.showTooltip((GeckoMenuItem)menuItem);
        return true;
    }

    public void onClick(View view) {
        this.mPresenter.endActionModeCompat();
    }

    private void showTooltip(GeckoMenuItem geckoMenuItem) {
        int[] nArray = new int[2];
        View view = geckoMenuItem.getActionView();
        view.getLocationOnScreen(nArray);
        int n = nArray[0] - view.getWidth();
        int n2 = nArray[1] + view.getHeight() / 2;
        Toast toast = Toast.makeText((Context)view.getContext(), (CharSequence)geckoMenuItem.getTitle(), (int)0);
        toast.setGravity(51, n, n2);
        toast.show();
    }

    public static interface Presenter {
        public void startActionModeCompat(Callback var1);

        public void endActionModeCompat();
    }

    public static interface Callback {
        public boolean onCreateActionMode(ActionModeCompat var1, GeckoMenu var2);

        public boolean onPrepareActionMode(ActionModeCompat var1, GeckoMenu var2);

        public boolean onActionItemClicked(ActionModeCompat var1, MenuItem var2);

        public void onDestroyActionMode(ActionModeCompat var1);
    }
}

