/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.Arrays;
import java.util.Collection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.R;
import org.mozilla.gecko.gfx.FloatSize;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.SwipeDismissListViewTouchListener;

public class FormAssistPopup
extends RelativeLayout
implements GeckoEventListener {
    private final Context mContext;
    private final Animation mAnimation;
    private ListView mAutoCompleteList;
    private RelativeLayout mValidationMessage;
    private TextView mValidationMessageText;
    private ImageView mValidationMessageArrow;
    private ImageView mValidationMessageArrowInverted;
    private double mX;
    private double mY;
    private double mW;
    private double mH;
    private PopupType mPopupType;
    private static final int MAX_VISIBLE_ROWS = 5;
    private static int sAutoCompleteMinWidth;
    private static int sAutoCompleteRowHeight;
    private static int sValidationMessageHeight;
    private static int sValidationTextMarginTop;
    private static RelativeLayout.LayoutParams sValidationTextLayoutNormal;
    private static RelativeLayout.LayoutParams sValidationTextLayoutInverted;
    private static final String LOGTAG = "GeckoFormAssistPopup";
    private static final Collection<String> sInputMethodBlocklist;

    public FormAssistPopup(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
        this.mAnimation = AnimationUtils.loadAnimation((Context)context, (int)R.anim.grow_fade_in);
        this.mAnimation.setDuration(75L);
        this.setFocusable(false);
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "FormAssist:AutoComplete", "FormAssist:ValidationMessage", "FormAssist:Hide");
    }

    void destroy() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "FormAssist:AutoComplete", "FormAssist:ValidationMessage", "FormAssist:Hide");
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            if (string2.equals("FormAssist:AutoComplete")) {
                this.handleAutoCompleteMessage(jSONObject);
            } else if (string2.equals("FormAssist:ValidationMessage")) {
                this.handleValidationMessage(jSONObject);
            } else if (string2.equals("FormAssist:Hide")) {
                this.handleHideMessage(jSONObject);
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)exception);
        }
    }

    private void handleAutoCompleteMessage(JSONObject jSONObject) throws JSONException {
        final JSONArray jSONArray = jSONObject.getJSONArray("suggestions");
        final JSONObject jSONObject2 = jSONObject.getJSONObject("rect");
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                FormAssistPopup.this.showAutoCompleteSuggestions(jSONArray, jSONObject2);
            }
        });
    }

    private void handleValidationMessage(JSONObject jSONObject) throws JSONException {
        final String string2 = jSONObject.getString("validationMessage");
        final JSONObject jSONObject2 = jSONObject.getJSONObject("rect");
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                FormAssistPopup.this.showValidationMessage(string2, jSONObject2);
            }
        });
    }

    private void handleHideMessage(JSONObject jSONObject) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                FormAssistPopup.this.hide();
            }
        });
    }

    private void showAutoCompleteSuggestions(JSONArray jSONArray, JSONObject jSONObject) {
        Object object;
        if (this.mAutoCompleteList == null) {
            object = LayoutInflater.from((Context)this.mContext);
            this.mAutoCompleteList = (ListView)object.inflate(R.layout.autocomplete_list, null);
            this.mAutoCompleteList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                    TextView textView = (TextView)view;
                    String string2 = (String)textView.getTag();
                    FormAssistPopup.broadcastGeckoEvent("FormAssist:AutoComplete", string2);
                    FormAssistPopup.this.hide();
                }
            });
            SwipeDismissListViewTouchListener swipeDismissListViewTouchListener = new SwipeDismissListViewTouchListener(this.mAutoCompleteList, new SwipeDismissListViewTouchListener.OnDismissCallback(){

                @Override
                public void onDismiss(ListView listView, int n) {
                    AutoCompleteListAdapter autoCompleteListAdapter = (AutoCompleteListAdapter)listView.getAdapter();
                    Pair pair = (Pair)autoCompleteListAdapter.getItem(n);
                    FormAssistPopup.broadcastGeckoEvent("FormAssist:Remove", (String)pair.second);
                    autoCompleteListAdapter.remove(pair);
                    autoCompleteListAdapter.notifyDataSetChanged();
                    FormAssistPopup.this.positionAndShowPopup();
                }
            });
            this.mAutoCompleteList.setOnTouchListener((View.OnTouchListener)swipeDismissListViewTouchListener);
            this.mAutoCompleteList.setOnScrollListener(swipeDismissListViewTouchListener.makeScrollListener());
            this.mAutoCompleteList.setRecyclerListener(swipeDismissListViewTouchListener.makeRecyclerListener());
            this.addView((View)this.mAutoCompleteList);
        }
        object = new AutoCompleteListAdapter(this.mContext, R.layout.autocomplete_list_item);
        ((AutoCompleteListAdapter)((Object)object)).populateSuggestionsList(jSONArray);
        this.mAutoCompleteList.setAdapter((ListAdapter)object);
        if (this.setGeckoPositionData(jSONObject, true)) {
            this.positionAndShowPopup();
        }
    }

    private void showValidationMessage(String string2, JSONObject jSONObject) {
        if (this.mValidationMessage == null) {
            LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mContext);
            this.mValidationMessage = (RelativeLayout)layoutInflater.inflate(R.layout.validation_message, null);
            this.addView((View)this.mValidationMessage);
            this.mValidationMessageText = (TextView)this.mValidationMessage.findViewById(R.id.validation_message_text);
            sValidationTextMarginTop = (int)this.mContext.getResources().getDimension(R.dimen.validation_message_margin_top);
            sValidationTextLayoutNormal = new RelativeLayout.LayoutParams(this.mValidationMessageText.getLayoutParams());
            sValidationTextLayoutNormal.setMargins(0, sValidationTextMarginTop, 0, 0);
            sValidationTextLayoutInverted = new RelativeLayout.LayoutParams((ViewGroup.MarginLayoutParams)sValidationTextLayoutNormal);
            sValidationTextLayoutInverted.setMargins(0, 0, 0, 0);
            this.mValidationMessageArrow = (ImageView)this.mValidationMessage.findViewById(R.id.validation_message_arrow);
            this.mValidationMessageArrowInverted = (ImageView)this.mValidationMessage.findViewById(R.id.validation_message_arrow_inverted);
        }
        this.mValidationMessageText.setText((CharSequence)string2);
        this.mValidationMessageText.setSelected(true);
        if (this.setGeckoPositionData(jSONObject, false)) {
            this.positionAndShowPopup();
        }
    }

    private boolean setGeckoPositionData(JSONObject jSONObject, boolean bl) {
        try {
            this.mX = jSONObject.getDouble("x");
            this.mY = jSONObject.getDouble("y");
            this.mW = jSONObject.getDouble("w");
            this.mH = jSONObject.getDouble("h");
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error getting FormAssistPopup dimensions", (Throwable)jSONException);
            return false;
        }
        this.mPopupType = bl ? PopupType.AUTOCOMPLETE : PopupType.VALIDATIONMESSAGE;
        return true;
    }

    private void positionAndShowPopup() {
        this.positionAndShowPopup(GeckoAppShell.getLayerView().getViewportMetrics());
    }

    private void positionAndShowPopup(ImmutableViewportMetrics immutableViewportMetrics) {
        int n;
        int n2;
        ThreadUtils.assertOnUiThread();
        InputMethodManager inputMethodManager = (InputMethodManager)this.mContext.getSystemService("input_method");
        if (inputMethodManager.isFullscreenMode()) {
            return;
        }
        if (this.mAutoCompleteList != null) {
            this.mAutoCompleteList.setVisibility(this.mPopupType == PopupType.AUTOCOMPLETE ? 0 : 8);
        }
        if (this.mValidationMessage != null) {
            this.mValidationMessage.setVisibility(this.mPopupType == PopupType.AUTOCOMPLETE ? 8 : 0);
        }
        if (sAutoCompleteMinWidth == 0) {
            Resources resources = this.mContext.getResources();
            sAutoCompleteMinWidth = (int)resources.getDimension(R.dimen.autocomplete_min_width);
            sAutoCompleteRowHeight = (int)resources.getDimension(R.dimen.autocomplete_row_height);
            sValidationMessageHeight = (int)resources.getDimension(R.dimen.validation_message_height);
        }
        float f = immutableViewportMetrics.zoomFactor;
        int n3 = (int)(this.mX * (double)f - (double)immutableViewportMetrics.viewportRectLeft);
        int n4 = (int)(this.mY * (double)f - (double)immutableViewportMetrics.viewportRectTop + (double)GeckoAppShell.getLayerView().getSurfaceTranslation());
        int n5 = (int)(this.mW * (double)f);
        int n6 = (int)(this.mH * (double)f);
        int n7 = -1;
        int n8 = n3 < 0 ? 0 : n3;
        FloatSize floatSize = immutableViewportMetrics.getSize();
        if (this.mPopupType == PopupType.AUTOCOMPLETE && (float)(n3 + n5) < floatSize.width) {
            int n9 = n7 = n3 < 0 ? n3 + n5 : n5;
            if (n7 < sAutoCompleteMinWidth && (float)(n8 + (n7 = sAutoCompleteMinWidth)) > floatSize.width) {
                n8 = (int)(floatSize.width - (float)n7);
            }
        }
        if (this.mPopupType == PopupType.AUTOCOMPLETE) {
            n2 = this.mAutoCompleteList.getAdapter().getCount();
            if (n2 > 5) {
                n2 = 5;
            }
            n = sAutoCompleteRowHeight * n2;
        } else {
            n = sValidationMessageHeight;
        }
        n2 = n4 + n6;
        if (this.mPopupType == PopupType.VALIDATIONMESSAGE) {
            this.mValidationMessageText.setLayoutParams((ViewGroup.LayoutParams)sValidationTextLayoutNormal);
            this.mValidationMessageArrow.setVisibility(0);
            this.mValidationMessageArrowInverted.setVisibility(8);
        }
        if ((float)(n2 + n) > floatSize.height) {
            if (floatSize.height - (float)n2 > (float)n4) {
                n = (int)(floatSize.height - (float)n2);
            } else {
                if (n < n4) {
                    n2 = n4 - n;
                } else {
                    n2 = 0;
                    n = n4;
                }
                if (this.mPopupType == PopupType.VALIDATIONMESSAGE) {
                    this.mValidationMessageText.setLayoutParams((ViewGroup.LayoutParams)sValidationTextLayoutInverted);
                    this.mValidationMessageArrow.setVisibility(8);
                    this.mValidationMessageArrowInverted.setVisibility(0);
                }
            }
        }
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(n7, n);
        layoutParams.setMargins(n8, n2, 0, 0);
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
        if (!this.isShown()) {
            this.setVisibility(0);
            this.startAnimation(this.mAnimation);
        }
    }

    public void hide() {
        if (this.isShown()) {
            this.setVisibility(8);
            FormAssistPopup.broadcastGeckoEvent("FormAssist:Hidden", null);
        }
    }

    void onInputMethodChanged(String string2) {
        boolean bl = sInputMethodBlocklist.contains(string2);
        FormAssistPopup.broadcastGeckoEvent("FormAssist:Blocklisted", String.valueOf(bl));
    }

    void onTranslationChanged() {
        ThreadUtils.assertOnUiThread();
        if (!this.isShown()) {
            return;
        }
        this.positionAndShowPopup();
    }

    void onMetricsChanged(final ImmutableViewportMetrics immutableViewportMetrics) {
        if (!this.isShown()) {
            return;
        }
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                FormAssistPopup.this.positionAndShowPopup(immutableViewportMetrics);
            }
        });
    }

    private static void broadcastGeckoEvent(String string2, String string3) {
        GeckoAppShell.notifyObservers(string2, string3);
    }

    static {
        sInputMethodBlocklist = Arrays.asList("com.google.android.inputmethod.japanese/.MozcService", "com.owplus.ime.openwnnplus/.OpenWnnJAJP", "com.adamrocker.android.input.simeji/.OpenWnnSimeji", "com.swype.android.inputmethod/.SwypeInputMethod", "com.nuance.swype.input/.IME");
    }

    private class AutoCompleteListAdapter
    extends ArrayAdapter<Pair<String, String>> {
        private final LayoutInflater mInflater;
        private final int mTextViewResourceId;

        public AutoCompleteListAdapter(Context context, int n) {
            super(context, n);
            this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
            this.mTextViewResourceId = n;
        }

        public void populateSuggestionsList(JSONArray jSONArray) {
            try {
                for (int i = 0; i < jSONArray.length(); ++i) {
                    JSONObject jSONObject = jSONArray.getJSONObject(i);
                    String string2 = jSONObject.getString("label");
                    String string3 = jSONObject.getString("value");
                    this.add(new Pair((Object)string2, (Object)string3));
                }
            }
            catch (JSONException jSONException) {
                Log.e((String)FormAssistPopup.LOGTAG, (String)"JSONException", (Throwable)jSONException);
            }
        }

        public View getView(int n, View view, ViewGroup viewGroup) {
            if (view == null) {
                view = this.mInflater.inflate(this.mTextViewResourceId, null);
            }
            Pair pair = (Pair)this.getItem(n);
            TextView textView = (TextView)view;
            textView.setText((CharSequence)pair.first);
            textView.setTag(pair.second);
            return view;
        }
    }

    private static enum PopupType {
        AUTOCOMPLETE,
        VALIDATIONMESSAGE;

    }
}

