/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.SystemClock;
import android.util.Log;
import android.util.SparseArray;
import android.view.MotionEvent;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.annotation.JNITarget;
import org.mozilla.gecko.gfx.DisplayPortMetrics;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;

@JNITarget
public class GeckoEvent {
    private static final String LOGTAG = "GeckoEvent";
    private static final int EVENT_FACTORY_SIZE = 5;
    private static final SparseArray<ArrayBlockingQueue<GeckoEvent>> mEvents = new SparseArray();
    public static final int ACTION_MAGNIFY_START = 11;
    public static final int ACTION_MAGNIFY = 12;
    public static final int ACTION_MAGNIFY_END = 13;
    public static final int ACTION_GAMEPAD_ADDED = 1;
    public static final int ACTION_GAMEPAD_REMOVED = 2;
    public static final int ACTION_GAMEPAD_BUTTON = 1;
    public static final int ACTION_GAMEPAD_AXES = 2;
    private final int mType;
    private int mAction;
    private long mTime;
    private Point[] mPoints;
    private int[] mPointIndicies;
    private int mPointerIndex;
    private float[] mOrientations;
    private float[] mPressures;
    private int[] mToolTypes;
    private Point[] mPointRadii;
    private Rect mRect;
    private double mX;
    private double mY;
    private double mZ;
    private double mW;
    private int mMetaState;
    private int mFlags;
    private int mCount;
    private String mCharacters;
    private String mCharactersExtra;
    private String mData;
    private ByteBuffer mBuffer;
    private int mWidth;
    private int mHeight;
    private int mID;
    private int mGamepadButton;
    private boolean mGamepadButtonPressed;
    private float mGamepadButtonValue;
    private float[] mGamepadValues;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeckoEvent get(NativeGeckoEvent nativeGeckoEvent) {
        SparseArray<ArrayBlockingQueue<GeckoEvent>> sparseArray = mEvents;
        synchronized (sparseArray) {
            ArrayBlockingQueue arrayBlockingQueue = (ArrayBlockingQueue)mEvents.get(nativeGeckoEvent.value);
            if (arrayBlockingQueue != null && arrayBlockingQueue.size() > 0) {
                return (GeckoEvent)arrayBlockingQueue.poll();
            }
        }
        return new GeckoEvent(nativeGeckoEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        SparseArray<ArrayBlockingQueue<GeckoEvent>> sparseArray = mEvents;
        synchronized (sparseArray) {
            ArrayBlockingQueue<GeckoEvent> arrayBlockingQueue = (ArrayBlockingQueue<GeckoEvent>)mEvents.get(this.mType);
            if (arrayBlockingQueue == null) {
                arrayBlockingQueue = new ArrayBlockingQueue<GeckoEvent>(5);
                mEvents.put(this.mType, arrayBlockingQueue);
            }
            arrayBlockingQueue.offer(this);
        }
    }

    private GeckoEvent(NativeGeckoEvent nativeGeckoEvent) {
        this.mType = nativeGeckoEvent.value;
    }

    public static GeckoEvent createNoOpEvent() {
        return GeckoEvent.get(NativeGeckoEvent.NOOP);
    }

    private static boolean isGamepadButton(int n) {
        switch (n) {
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: {
                return true;
            }
        }
        return false;
    }

    public static GeckoEvent createNativeGestureEvent(int n, PointF pointF, double d) {
        try {
            GeckoEvent geckoEvent = GeckoEvent.get(NativeGeckoEvent.NATIVE_GESTURE_EVENT);
            geckoEvent.mAction = n;
            geckoEvent.mCount = 1;
            geckoEvent.mPoints = new Point[1];
            PointF pointF2 = new PointF(pointF.x, pointF.y);
            pointF2 = GeckoAppShell.getLayerView().convertViewPointToLayerPoint(pointF2);
            if (pointF2 == null) {
                return null;
            }
            geckoEvent.mPoints[0] = new Point((int)Math.floor(pointF2.x), (int)Math.floor(pointF2.y));
            geckoEvent.mX = d;
            geckoEvent.mTime = System.currentTimeMillis();
            return geckoEvent;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static GeckoEvent createMotionEvent(MotionEvent motionEvent, boolean bl) {
        GeckoEvent geckoEvent = GeckoEvent.get(NativeGeckoEvent.MOTION_EVENT);
        geckoEvent.initMotionEvent(motionEvent, bl);
        return geckoEvent;
    }

    public static GeckoEvent createLongPressEvent(MotionEvent motionEvent) {
        GeckoEvent geckoEvent = GeckoEvent.get(NativeGeckoEvent.LONG_PRESS);
        geckoEvent.initMotionEvent(motionEvent, false);
        return geckoEvent;
    }

    private void initMotionEvent(MotionEvent motionEvent, boolean bl) {
        this.mAction = motionEvent.getActionMasked();
        this.mTime = System.currentTimeMillis() - SystemClock.elapsedRealtime() + motionEvent.getEventTime();
        this.mMetaState = motionEvent.getMetaState();
        switch (this.mAction) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                this.mCount = motionEvent.getPointerCount();
                this.mPoints = new Point[this.mCount];
                this.mPointIndicies = new int[this.mCount];
                this.mOrientations = new float[this.mCount];
                this.mPressures = new float[this.mCount];
                this.mToolTypes = new int[this.mCount];
                this.mPointRadii = new Point[this.mCount];
                this.mPointerIndex = motionEvent.getActionIndex();
                for (int i = 0; i < this.mCount; ++i) {
                    this.addMotionPoint(i, i, motionEvent, bl);
                }
                break;
            }
            default: {
                this.mCount = 0;
                this.mPointerIndex = -1;
                this.mPoints = new Point[this.mCount];
                this.mPointIndicies = new int[this.mCount];
                this.mOrientations = new float[this.mCount];
                this.mPressures = new float[this.mCount];
                this.mToolTypes = new int[this.mCount];
                this.mPointRadii = new Point[this.mCount];
            }
        }
    }

    private void addMotionPoint(int n, int n2, MotionEvent motionEvent, boolean bl) {
        try {
            PointF pointF = new PointF(motionEvent.getX(n2), motionEvent.getY(n2));
            if (!bl) {
                pointF = GeckoAppShell.getLayerView().convertViewPointToLayerPoint(pointF);
            }
            this.mPoints[n] = new Point((int)Math.floor(pointF.x), (int)Math.floor(pointF.y));
            this.mPointIndicies[n] = motionEvent.getPointerId(n2);
            double d = motionEvent.getOrientation(n2);
            this.mOrientations[n] = (float)Math.toDegrees(d);
            if (this.mOrientations[n] == 90.0f) {
                this.mOrientations[n] = -90.0f;
            }
            if (this.mOrientations[n] < 0.0f) {
                int n3 = n;
                this.mOrientations[n3] = this.mOrientations[n3] + 90.0f;
                this.mPointRadii[n] = new Point((int)motionEvent.getToolMajor(n2) / 2, (int)motionEvent.getToolMinor(n2) / 2);
            } else {
                this.mPointRadii[n] = new Point((int)motionEvent.getToolMinor(n2) / 2, (int)motionEvent.getToolMajor(n2) / 2);
            }
            if (!bl) {
                float f = GeckoAppShell.getLayerView().getViewportMetrics().zoomFactor;
                this.mPointRadii[n].x = (int)((float)this.mPointRadii[n].x / f);
                this.mPointRadii[n].y = (int)((float)this.mPointRadii[n].y / f);
            }
            this.mPressures[n] = motionEvent.getPressure(n2);
            if (AppConstants.Versions.feature14Plus) {
                this.mToolTypes[n] = motionEvent.getToolType(n);
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Error creating motion point " + n), (Throwable)exception);
            this.mPointRadii[n] = new Point(0, 0);
            this.mPoints[n] = new Point(0, 0);
        }
    }

    public static GeckoEvent createViewportEvent(ImmutableViewportMetrics immutableViewportMetrics, DisplayPortMetrics displayPortMetrics) {
        GeckoEvent geckoEvent = GeckoEvent.get(NativeGeckoEvent.VIEWPORT);
        geckoEvent.mCharacters = "Viewport:Change";
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("{ \"x\" : ").append(immutableViewportMetrics.viewportRectLeft).append(", \"y\" : ").append(immutableViewportMetrics.viewportRectTop).append(", \"zoom\" : ").append(immutableViewportMetrics.zoomFactor).append(", \"displayPort\" :").append(displayPortMetrics.toJSON()).append('}');
        geckoEvent.mCharactersExtra = stringBuilder.toString();
        return geckoEvent;
    }

    public static GeckoEvent createZoomedViewEvent(int n, int n2, int n3, int n4, int n5, float f, ByteBuffer byteBuffer) {
        GeckoEvent geckoEvent = GeckoEvent.get(NativeGeckoEvent.ZOOMEDVIEW);
        geckoEvent.mPoints = new Point[2];
        geckoEvent.mPoints[0] = new Point(n2, n3);
        geckoEvent.mPoints[1] = new Point(n4, n5);
        geckoEvent.mX = f;
        geckoEvent.mMetaState = n;
        geckoEvent.mBuffer = byteBuffer;
        return geckoEvent;
    }

    public static GeckoEvent createCallObserverEvent(String string2, String string3, String string4) {
        GeckoEvent geckoEvent = GeckoEvent.get(NativeGeckoEvent.CALL_OBSERVER);
        geckoEvent.mCharacters = string2;
        geckoEvent.mCharactersExtra = string3;
        geckoEvent.mData = string4;
        return geckoEvent;
    }

    public static GeckoEvent createRemoveObserverEvent(String string2) {
        GeckoEvent geckoEvent = GeckoEvent.get(NativeGeckoEvent.REMOVE_OBSERVER);
        geckoEvent.mCharacters = string2;
        return geckoEvent;
    }

    public static GeckoEvent createLowMemoryEvent(int n) {
        GeckoEvent geckoEvent = GeckoEvent.get(NativeGeckoEvent.LOW_MEMORY);
        geckoEvent.mMetaState = n;
        return geckoEvent;
    }

    public static GeckoEvent createTelemetryHistogramAddEvent(String string2, int n) {
        GeckoEvent geckoEvent = GeckoEvent.get(NativeGeckoEvent.TELEMETRY_HISTOGRAM_ADD);
        geckoEvent.mCharacters = string2;
        geckoEvent.mCharactersExtra = null;
        geckoEvent.mCount = n;
        return geckoEvent;
    }

    public static GeckoEvent createTelemetryKeyedHistogramAddEvent(String string2, String string3, int n) {
        GeckoEvent geckoEvent = GeckoEvent.get(NativeGeckoEvent.TELEMETRY_HISTOGRAM_ADD);
        geckoEvent.mCharacters = string2;
        geckoEvent.mCharactersExtra = string3;
        geckoEvent.mCount = n;
        return geckoEvent;
    }

    public static GeckoEvent createTelemetryUISessionStartEvent(String string2, long l) {
        GeckoEvent geckoEvent = GeckoEvent.get(NativeGeckoEvent.TELEMETRY_UI_SESSION_START);
        geckoEvent.mCharacters = string2;
        geckoEvent.mTime = l;
        return geckoEvent;
    }

    public static GeckoEvent createTelemetryUISessionStopEvent(String string2, String string3, long l) {
        GeckoEvent geckoEvent = GeckoEvent.get(NativeGeckoEvent.TELEMETRY_UI_SESSION_STOP);
        geckoEvent.mCharacters = string2;
        geckoEvent.mCharactersExtra = string3;
        geckoEvent.mTime = l;
        return geckoEvent;
    }

    public static GeckoEvent createTelemetryUIEvent(String string2, String string3, long l, String string4) {
        GeckoEvent geckoEvent = GeckoEvent.get(NativeGeckoEvent.TELEMETRY_UI_EVENT);
        geckoEvent.mData = string2;
        geckoEvent.mCharacters = string3;
        geckoEvent.mCharactersExtra = string4;
        geckoEvent.mTime = l;
        return geckoEvent;
    }

    public static GeckoEvent createGamepadAddRemoveEvent(int n, boolean bl) {
        GeckoEvent geckoEvent = GeckoEvent.get(NativeGeckoEvent.GAMEPAD_ADDREMOVE);
        geckoEvent.mID = n;
        geckoEvent.mAction = bl ? 1 : 2;
        return geckoEvent;
    }

    private static int boolArrayToBitfield(boolean[] blArray) {
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            n |= 1 << i;
        }
        return n;
    }

    public static GeckoEvent createGamepadButtonEvent(int n, int n2, boolean bl, float f) {
        GeckoEvent geckoEvent = GeckoEvent.get(NativeGeckoEvent.GAMEPAD_DATA);
        geckoEvent.mID = n;
        geckoEvent.mAction = 1;
        geckoEvent.mGamepadButton = n2;
        geckoEvent.mGamepadButtonPressed = bl;
        geckoEvent.mGamepadButtonValue = f;
        return geckoEvent;
    }

    public static GeckoEvent createGamepadAxisEvent(int n, boolean[] blArray, float[] fArray) {
        GeckoEvent geckoEvent = GeckoEvent.get(NativeGeckoEvent.GAMEPAD_DATA);
        geckoEvent.mID = n;
        geckoEvent.mAction = 2;
        geckoEvent.mFlags = GeckoEvent.boolArrayToBitfield(blArray);
        geckoEvent.mCount = fArray.length;
        geckoEvent.mGamepadValues = fArray;
        return geckoEvent;
    }

    @JNITarget
    public static enum NativeGeckoEvent {
        NATIVE_POKE(0),
        MOTION_EVENT(2),
        NOOP(15),
        VIEWPORT(20),
        NATIVE_GESTURE_EVENT(31),
        CALL_OBSERVER(33),
        REMOVE_OBSERVER(34),
        LOW_MEMORY(35),
        TELEMETRY_HISTOGRAM_ADD(37),
        TELEMETRY_UI_SESSION_START(42),
        TELEMETRY_UI_SESSION_STOP(43),
        TELEMETRY_UI_EVENT(44),
        GAMEPAD_ADDREMOVE(45),
        GAMEPAD_DATA(46),
        LONG_PRESS(47),
        ZOOMEDVIEW(48);

        public final int value;

        private NativeGeckoEvent(int n2) {
            this.value = n2;
        }
    }
}

