/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.content.res.Configuration;
import android.util.Log;
import java.util.Arrays;
import java.util.List;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.annotation.WrapForJNI;

public class GeckoScreenOrientation {
    private static final String LOGTAG = "GeckoScreenOrientation";
    private static GeckoScreenOrientation sInstance;
    private static final ScreenOrientation DEFAULT_SCREEN_ORIENTATION;
    private static final int DEFAULT_ROTATION = 0;
    private ScreenOrientation mDefaultScreenOrientation;
    private ScreenOrientation mScreenOrientation;
    private boolean mShouldNotify = true;
    private static final String DEFAULT_SCREEN_ORIENTATION_PREF = "app.orientation.default";

    public GeckoScreenOrientation() {
        PrefsHelper.getPref(DEFAULT_SCREEN_ORIENTATION_PREF, new PrefsHelper.PrefHandlerBase(){

            @Override
            public void prefValue(String string2, String string3) {
                GeckoScreenOrientation.this.mDefaultScreenOrientation = GeckoScreenOrientation.screenOrientationFromArrayString(string3);
                GeckoScreenOrientation.this.setRequestedOrientation(GeckoScreenOrientation.this.mDefaultScreenOrientation);
            }
        });
        this.mDefaultScreenOrientation = DEFAULT_SCREEN_ORIENTATION;
        this.update();
    }

    public static GeckoScreenOrientation getInstance() {
        if (sInstance == null) {
            sInstance = new GeckoScreenOrientation();
        }
        return sInstance;
    }

    public void enableNotifications() {
        this.update();
        this.mShouldNotify = true;
    }

    public void disableNotifications() {
        this.mShouldNotify = false;
    }

    public boolean update() {
        Activity activity = this.getActivity();
        if (activity == null) {
            return false;
        }
        Configuration configuration = activity.getResources().getConfiguration();
        return this.update(configuration.orientation);
    }

    public boolean update(int n) {
        return this.update(this.getScreenOrientation(n, this.getRotation()));
    }

    @WrapForJNI
    private static native void onOrientationChange(short var0, short var1);

    public boolean update(ScreenOrientation screenOrientation) {
        if (this.mScreenOrientation == screenOrientation) {
            return false;
        }
        this.mScreenOrientation = screenOrientation;
        Log.d((String)LOGTAG, (String)("updating to new orientation " + (Object)((Object)this.mScreenOrientation)));
        if (this.mShouldNotify) {
            if (screenOrientation == ScreenOrientation.PORTRAIT) {
                screenOrientation = ScreenOrientation.PORTRAIT_PRIMARY;
            } else if (screenOrientation == ScreenOrientation.LANDSCAPE) {
                screenOrientation = ScreenOrientation.LANDSCAPE_PRIMARY;
            }
            if (GeckoThread.isRunning()) {
                GeckoScreenOrientation.onOrientationChange(screenOrientation.value, this.getAngle());
            } else {
                GeckoThread.queueNativeCall(GeckoScreenOrientation.class, "onOrientationChange", screenOrientation.value, this.getAngle());
            }
        }
        GeckoAppShell.resetScreenSize();
        return true;
    }

    public int getAndroidOrientation() {
        return GeckoScreenOrientation.screenOrientationToAndroidOrientation(this.getScreenOrientation());
    }

    public ScreenOrientation getScreenOrientation() {
        return this.mScreenOrientation;
    }

    public void lock(int n) {
        this.lock(ScreenOrientation.get(n));
    }

    public boolean lock(ScreenOrientation screenOrientation) {
        Log.d((String)LOGTAG, (String)("locking to " + (Object)((Object)screenOrientation)));
        this.update(screenOrientation);
        return this.setRequestedOrientation(screenOrientation);
    }

    public boolean unlock() {
        Log.d((String)LOGTAG, (String)"unlocking");
        this.setRequestedOrientation(this.mDefaultScreenOrientation);
        return this.update();
    }

    private Activity getActivity() {
        if (GeckoAppShell.getGeckoInterface() == null) {
            return null;
        }
        return GeckoAppShell.getGeckoInterface().getActivity();
    }

    private boolean setRequestedOrientation(ScreenOrientation screenOrientation) {
        int n = GeckoScreenOrientation.screenOrientationToActivityInfoOrientation(screenOrientation);
        Activity activity = this.getActivity();
        if (activity == null) {
            Log.w((String)LOGTAG, (String)"setRequestOrientation: failed to get activity");
            return false;
        }
        if (activity.getRequestedOrientation() == n) {
            return false;
        }
        activity.setRequestedOrientation(n);
        return true;
    }

    private ScreenOrientation getScreenOrientation(int n, int n2) {
        boolean bl;
        boolean bl2 = bl = n2 == 0 || n2 == 1;
        if (n == 1) {
            if (bl) {
                return ScreenOrientation.PORTRAIT_PRIMARY;
            }
            return ScreenOrientation.PORTRAIT_SECONDARY;
        }
        if (n == 2) {
            if (bl) {
                return ScreenOrientation.LANDSCAPE_PRIMARY;
            }
            return ScreenOrientation.LANDSCAPE_SECONDARY;
        }
        return ScreenOrientation.NONE;
    }

    public short getAngle() {
        switch (this.getRotation()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        Log.w((String)LOGTAG, (String)"getAngle: unexpected rotation value");
        return 0;
    }

    private int getRotation() {
        Activity activity = this.getActivity();
        if (activity == null) {
            Log.w((String)LOGTAG, (String)"getRotation: failed to get activity");
            return 0;
        }
        return activity.getWindowManager().getDefaultDisplay().getRotation();
    }

    public static ScreenOrientation screenOrientationFromArrayString(String string2) {
        List<String> list = Arrays.asList(string2.split(","));
        if (list.size() == 0) {
            Log.w((String)LOGTAG, (String)"screenOrientationFromArrayString: no orientation in string");
            return DEFAULT_SCREEN_ORIENTATION;
        }
        return GeckoScreenOrientation.screenOrientationFromString(list.get(0));
    }

    public static ScreenOrientation screenOrientationFromString(String string2) {
        switch (string2) {
            case "portrait": {
                return ScreenOrientation.PORTRAIT;
            }
            case "landscape": {
                return ScreenOrientation.LANDSCAPE;
            }
            case "portrait-primary": {
                return ScreenOrientation.PORTRAIT_PRIMARY;
            }
            case "portrait-secondary": {
                return ScreenOrientation.PORTRAIT_SECONDARY;
            }
            case "landscape-primary": {
                return ScreenOrientation.LANDSCAPE_PRIMARY;
            }
            case "landscape-secondary": {
                return ScreenOrientation.LANDSCAPE_SECONDARY;
            }
        }
        Log.w((String)LOGTAG, (String)("screenOrientationFromString: unknown orientation string: " + string2));
        return DEFAULT_SCREEN_ORIENTATION;
    }

    public static int screenOrientationToAndroidOrientation(ScreenOrientation screenOrientation) {
        switch (screenOrientation) {
            case PORTRAIT: 
            case PORTRAIT_PRIMARY: 
            case PORTRAIT_SECONDARY: {
                return 1;
            }
            case LANDSCAPE: 
            case LANDSCAPE_PRIMARY: 
            case LANDSCAPE_SECONDARY: {
                return 2;
            }
        }
        return 0;
    }

    public static int screenOrientationToActivityInfoOrientation(ScreenOrientation screenOrientation) {
        switch (screenOrientation) {
            case PORTRAIT: 
            case PORTRAIT_PRIMARY: {
                return 1;
            }
            case PORTRAIT_SECONDARY: {
                return 9;
            }
            case LANDSCAPE: 
            case LANDSCAPE_PRIMARY: {
                return 0;
            }
            case LANDSCAPE_SECONDARY: {
                return 8;
            }
            case NONE: 
            case DEFAULT: {
                return -1;
            }
        }
        return 5;
    }

    static {
        DEFAULT_SCREEN_ORIENTATION = ScreenOrientation.DEFAULT;
    }

    public static enum ScreenOrientation {
        NONE(0),
        PORTRAIT_PRIMARY(1),
        PORTRAIT_SECONDARY(2),
        PORTRAIT(ScreenOrientation.PORTRAIT_PRIMARY.value | ScreenOrientation.PORTRAIT_SECONDARY.value),
        LANDSCAPE_PRIMARY(4),
        LANDSCAPE_SECONDARY(8),
        LANDSCAPE(ScreenOrientation.LANDSCAPE_PRIMARY.value | ScreenOrientation.LANDSCAPE_SECONDARY.value),
        DEFAULT(16);

        public final short value;
        private static final ScreenOrientation[] sValues;

        private ScreenOrientation(int n2) {
            this.value = (short)n2;
        }

        public static ScreenOrientation get(int n) {
            for (ScreenOrientation screenOrientation : sValues) {
                if (screenOrientation.value != n) continue;
                return screenOrientation;
            }
            return NONE;
        }

        static {
            sValues = ScreenOrientation.values();
        }
    }
}

