/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.util.Log;
import java.io.File;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.ServiceNotificationClient;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;

public class GeckoService
extends Service {
    private static final String LOGTAG = "GeckoService";
    private static final boolean DEBUG = false;
    private static final String INTENT_PROFILE_NAME = "org.mozilla.gecko.intent.PROFILE_NAME";
    private static final String INTENT_PROFILE_DIR = "org.mozilla.gecko.intent.PROFILE_DIR";
    private static final String INTENT_ACTION_UPDATE_ADDONS = "update-addons";
    private static final String INTENT_ACTION_CREATE_SERVICES = "create-services";
    private static final String INTENT_SERVICE_CATEGORY = "category";
    private static final String INTENT_SERVICE_DATA = "data";
    private static final EventListener EVENT_LISTENER = new EventListener();

    public static void register() {
        EventDispatcher.getInstance().registerGeckoThreadListener(EVENT_LISTENER, "Gecko:ScheduleRun");
    }

    public static void unregister() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(EVENT_LISTENER, "Gecko:ScheduleRun");
    }

    public void onCreate() {
        GeckoAppShell.ensureCrashHandling();
        GeckoAppShell.setApplicationContext(this.getApplicationContext());
        GeckoAppShell.setNotificationClient(new ServiceNotificationClient(this.getApplicationContext()));
        GeckoThread.onResume();
        super.onCreate();
    }

    public void onDestroy() {
        GeckoThread.onPause();
        if (GeckoThread.isStateAtLeast(GeckoThread.State.PROFILE_READY)) {
            GeckoThread.waitOnGecko();
        }
        super.onDestroy();
    }

    private static Intent getIntentForAction(Context context, String string2) {
        Intent intent = new Intent(string2, null, context, GeckoService.class);
        GeckoProfile geckoProfile = GeckoThread.getActiveProfile();
        if (geckoProfile != null) {
            GeckoService.setIntentProfile(intent, geckoProfile.getName(), geckoProfile.getDir().getAbsolutePath());
        }
        return intent;
    }

    public static Intent getIntentToCreateServices(Context context, String string2, String string3) {
        Intent intent = GeckoService.getIntentForAction(context, INTENT_ACTION_CREATE_SERVICES);
        intent.putExtra(INTENT_SERVICE_CATEGORY, string2);
        intent.putExtra(INTENT_SERVICE_DATA, string3);
        return intent;
    }

    public static Intent getIntentToCreateServices(Context context, String string2) {
        return GeckoService.getIntentToCreateServices(context, string2, null);
    }

    public static void setIntentProfile(Intent intent, String string2, String string3) {
        intent.putExtra(INTENT_PROFILE_NAME, string2);
        intent.putExtra(INTENT_PROFILE_DIR, string3);
    }

    private int handleIntent(Intent intent, int n) {
        String string2 = intent.getStringExtra(INTENT_PROFILE_NAME);
        String string3 = intent.getStringExtra(INTENT_PROFILE_DIR);
        if (string2 == null || string3 == null) {
            throw new IllegalArgumentException("Intent must specify profile.");
        }
        if (!GeckoThread.initWithProfile(string2 != null ? string2 : "", new File(string3))) {
            Log.w((String)LOGTAG, (String)("Ignoring due to profile mismatch: " + string2 + " [" + string3 + ']'));
            GeckoProfile geckoProfile = GeckoThread.getActiveProfile();
            if (geckoProfile != null) {
                Log.w((String)LOGTAG, (String)("Current profile is " + geckoProfile.getName() + " [" + geckoProfile.getDir().getAbsolutePath() + ']'));
            }
            this.stopSelf(n);
            return 2;
        }
        GeckoThread.launch();
        switch (intent.getAction()) {
            case "update-addons": {
                break;
            }
            case "create-services": {
                String string4 = intent.getStringExtra(INTENT_SERVICE_CATEGORY);
                String string5 = intent.getStringExtra(INTENT_SERVICE_DATA);
                if (string4 == null) break;
                GeckoThread.createServices(string4, string5);
                break;
            }
            default: {
                Log.w((String)LOGTAG, (String)("Unknown request: " + intent));
            }
        }
        this.stopSelf(n);
        return 2;
    }

    public int onStartCommand(Intent intent, int n, int n2) {
        if (intent == null) {
            return 2;
        }
        try {
            return this.handleIntent(intent, n2);
        }
        catch (Throwable throwable) {
            Log.e((String)LOGTAG, (String)("Cannot handle intent: " + intent), (Throwable)throwable);
            return 2;
        }
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    private static class EventListener
    implements NativeEventListener {
        private EventListener() {
        }

        public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
            Context context = GeckoAppShell.getApplicationContext();
            switch (string2) {
                case "Gecko:ScheduleRun": {
                    Intent intent = GeckoService.getIntentForAction(context, nativeJSObject.getString("action"));
                    PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)intent, (int)0x10000000);
                    AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
                    alarmManager.setInexactRepeating(3, (long)nativeJSObject.getInt("trigger"), (long)nativeJSObject.getInt("interval"), pendingIntent);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(string2);
                }
            }
        }
    }
}

