/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.database.Cursor;
import android.util.Log;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class MessagesListManager {
    private static final MessagesListManager sInstance = new MessagesListManager();
    private final HashMap<Integer, Cursor> mCursors = new HashMap();

    MessagesListManager() {
    }

    public static MessagesListManager getInstance() {
        return sInstance;
    }

    public void add(int n, Cursor cursor) {
        if (this.mCursors.containsKey(n)) {
            Log.e((String)"GeckoSmsManager", (String)"Trying to overwrite cursor!");
            return;
        }
        this.mCursors.put(n, cursor);
    }

    public Cursor get(int n) {
        if (!this.mCursors.containsKey(n)) {
            Log.e((String)"GeckoSmsManager", (String)"Cursor doesn't exist!");
            return null;
        }
        return this.mCursors.get(n);
    }

    public void remove(int n) {
        if (!this.mCursors.containsKey(n)) {
            Log.e((String)"GeckoSmsManager", (String)"Cursor doesn't exist!");
            return;
        }
        this.mCursors.remove(n);
    }

    public void clear() {
        Set<Map.Entry<Integer, Cursor>> set = this.mCursors.entrySet();
        Iterator<Map.Entry<Integer, Cursor>> iterator = set.iterator();
        while (iterator.hasNext()) {
            iterator.next().getValue().close();
        }
        this.mCursors.clear();
    }
}

