/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.cleanup;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.mozilla.gecko.cleanup.FileCleanupService;

public class FileCleanupController {
    private static final long MILLIS_BETWEEN_CLEANUPS = TimeUnit.DAYS.toMillis(7L);
    static final String PREF_LAST_CLEANUP_MILLIS = "cleanup.lastFileCleanupMillis";
    private static final String[] PROFILE_FILES_TO_CLEANUP = new String[]{"health.db", "health.db-journal", "health.db-shm", "health.db-wal"};

    public static void startIfReady(Context context, SharedPreferences sharedPreferences, String string2) {
        if (!FileCleanupController.isCleanupReady(sharedPreferences)) {
            return;
        }
        FileCleanupController.recordCleanupScheduled(sharedPreferences);
        Intent intent = new Intent(context, FileCleanupService.class);
        intent.setAction("org.mozilla.gecko.intent.action.DELETE_FILES");
        intent.putExtra("org.mozilla.gecko.file_paths_to_delete", FileCleanupController.getFilesToCleanup(string2 + "/"));
        context.startService(intent);
    }

    private static boolean isCleanupReady(SharedPreferences sharedPreferences) {
        long l = sharedPreferences.getLong(PREF_LAST_CLEANUP_MILLIS, -1L);
        return l + MILLIS_BETWEEN_CLEANUPS < System.currentTimeMillis();
    }

    private static void recordCleanupScheduled(SharedPreferences sharedPreferences) {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(PREF_LAST_CLEANUP_MILLIS, System.currentTimeMillis()).apply();
    }

    static ArrayList<String> getFilesToCleanup(String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(PROFILE_FILES_TO_CLEANUP.length);
        for (String string3 : PROFILE_FILES_TO_CLEANUP) {
            arrayList.add(string2 + File.separator + string3);
        }
        return arrayList;
    }
}

