/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import android.util.LruCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.db.DBUtils;
import org.mozilla.gecko.db.URLMetadata;
import org.mozilla.gecko.db.URLMetadataTable;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.util.ThreadUtils;

public class LocalURLMetadata
implements URLMetadata {
    private static final String LOGTAG = "GeckoURLMetadata";
    private final Uri uriWithProfile;
    private static final Set<String> COLUMNS;
    private static final int CACHE_SIZE = 9;
    private final LruCache<String, Map<String, Object>> cache = new LruCache(9);

    public LocalURLMetadata(String string2) {
        this.uriWithProfile = DBUtils.appendProfileWithDefault(string2, URLMetadataTable.CONTENT_URI);
    }

    @Override
    public Map<String, Object> fromJSON(JSONObject jSONObject) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        JSONObject jSONObject2 = COLUMNS.iterator();
        while (jSONObject2.hasNext()) {
            String string2 = jSONObject2.next();
            if (!jSONObject.has(string2)) continue;
            hashMap.put(string2, jSONObject.optString(string2));
        }
        try {
            if (jSONObject.has("touchIconList") && (jSONObject2 = jSONObject.getJSONObject("touchIconList")).length() > 0) {
                int n = GeckoAppShell.getPreferredIconSize();
                Iterator iterator = jSONObject2.keys();
                ArrayList<Integer> arrayList = new ArrayList<Integer>(jSONObject2.length());
                while (iterator.hasNext()) {
                    arrayList.add(new Integer((String)iterator.next()));
                }
                int n2 = Favicons.selectBestSizeFromList(arrayList, n);
                String string3 = jSONObject2.getString(Integer.toString(n2));
                hashMap.put("touchIcon", string3);
            }
        }
        catch (JSONException jSONException) {
            Log.w((String)LOGTAG, (String)"Exception processing touchIconList for LocalURLMetadata; ignoring.", (Throwable)jSONException);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private Map<String, Object> fromCursor(Cursor cursor) {
        String[] stringArray;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : stringArray = cursor.getColumnNames()) {
            if (!COLUMNS.contains(string2)) continue;
            try {
                hashMap.put(string2, cursor.getString(cursor.getColumnIndexOrThrow(string2)));
            }
            catch (Exception exception) {
                Log.i((String)LOGTAG, (String)("Error getting data for " + string2), (Throwable)exception);
            }
        }
        return Collections.unmodifiableMap(hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public Map<String, Map<String, Object>> getForURLs(ContentResolver contentResolver, Collection<String> collection, List<String> list) {
        void var7_10;
        Map map;
        ThreadUtils.assertNotOnUiThread();
        ThreadUtils.assertNotOnGeckoThread();
        HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
        if (collection.isEmpty() || list.isEmpty()) {
            Log.e((String)LOGTAG, (String)"Queried metadata for nothing");
            return hashMap;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String list22 : collection) {
            map = (Map)this.cache.get((Object)list22);
            if (map != null) {
                boolean map3 = true;
                for (String string2 : list) {
                    if (map.containsKey(string2)) continue;
                    map3 = false;
                }
                if (map3) {
                    hashMap.put(list22, map);
                    continue;
                }
                arrayList.add(list22);
                continue;
            }
            arrayList.add(list22);
        }
        if (arrayList.size() == 0) {
            return Collections.unmodifiableMap(hashMap);
        }
        String string3 = DBUtils.computeSQLInClause(arrayList.size(), "url");
        List<String> list2 = list;
        if (!list2.contains("url")) {
            ArrayList<String> arrayList2 = new ArrayList<String>(list2);
            arrayList2.add("url");
        }
        map = contentResolver.query(this.uriWithProfile, var7_10.toArray(new String[var7_10.size()]), string3, arrayList.toArray(new String[arrayList.size()]), null);
        try {
            if (!map.moveToFirst()) {
                Map<String, Map<String, Object>> map2 = Collections.unmodifiableMap(hashMap);
                return map2;
            }
            do {
                Map<String, Object> map3 = this.fromCursor((Cursor)map);
                String string4 = map.getString(map.getColumnIndexOrThrow("url"));
                hashMap.put(string4, map3);
                this.cache.put((Object)string4, map3);
            } while (map.moveToNext());
        }
        finally {
            map.close();
        }
        return Collections.unmodifiableMap(hashMap);
    }

    @Override
    public void save(ContentResolver contentResolver, Map<String, Object> map) {
        ThreadUtils.assertNotOnUiThread();
        ThreadUtils.assertNotOnGeckoThread();
        try {
            ContentValues contentValues = new ContentValues();
            for (String string2 : COLUMNS) {
                if (!map.containsKey(string2)) continue;
                contentValues.put(string2, (String)map.get(string2));
            }
            if (contentValues.size() == 0) {
                return;
            }
            Uri uri = this.uriWithProfile.buildUpon().appendQueryParameter("insert_if_needed", "true").build();
            contentResolver.update(uri, contentValues, "url=?", new String[]{(String)map.get("url")});
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"error saving", (Throwable)exception);
        }
    }

    static {
        HashSet<String> hashSet = new HashSet<String>(4);
        hashSet.add("url");
        hashSet.add("tileImage");
        hashSet.add("tileColor");
        hashSet.add("touchIcon");
        COLUMNS = Collections.unmodifiableSet(hashSet);
    }
}

