/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.distribution;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import java.lang.ref.WeakReference;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.distribution.Distribution;

public class DistributionStoreCallback
implements Distribution.ReadyCallback {
    private static final String LOGTAG = "Gecko" + DistributionStoreCallback.class.getSimpleName();
    public static final String PREF_DISTRIBUTION_ID = "distribution.id";
    private final WeakReference<Context> contextReference;
    private final String profileName;

    public DistributionStoreCallback(Context context, String string2) {
        this.contextReference = new WeakReference<Context>(context);
        this.profileName = string2;
    }

    @Override
    public void distributionNotFound() {
    }

    @Override
    public void distributionFound(Distribution distribution) {
        this.storeDistribution(distribution);
    }

    @Override
    public void distributionArrivedLate(Distribution distribution) {
        this.storeDistribution(distribution);
    }

    private void storeDistribution(Distribution distribution) {
        Context context = (Context)this.contextReference.get();
        if (context == null) {
            Log.w((String)LOGTAG, (String)"Context is no longer alive, could retrieve shared prefs to store distribution");
            return;
        }
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forProfileName(context, this.profileName);
        Distribution.DistributionDescriptor distributionDescriptor = distribution.getDescriptor();
        if (distributionDescriptor != null) {
            sharedPreferences.edit().putString(PREF_DISTRIBUTION_ID, distributionDescriptor.id).apply();
        }
    }
}

