/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.dlc;

import android.content.Context;
import android.util.Log;
import java.io.File;
import org.mozilla.gecko.dlc.BaseAction;
import org.mozilla.gecko.dlc.DownloadContentService;
import org.mozilla.gecko.dlc.catalog.DownloadContent;
import org.mozilla.gecko.dlc.catalog.DownloadContentCatalog;

public class VerifyAction
extends BaseAction {
    private static final String LOGTAG = "DLCVerifyAction";

    @Override
    public void perform(Context context, DownloadContentCatalog downloadContentCatalog) {
        Log.d((String)LOGTAG, (String)"Verifying catalog..");
        for (DownloadContent downloadContent : downloadContentCatalog.getDownloadedContent()) {
            try {
                File file = this.getDestinationFile(context, downloadContent);
                if (!file.exists()) {
                    Log.d((String)LOGTAG, (String)("Downloaded content does not exist anymore: " + downloadContent));
                    downloadContentCatalog.scheduleDownload(downloadContent);
                    continue;
                }
                if (!this.verify(file, downloadContent.getChecksum())) {
                    downloadContentCatalog.scheduleDownload(downloadContent);
                    Log.d((String)LOGTAG, (String)("Wrong checksum. Scheduling download: " + downloadContent));
                    continue;
                }
                Log.v((String)LOGTAG, (String)("Content okay: " + downloadContent));
            }
            catch (BaseAction.UnrecoverableDownloadContentException unrecoverableDownloadContentException) {
                Log.w((String)LOGTAG, (String)"Unrecoverable exception while verifying downloaded file", (Throwable)unrecoverableDownloadContentException);
            }
            catch (BaseAction.RecoverableDownloadContentException recoverableDownloadContentException) {}
        }
        if (downloadContentCatalog.hasScheduledDownloads()) {
            this.startDownloads(context);
        }
        Log.v((String)LOGTAG, (String)"Done");
    }

    protected void startDownloads(Context context) {
        DownloadContentService.startDownloads(context);
    }
}

