/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.widget.EdgeEffect;
import java.lang.reflect.Field;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.gfx.Overscroll;

public class OverscrollEdgeEffect
implements Overscroll {
    private static final int TOP = 0;
    private static final int BOTTOM = 1;
    private static final int LEFT = 2;
    private static final int RIGHT = 3;
    private final EdgeEffect[] mEdges = new EdgeEffect[4];
    private final LayerView mView;

    public OverscrollEdgeEffect(LayerView layerView) {
        Field field = null;
        if (AppConstants.Versions.feature21Plus) {
            try {
                field = EdgeEffect.class.getDeclaredField("mPaint");
                field.setAccessible(true);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        this.mView = layerView;
        Context context = layerView.getContext();
        for (int i = 0; i < 4; ++i) {
            this.mEdges[i] = new EdgeEffect(context);
            try {
                if (field == null) continue;
                Paint paint = (Paint)field.get(this.mEdges[i]);
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setSize(int n, int n2) {
        this.mEdges[2].setSize(n2, n);
        this.mEdges[3].setSize(n2, n);
        this.mEdges[0].setSize(n, n2);
        this.mEdges[1].setSize(n, n2);
    }

    private EdgeEffect getEdgeForAxisAndSide(Overscroll.Axis axis, float f) {
        if (axis == Overscroll.Axis.Y) {
            if (f < 0.0f) {
                return this.mEdges[0];
            }
            return this.mEdges[1];
        }
        if (f < 0.0f) {
            return this.mEdges[2];
        }
        return this.mEdges[3];
    }

    private void invalidate() {
        if (AppConstants.Versions.feature16Plus) {
            this.mView.postInvalidateOnAnimation();
        } else {
            this.mView.postInvalidateDelayed(10L);
        }
    }

    @Override
    public void setVelocity(float f, Overscroll.Axis axis) {
        EdgeEffect edgeEffect = this.getEdgeForAxisAndSide(axis, f);
        if (!edgeEffect.isFinished()) {
            edgeEffect.onRelease();
        } else {
            edgeEffect.onAbsorb((int)f);
        }
        this.invalidate();
    }

    @Override
    public void setDistance(float f, Overscroll.Axis axis) {
        if (f == 0.0f) {
            return;
        }
        EdgeEffect edgeEffect = this.getEdgeForAxisAndSide(axis, (int)f);
        edgeEffect.onPull(f / (float)(axis == Overscroll.Axis.X ? this.mView.getWidth() : this.mView.getHeight()));
        this.invalidate();
    }

    @Override
    public void draw(Canvas canvas, ImmutableViewportMetrics immutableViewportMetrics) {
        if (immutableViewportMetrics == null) {
            return;
        }
        float f = this.mView.getDynamicToolbarAnimator().getMaxTranslation();
        PointF pointF = this.mView.getDynamicToolbarAnimator().getVisibleEndOfLayerView();
        boolean bl = false;
        if (!this.mEdges[0].isFinished()) {
            bl |= OverscrollEdgeEffect.draw(this.mEdges[0], canvas, 0.0f, f, 0.0f);
        }
        if (!this.mEdges[1].isFinished()) {
            bl |= OverscrollEdgeEffect.draw(this.mEdges[1], canvas, pointF.x, f + pointF.y, 180.0f);
        }
        if (!this.mEdges[2].isFinished()) {
            bl |= OverscrollEdgeEffect.draw(this.mEdges[2], canvas, 0.0f, f + pointF.y, 270.0f);
        }
        if (!this.mEdges[3].isFinished()) {
            bl |= OverscrollEdgeEffect.draw(this.mEdges[3], canvas, pointF.x, f, 90.0f);
        }
        if (bl) {
            this.invalidate();
        }
    }

    private static boolean draw(EdgeEffect edgeEffect, Canvas canvas, float f, float f2, float f3) {
        int n = canvas.save();
        canvas.translate(f, f2);
        canvas.rotate(f3);
        boolean bl = edgeEffect.draw(canvas);
        canvas.restoreToCount(n);
        return bl;
    }
}

