/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.HomePager;

public class HomeListView
extends ListView
implements AdapterView.OnItemLongClickListener {
    private HomeContextMenuInfo mContextMenuInfo;
    protected HomePager.OnUrlOpenListener mUrlOpenListener;
    private final boolean mShowTopDivider;
    private HomeContextMenuInfo.Factory mContextMenuInfoFactory;

    public HomeListView(Context context) {
        this(context, null);
    }

    public HomeListView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.homeListViewStyle);
    }

    public HomeListView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.HomeListView, n, 0);
        this.mShowTopDivider = typedArray.getBoolean(R.styleable.HomeListView_topDivider, false);
        typedArray.recycle();
        this.setOnItemLongClickListener(this);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        Drawable drawable2 = this.getDivider();
        if (this.mShowTopDivider && drawable2 != null) {
            int n = this.getDividerHeight();
            View view = new View(this.getContext());
            view.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, n));
            this.addHeaderView(view);
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mUrlOpenListener = null;
    }

    public boolean onItemLongClick(AdapterView<?> adapterView, View view, int n, long l) {
        Object object = adapterView.getItemAtPosition(n);
        if (object instanceof Cursor) {
            Cursor cursor = (Cursor)object;
            if (cursor == null || this.mContextMenuInfoFactory == null) {
                this.mContextMenuInfo = null;
                return false;
            }
            this.mContextMenuInfo = this.mContextMenuInfoFactory.makeInfoForCursor(view, n, l, cursor);
            return this.showContextMenuForChild((View)this);
        }
        if (this.mContextMenuInfoFactory instanceof HomeContextMenuInfo.ListFactory) {
            this.mContextMenuInfo = ((HomeContextMenuInfo.ListFactory)this.mContextMenuInfoFactory).makeInfoForAdapter(view, n, l, this.getAdapter());
            return this.showContextMenuForChild((View)this);
        }
        this.mContextMenuInfo = null;
        return false;
    }

    public ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    public void setOnItemClickListener(final AdapterView.OnItemClickListener onItemClickListener) {
        if (onItemClickListener == null) {
            super.setOnItemClickListener(null);
            return;
        }
        super.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                if (HomeListView.this.mShowTopDivider) {
                    --n;
                }
                onItemClickListener.onItemClick(adapterView, view, n, l);
            }
        });
    }

    public void setContextMenuInfoFactory(HomeContextMenuInfo.Factory factory) {
        this.mContextMenuInfoFactory = factory;
    }

    public HomePager.OnUrlOpenListener getOnUrlOpenListener() {
        return this.mUrlOpenListener;
    }

    public void setOnUrlOpenListener(HomePager.OnUrlOpenListener onUrlOpenListener) {
        this.mUrlOpenListener = onUrlOpenListener;
    }
}

