/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.mdns;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.nsd.NsdManager;
import android.net.nsd.NsdServiceInfo;
import android.os.Build;
import android.util.Log;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.mdns.DiscoveryListener;
import org.mozilla.gecko.mdns.MulticastDNSEventManager;
import org.mozilla.gecko.mdns.MulticastDNSManager;
import org.mozilla.gecko.mdns.RegistrationListener;
import org.mozilla.gecko.mdns.ResolveListener;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;

class NsdMulticastDNSManager
extends MulticastDNSManager
implements NativeEventListener {
    private final NsdManager nsdManager;
    private final MulticastDNSEventManager mEventManager;
    private Map<String, DiscoveryListener> mDiscoveryListeners = null;
    private Map<String, RegistrationListener> mRegistrationListeners = null;

    @TargetApi(value=16)
    public NsdMulticastDNSManager(Context context) {
        this.nsdManager = (NsdManager)context.getSystemService("servicediscovery");
        this.mEventManager = new MulticastDNSEventManager(this);
        this.mDiscoveryListeners = new ConcurrentHashMap<String, DiscoveryListener>();
        this.mRegistrationListeners = new ConcurrentHashMap<String, RegistrationListener>();
    }

    @Override
    public void init() {
        this.mEventManager.init();
    }

    @Override
    public void tearDown() {
        this.mDiscoveryListeners.clear();
        this.mRegistrationListeners.clear();
        this.mEventManager.tearDown();
    }

    public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        Log.v((String)"GeckoMDNSManager", (String)("handleMessage: " + string2));
        switch (string2) {
            case "NsdManager:DiscoverServices": {
                DiscoveryListener discoveryListener = new DiscoveryListener(this.nsdManager);
                discoveryListener.discoverServices(nativeJSObject.getString("serviceType"), eventCallback);
                this.mDiscoveryListeners.put(nativeJSObject.getString("uniqueId"), discoveryListener);
                break;
            }
            case "NsdManager:StopServiceDiscovery": {
                String string3 = nativeJSObject.getString("uniqueId");
                DiscoveryListener discoveryListener = this.mDiscoveryListeners.remove(string3);
                if (discoveryListener == null) {
                    Log.e((String)"GeckoMDNSManager", (String)("DiscoveryListener " + string3 + " was not found."));
                    return;
                }
                discoveryListener.stopServiceDiscovery(eventCallback);
                break;
            }
            case "NsdManager:RegisterService": {
                RegistrationListener registrationListener = new RegistrationListener(this.nsdManager);
                registrationListener.registerService(nativeJSObject.getInt("port"), nativeJSObject.optString("serviceName", Build.MODEL), nativeJSObject.getString("serviceType"), this.parseAttributes(nativeJSObject.optObjectArray("attributes", null)), eventCallback);
                this.mRegistrationListeners.put(nativeJSObject.getString("uniqueId"), registrationListener);
                break;
            }
            case "NsdManager:UnregisterService": {
                String string4 = nativeJSObject.getString("uniqueId");
                RegistrationListener registrationListener = this.mRegistrationListeners.remove(string4);
                if (registrationListener == null) {
                    Log.e((String)"GeckoMDNSManager", (String)("RegistrationListener " + string4 + " was not found."));
                    return;
                }
                registrationListener.unregisterService(eventCallback);
                break;
            }
            case "NsdManager:ResolveService": {
                new ResolveListener(this.nsdManager).resolveService(nativeJSObject.getString("serviceName"), nativeJSObject.getString("serviceType"), eventCallback);
            }
        }
    }

    private Map<String, String> parseAttributes(NativeJSObject[] nativeJSObjectArray) {
        if (nativeJSObjectArray == null || nativeJSObjectArray.length == 0 || !AppConstants.Versions.feature21Plus) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(nativeJSObjectArray.length);
        for (NativeJSObject nativeJSObject : nativeJSObjectArray) {
            hashMap.put(nativeJSObject.getString("name"), nativeJSObject.getString("value"));
        }
        return hashMap;
    }

    @TargetApi(value=16)
    public static JSONObject toJSON(NsdServiceInfo nsdServiceInfo) throws JSONException {
        String string2;
        String string3;
        int n;
        JSONObject jSONObject = new JSONObject();
        InetAddress inetAddress = nsdServiceInfo.getHost();
        if (inetAddress != null) {
            jSONObject.put("host", (Object)inetAddress.getCanonicalHostName());
            jSONObject.put("address", (Object)inetAddress.getHostAddress());
        }
        if ((n = nsdServiceInfo.getPort()) != 0) {
            jSONObject.put("port", n);
        }
        if ((string3 = nsdServiceInfo.getServiceName()) != null) {
            jSONObject.put("serviceName", (Object)string3);
        }
        if ((string2 = nsdServiceInfo.getServiceType()) != null) {
            jSONObject.put("serviceType", (Object)string2);
        }
        return jSONObject;
    }
}

