/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.menu;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.CardView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.PopupWindow;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.R;

public class MenuPopup
extends PopupWindow {
    private final CardView mPanel;
    private final int mPopupWidth;

    public MenuPopup(Context context) {
        super(context);
        this.setFocusable(true);
        this.mPopupWidth = context.getResources().getDimensionPixelSize(R.dimen.menu_popup_width);
        this.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.setWindowLayoutMode(-2, -2);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        this.mPanel = (CardView)layoutInflater.inflate(R.layout.menu_popup, null);
        this.setContentView((View)this.mPanel);
        if (AppConstants.Versions.preLollipop) {
            this.mPanel.setRadius(0.0f);
        }
        this.setAnimationStyle(R.style.PopupAnimation);
    }

    public void setPanelView(View view) {
        view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.mPopupWidth, -2));
        this.mPanel.removeAllViews();
        this.mPanel.addView(view);
    }

    public void showAsDropDown(View view) {
        this.setHeight(this.mPanel.getHeight());
        int n = view.getWidth() / 2 - this.mPopupWidth / 2;
        this.showAsDropDown(view, n, -view.getHeight());
    }
}

