/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.promotion;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;

public class SimpleHelperUI
extends Locales.LocaleAwareActivity {
    public static final String PREF_FIRST_RVBP_SHOWN = "first_reader_view_bookmark_prompt_shown";
    public static final String FIRST_RVBP_SHOWN_TELEMETRYEXTRA = "first_readerview_bookmark_prompt";
    private View containerView;
    private boolean isAnimating;
    private String mTelemetryExtra;
    private static final String EXTRA_TELEMETRYEXTRA = "telemetryextra";
    private static final String EXTRA_TITLE = "title";
    private static final String EXTRA_MESSAGE = "message";
    private static final String EXTRA_IMAGE = "image";
    private static final String EXTRA_BUTTON = "button";
    private static final String EXTRA_RESULTCODE_POSITIVE = "positive";
    private static final String EXTRA_RESULTCODE_NEGATIVE = "negative";

    public static void show(Activity activity, String string2, int n, @StringRes int n2, @StringRes int n3, @DrawableRes int n4, @StringRes int n5, int n6, int n7) {
        Intent intent = new Intent((Context)activity, SimpleHelperUI.class);
        intent.putExtra(EXTRA_TELEMETRYEXTRA, string2);
        intent.putExtra(EXTRA_TITLE, n2);
        intent.putExtra(EXTRA_MESSAGE, n3);
        intent.putExtra(EXTRA_IMAGE, n4);
        intent.putExtra(EXTRA_BUTTON, n5);
        intent.putExtra(EXTRA_RESULTCODE_POSITIVE, n6);
        intent.putExtra(EXTRA_RESULTCODE_NEGATIVE, n7);
        activity.startActivityForResult(intent, n);
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mTelemetryExtra = this.getIntent().getStringExtra(EXTRA_TELEMETRYEXTRA);
        this.setupViews();
        this.slideIn();
    }

    private void setupViews() {
        final Intent intent = this.getIntent();
        this.setContentView(R.layout.simple_helper_ui);
        this.containerView = this.findViewById(R.id.container);
        ((ImageView)this.findViewById(R.id.image)).setImageResource(intent.getIntExtra(EXTRA_IMAGE, 0));
        ((TextView)this.findViewById(R.id.title)).setText(intent.getIntExtra(EXTRA_TITLE, 0));
        ((TextView)this.findViewById(R.id.message)).setText(intent.getIntExtra(EXTRA_MESSAGE, 0));
        Button button = (Button)this.findViewById(R.id.button);
        button.setText(intent.getIntExtra(EXTRA_BUTTON, 0));
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SimpleHelperUI.this.slideOut();
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.BUTTON, SimpleHelperUI.this.mTelemetryExtra);
                SimpleHelperUI.this.setResult(intent.getIntExtra(SimpleHelperUI.EXTRA_RESULTCODE_POSITIVE, -1));
            }
        });
    }

    private void slideIn() {
        this.containerView.setTranslationY(500.0f);
        this.containerView.setAlpha(0.0f);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.containerView, (String)"translationY", (float[])new float[]{0.0f});
        objectAnimator.setDuration(400L);
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)this.containerView, (String)"alpha", (float[])new float[]{1.0f});
        objectAnimator2.setStartDelay(200L);
        objectAnimator2.setDuration(600L);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator2, objectAnimator});
        animatorSet.setStartDelay(400L);
        animatorSet.start();
    }

    private void slideOut() {
        if (this.isAnimating) {
            return;
        }
        this.isAnimating = true;
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.containerView, (String)"translationY", (float[])new float[]{this.containerView.getHeight()});
        objectAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                SimpleHelperUI.this.finish();
            }
        });
        objectAnimator.start();
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }

    public void onBackPressed() {
        this.slideOut();
        Telemetry.sendUIEvent(TelemetryContract.Event.CANCEL, TelemetryContract.Method.BACK, this.mTelemetryExtra);
        this.setResult(this.getIntent().getIntExtra(EXTRA_RESULTCODE_NEGATIVE, -1));
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.slideOut();
        Telemetry.sendUIEvent(TelemetryContract.Event.CANCEL, TelemetryContract.Method.BACK, this.mTelemetryExtra);
        this.setResult(this.getIntent().getIntExtra(EXTRA_RESULTCODE_NEGATIVE, -1));
        return true;
    }
}

