/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.telemetry.measurements;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.UiThread;
import java.util.concurrent.TimeUnit;
import org.mozilla.gecko.GeckoSharedPrefs;

public class SessionMeasurements {
    static final String PREF_SESSION_COUNT = "measurements-session-count";
    static final String PREF_SESSION_DURATION = "measurements-session-duration";
    private boolean sessionStarted = false;
    private long timeAtSessionStartNano = -1L;

    @UiThread
    public void recordSessionStart() {
        if (this.sessionStarted) {
            throw new IllegalStateException("Trying to start session but it is already started");
        }
        this.sessionStarted = true;
        this.timeAtSessionStartNano = this.getSystemTimeNano();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public void recordSessionEnd(Context context) {
        if (!this.sessionStarted) {
            throw new IllegalStateException("Expected session to be started before session end is called");
        }
        this.sessionStarted = false;
        long l = TimeUnit.NANOSECONDS.toSeconds(this.getSystemTimeNano() - this.timeAtSessionStartNano);
        SharedPreferences sharedPreferences = this.getSharedPreferences(context);
        SessionMeasurements sessionMeasurements = this;
        synchronized (sessionMeasurements) {
            int n = sharedPreferences.getInt(PREF_SESSION_COUNT, 0);
            long l2 = sharedPreferences.getLong(PREF_SESSION_DURATION, 0L);
            sharedPreferences.edit().putInt(PREF_SESSION_COUNT, n + 1).putLong(PREF_SESSION_DURATION, l2 + l).apply();
        }
    }

    public synchronized SessionMeasurementsContainer getAndResetSessionMeasurements(Context context) {
        SharedPreferences sharedPreferences = this.getSharedPreferences(context);
        int n = sharedPreferences.getInt(PREF_SESSION_COUNT, 0);
        long l = sharedPreferences.getLong(PREF_SESSION_DURATION, 0L);
        sharedPreferences.edit().putInt(PREF_SESSION_COUNT, 0).putLong(PREF_SESSION_DURATION, 0L).apply();
        return new SessionMeasurementsContainer(n, l);
    }

    SharedPreferences getSharedPreferences(Context context) {
        return GeckoSharedPrefs.forProfile(context);
    }

    long getSystemTimeNano() {
        return System.nanoTime();
    }

    public static final class SessionMeasurementsContainer {
        public final int sessionCount;
        public final long elapsedSeconds;

        private SessionMeasurementsContainer(int n, long l) {
            this.sessionCount = n;
            this.elapsedSeconds = l;
        }
    }
}

