/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.telemetry.pingbuilders;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.search.SearchEngine;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.telemetry.pingbuilders.TelemetryPingBuilder;
import org.mozilla.gecko.util.DateUtil;
import org.mozilla.gecko.util.Experiments;
import org.mozilla.gecko.util.StringUtils;

public class TelemetryCorePingBuilder
extends TelemetryPingBuilder {
    private static final String LOGTAG = StringUtils.safeSubstring((String)TelemetryCorePingBuilder.class.getSimpleName(), (int)0, (int)23);
    private static final String PREF_SEQ_COUNT = "telemetry-seqCount";
    private static final String NAME = "core";
    private static final int VERSION_VALUE = 7;
    private static final String OS_VALUE = "Android";
    private static final String ARCHITECTURE = "arch";
    private static final String CLIENT_ID = "clientId";
    private static final String DEFAULT_SEARCH_ENGINE = "defaultSearch";
    private static final String DEVICE = "device";
    private static final String DISTRIBUTION_ID = "distributionId";
    private static final String EXPERIMENTS = "experiments";
    private static final String LOCALE = "locale";
    private static final String OS_ATTR = "os";
    private static final String OS_VERSION = "osversion";
    private static final String PING_CREATION_DATE = "created";
    private static final String PROFILE_CREATION_DATE = "profileDate";
    private static final String SEARCH_COUNTS = "searches";
    private static final String SEQ = "seq";
    private static final String SESSION_COUNT = "sessions";
    private static final String SESSION_DURATION = "durations";
    private static final String TIMEZONE_OFFSET = "tz";
    private static final String VERSION_ATTR = "v";

    public TelemetryCorePingBuilder(Context context) {
        this.initPayloadConstants(context);
    }

    private void initPayloadConstants(Context context) {
        this.payload.put(VERSION_ATTR, 7);
        this.payload.put(OS_ATTR, OS_VALUE);
        String string2 = StringUtils.safeSubstring((String)Build.MANUFACTURER, (int)0, (int)12) + '-' + StringUtils.safeSubstring((String)Build.MODEL, (int)0, (int)19);
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        this.payload.put(ARCHITECTURE, "x86");
        this.payload.put(DEVICE, string2);
        this.payload.put(LOCALE, Locales.getLanguageTag((Locale)Locale.getDefault()));
        this.payload.put(OS_VERSION, Integer.toString(Build.VERSION.SDK_INT));
        this.payload.put(PING_CREATION_DATE, simpleDateFormat.format(calendar.getTime()));
        this.payload.put(TIMEZONE_OFFSET, DateUtil.getTimezoneOffsetInMinutesForGivenDate((Calendar)calendar));
        this.payload.putArray(EXPERIMENTS, Experiments.getActiveExperiments(context));
    }

    @Override
    public String getDocType() {
        return NAME;
    }

    @Override
    public String[] getMandatoryFields() {
        return new String[]{ARCHITECTURE, CLIENT_ID, DEFAULT_SEARCH_ENGINE, DEVICE, LOCALE, OS_ATTR, OS_VERSION, PING_CREATION_DATE, PROFILE_CREATION_DATE, SEQ, TIMEZONE_OFFSET, VERSION_ATTR};
    }

    public TelemetryCorePingBuilder setClientID(@NonNull String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Expected non-null clientID");
        }
        this.payload.put(CLIENT_ID, string2);
        return this;
    }

    public TelemetryCorePingBuilder setDefaultSearchEngine(@Nullable String string2) {
        if (string2 != null && string2.isEmpty()) {
            throw new IllegalArgumentException("Received empty string. Expected identifier or null.");
        }
        this.payload.put(DEFAULT_SEARCH_ENGINE, string2);
        return this;
    }

    public TelemetryCorePingBuilder setOptDistributionID(@NonNull String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Expected non-null distribution ID");
        }
        this.payload.put(DISTRIBUTION_ID, string2);
        return this;
    }

    public TelemetryCorePingBuilder setOptSearchCounts(@NonNull ExtendedJSONObject extendedJSONObject) {
        if (extendedJSONObject == null) {
            throw new IllegalStateException("Expected non-null search counts");
        }
        if (extendedJSONObject.size() == 0) {
            throw new IllegalStateException("Expected non-empty search counts");
        }
        this.payload.put(SEARCH_COUNTS, extendedJSONObject);
        return this;
    }

    public TelemetryCorePingBuilder setProfileCreationDate(@Nullable Long l) {
        if (l != null && l < 0L) {
            throw new IllegalArgumentException("Expect positive date value. Received: " + l);
        }
        this.payload.put(PROFILE_CREATION_DATE, l.longValue());
        return this;
    }

    public TelemetryCorePingBuilder setSequenceNumber(int n) {
        if (n < 0) {
            Log.w((String)LOGTAG, (String)("Expected positive sequence number. Received: " + n));
        }
        this.payload.put(SEQ, n);
        return this;
    }

    public TelemetryCorePingBuilder setSessionCount(int n) {
        if (n < 0) {
            Log.w((String)LOGTAG, (String)("Expected positive session count. Received: " + n));
        }
        this.payload.put(SESSION_COUNT, n);
        return this;
    }

    public TelemetryCorePingBuilder setSessionDuration(long l) {
        if (l < 0L) {
            Log.w((String)LOGTAG, (String)("Expected positive session duration. Received: " + l));
        }
        this.payload.put(SESSION_DURATION, l);
        return this;
    }

    @WorkerThread
    public static int getAndIncrementSequenceNumber(SharedPreferences sharedPreferences) {
        int n = sharedPreferences.getInt(PREF_SEQ_COUNT, 1);
        sharedPreferences.edit().putInt(PREF_SEQ_COUNT, n + 1).apply();
        return n;
    }

    @WorkerThread
    public static Long getProfileCreationDate(Context context, GeckoProfile geckoProfile) {
        long l = geckoProfile.getAndPersistProfileCreationDate(context);
        if (l < 0L) {
            return null;
        }
        return (long)Math.floor((double)l / (double)TimeUnit.DAYS.toMillis(1L));
    }

    @Nullable
    public static String getEngineIdentifier(@Nullable SearchEngine searchEngine) {
        if (searchEngine == null) {
            return null;
        }
        String string2 = searchEngine.getIdentifier();
        return TextUtils.isEmpty((CharSequence)string2) ? null : string2;
    }
}

