/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.text;

import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TextAction {
    private static final String LOGTAG = "GeckoTextAction";
    private String id;
    private String label;
    private int order;
    private int floatingOrder;

    private TextAction() {
    }

    public static List<TextAction> fromEventMessage(JSONObject jSONObject) {
        ArrayList<TextAction> arrayList = new ArrayList<TextAction>();
        try {
            JSONArray jSONArray = jSONObject.getJSONArray("actions");
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                TextAction textAction = new TextAction();
                textAction.id = jSONObject2.getString("id");
                textAction.label = jSONObject2.getString("label");
                textAction.order = jSONObject2.getInt("order");
                textAction.floatingOrder = jSONObject2.optInt("floatingOrder", i);
                arrayList.add(textAction);
            }
        }
        catch (JSONException jSONException) {
            Log.w((String)LOGTAG, (String)"Could not parse text actions", (Throwable)jSONException);
        }
        return arrayList;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public int getOrder() {
        return this.order;
    }

    public int getFloatingOrder() {
        return this.floatingOrder;
    }
}

