/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.R;
import org.mozilla.gecko.SiteIdentity;
import org.mozilla.gecko.SnackbarBuilder;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.AnchoredPopup;
import org.mozilla.gecko.widget.DoorHanger;
import org.mozilla.gecko.widget.DoorhangerConfig;
import org.mozilla.gecko.widget.SiteLogins;

public class SiteIdentityPopup
extends AnchoredPopup
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoSiteIdentityPopup";
    private static final String MIXED_CONTENT_SUPPORT_URL = "https://support.mozilla.org/kb/how-does-insecure-content-affect-safety-android";
    private static final String TRACKING_CONTENT_SUPPORT_URL = "https://support.mozilla.org/kb/firefox-android-tracking-protection";
    private static final String FORMAT_S = "%s";
    private final Resources mResources;
    private SiteIdentity mSiteIdentity;
    private LinearLayout mIdentity;
    private LinearLayout mIdentityKnownContainer;
    private ImageView mIcon;
    private TextView mTitle;
    private TextView mSecurityState;
    private TextView mMixedContentActivity;
    private TextView mOwner;
    private TextView mOwnerSupplemental;
    private TextView mVerifier;
    private TextView mLink;
    private TextView mSiteSettingsLink;
    private View mDivider;
    private DoorHanger mTrackingContentNotification;
    private DoorHanger mSelectLoginDoorhanger;
    private final DoorHanger.OnButtonClickListener mContentButtonClickListener;

    public SiteIdentityPopup(Context context) {
        super(context);
        this.mResources = this.mContext.getResources();
        this.mContentButtonClickListener = new ContentNotificationButtonListener();
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Doorhanger:Logins");
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Permissions:CheckResult");
    }

    @Override
    protected void init() {
        super.init();
        this.setFocusable(true);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mContext);
        this.mIdentity = (LinearLayout)layoutInflater.inflate(R.layout.site_identity, null);
        this.mContent.addView((View)this.mIdentity);
        this.mIdentityKnownContainer = (LinearLayout)this.mIdentity.findViewById(R.id.site_identity_known_container);
        this.mIcon = (ImageView)this.mIdentity.findViewById(R.id.site_identity_icon);
        this.mTitle = (TextView)this.mIdentity.findViewById(R.id.site_identity_title);
        this.mSecurityState = (TextView)this.mIdentity.findViewById(R.id.site_identity_state);
        this.mMixedContentActivity = (TextView)this.mIdentity.findViewById(R.id.mixed_content_activity);
        this.mOwner = (TextView)this.mIdentityKnownContainer.findViewById(R.id.owner);
        this.mOwnerSupplemental = (TextView)this.mIdentityKnownContainer.findViewById(R.id.owner_supplemental);
        this.mVerifier = (TextView)this.mIdentityKnownContainer.findViewById(R.id.verifier);
        this.mDivider = this.mIdentity.findViewById(R.id.divider_doorhanger);
        this.mLink = (TextView)this.mIdentity.findViewById(R.id.site_identity_link);
        this.mLink.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tabs.getInstance().loadUrlInTab(SiteIdentityPopup.MIXED_CONTENT_SUPPORT_URL);
            }
        });
        this.mSiteSettingsLink = (TextView)this.mIdentity.findViewById(R.id.site_settings_link);
    }

    private void updateIdentity(SiteIdentity siteIdentity) {
        if (!this.mInflated) {
            this.init();
        }
        boolean bl = siteIdentity.getSecurityMode() == SiteIdentity.SecurityMode.IDENTIFIED || siteIdentity.getSecurityMode() == SiteIdentity.SecurityMode.VERIFIED;
        this.updateConnectionState(siteIdentity);
        this.toggleIdentityKnownContainerVisibility(bl);
        if (bl) {
            this.updateIdentityInformation(siteIdentity);
        }
        GeckoAppShell.notifyObservers("Permissions:Check", null);
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        if ("Doorhanger:Logins".equals(string2)) {
            try {
                Tab tab = Tabs.getInstance().getSelectedTab();
                if (tab != null) {
                    JSONObject jSONObject2 = jSONObject.getJSONObject("data");
                    this.addLoginsToTab(jSONObject2);
                }
                if (this.isShowing()) {
                    this.addSelectLoginDoorhanger(tab);
                }
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"Error accessing logins in Doorhanger:Logins message", (Throwable)jSONException);
            }
        } else if ("Permissions:CheckResult".equals(string2)) {
            final boolean bl = jSONObject.optBoolean("hasPermissions", false);
            if (bl) {
                this.mSiteSettingsLink.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        GeckoAppShell.notifyObservers("Permissions:Get", null);
                        SiteIdentityPopup.this.dismiss();
                    }
                });
            }
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    SiteIdentityPopup.this.mSiteSettingsLink.setVisibility(bl ? 0 : 8);
                }
            });
        }
    }

    private void addLoginsToTab(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = jSONObject.getJSONArray("logins");
        SiteLogins siteLogins = new SiteLogins(jSONArray);
        Tabs.getInstance().getSelectedTab().setSiteLogins(siteLogins);
    }

    private void addSelectLoginDoorhanger(Tab tab) throws JSONException {
        SiteLogins siteLogins = tab.getSiteLogins();
        if (siteLogins == null) {
            return;
        }
        JSONArray jSONArray = siteLogins.getLogins();
        if (jSONArray.length() == 0) {
            return;
        }
        final JSONObject jSONObject = (JSONObject)jSONArray.get(0);
        DoorHanger.OnButtonClickListener onButtonClickListener = new DoorHanger.OnButtonClickListener(){
            Activity activity;
            {
                this.activity = (Activity)SiteIdentityPopup.this.mContext;
            }

            @Override
            public void onButtonClick(JSONObject jSONObject2, DoorHanger doorHanger) {
                try {
                    int n = jSONObject2.getInt("callback");
                    if (n == ButtonType.COPY.ordinal()) {
                        ClipboardManager clipboardManager = (ClipboardManager)SiteIdentityPopup.this.mContext.getSystemService("clipboard");
                        String string2 = jSONObject2.has("password") ? jSONObject2.optString("password") : jSONObject.getString("password");
                        if (AppConstants.Versions.feature11Plus) {
                            clipboardManager.setPrimaryClip(ClipData.newPlainText((CharSequence)"password", (CharSequence)string2));
                        } else {
                            clipboardManager.setText((CharSequence)string2);
                        }
                        SnackbarBuilder.builder(this.activity).message(R.string.doorhanger_login_select_toast_copy).duration(-1).buildAndShow();
                    }
                    SiteIdentityPopup.this.dismiss();
                }
                catch (JSONException jSONException) {
                    Log.e((String)SiteIdentityPopup.LOGTAG, (String)"Error handling Select login button click", (Throwable)jSONException);
                    SnackbarBuilder.builder(this.activity).message(R.string.doorhanger_login_select_toast_copy_error).duration(-1).buildAndShow();
                }
            }
        };
        final DoorhangerConfig doorhangerConfig = new DoorhangerConfig(DoorHanger.Type.LOGIN, onButtonClickListener);
        doorhangerConfig.setButton(this.mContext.getString(R.string.button_cancel), ButtonType.CANCEL.ordinal(), false);
        doorhangerConfig.setButton(this.mContext.getString(R.string.button_copy), ButtonType.COPY.ordinal(), true);
        String string2 = ((JSONObject)jSONArray.get(0)).getString("username");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = this.mContext.getString(R.string.doorhanger_login_no_username);
        }
        String string3 = this.mContext.getString(R.string.doorhanger_login_select_message).replace(FORMAT_S, string2);
        doorhangerConfig.setMessage(string3);
        JSONObject jSONObject2 = new JSONObject();
        if (jSONArray.length() > 1) {
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("type", (Object)"SELECT");
            JSONObject jSONObject4 = new JSONObject();
            jSONObject4.put("logins", (Object)jSONArray);
            jSONObject3.put("bundle", (Object)jSONObject4);
            jSONObject2.put("actionText", (Object)jSONObject3);
        }
        doorhangerConfig.setOptions(jSONObject2);
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!SiteIdentityPopup.this.mInflated) {
                    SiteIdentityPopup.this.init();
                }
                SiteIdentityPopup.this.removeSelectLoginDoorhanger();
                SiteIdentityPopup.this.mSelectLoginDoorhanger = DoorHanger.Get(SiteIdentityPopup.this.mContext, doorhangerConfig);
                SiteIdentityPopup.this.mContent.addView((View)SiteIdentityPopup.this.mSelectLoginDoorhanger);
                SiteIdentityPopup.this.mDivider.setVisibility(0);
            }
        });
    }

    private void removeSelectLoginDoorhanger() {
        if (this.mSelectLoginDoorhanger != null) {
            this.mContent.removeView((View)this.mSelectLoginDoorhanger);
            this.mSelectLoginDoorhanger = null;
        }
    }

    private void toggleIdentityKnownContainerVisibility(boolean bl) {
        int n = bl ? 0 : 8;
        this.mIdentityKnownContainer.setVisibility(n);
    }

    private void updateConnectionState(SiteIdentity siteIdentity) {
        if (siteIdentity.getSecurityMode() == SiteIdentity.SecurityMode.CHROMEUI) {
            this.mSecurityState.setText(R.string.identity_connection_chromeui);
            this.mSecurityState.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.placeholder_active_grey));
            this.mIcon.setImageResource(R.drawable.icon);
            this.clearSecurityStateIcon();
            this.mMixedContentActivity.setVisibility(8);
            this.mLink.setVisibility(8);
        } else if (!siteIdentity.isSecure()) {
            if (siteIdentity.getMixedModeActive() == SiteIdentity.MixedMode.MIXED_CONTENT_LOADED) {
                this.mIcon.setImageResource(R.drawable.lock_disabled);
                this.clearSecurityStateIcon();
                this.mMixedContentActivity.setVisibility(0);
                this.mMixedContentActivity.setText(R.string.mixed_content_protection_disabled);
                this.mLink.setVisibility(0);
            } else if (siteIdentity.getMixedModeDisplay() == SiteIdentity.MixedMode.MIXED_CONTENT_LOADED) {
                this.mIcon.setImageResource(R.drawable.lock_inactive);
                this.setSecurityStateIcon(R.drawable.warning_major, 1);
                this.mMixedContentActivity.setVisibility(0);
                if (siteIdentity.getMixedModeActive() == SiteIdentity.MixedMode.MIXED_CONTENT_BLOCKED) {
                    this.mMixedContentActivity.setText(R.string.mixed_content_blocked_some);
                } else {
                    this.mMixedContentActivity.setText(R.string.mixed_content_display_loaded);
                }
                this.mLink.setVisibility(0);
            } else {
                this.mIcon.setImageResource(R.drawable.globe_light);
                this.clearSecurityStateIcon();
                this.mMixedContentActivity.setVisibility(8);
                this.mLink.setVisibility(8);
            }
            this.mSecurityState.setText(R.string.identity_connection_insecure);
            this.mSecurityState.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.placeholder_active_grey));
        } else {
            this.mIcon.setImageResource(R.drawable.lock_secure);
            this.setSecurityStateIcon(R.drawable.img_check, 2);
            this.mSecurityState.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.affirmative_green));
            this.mSecurityState.setText(R.string.identity_connection_secure);
            if (siteIdentity.getMixedModeActive() == SiteIdentity.MixedMode.MIXED_CONTENT_BLOCKED || siteIdentity.getMixedModeDisplay() == SiteIdentity.MixedMode.MIXED_CONTENT_BLOCKED) {
                this.mMixedContentActivity.setVisibility(0);
                this.mMixedContentActivity.setText(R.string.mixed_content_blocked_all);
                this.mLink.setVisibility(0);
            } else {
                this.mMixedContentActivity.setVisibility(8);
                this.mLink.setVisibility(8);
            }
        }
    }

    private void clearSecurityStateIcon() {
        this.mSecurityState.setCompoundDrawablePadding(0);
        this.mSecurityState.setCompoundDrawables(null, null, null, null);
    }

    private void setSecurityStateIcon(int n, int n2) {
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.mContext, (int)n);
        drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth() / n2, drawable2.getIntrinsicHeight() / n2);
        this.mSecurityState.setCompoundDrawables(drawable2, null, null, null);
        this.mSecurityState.setCompoundDrawablePadding((int)this.mResources.getDimension(R.dimen.doorhanger_drawable_padding));
    }

    private void updateIdentityInformation(SiteIdentity siteIdentity) {
        String string2;
        String string3 = siteIdentity.getOwner();
        if (string3 == null) {
            this.mOwner.setVisibility(8);
            this.mOwnerSupplemental.setVisibility(8);
        } else {
            this.mOwner.setVisibility(0);
            this.mOwner.setText((CharSequence)string3);
            string2 = siteIdentity.getSupplemental();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                this.mOwnerSupplemental.setText((CharSequence)string2);
                this.mOwnerSupplemental.setVisibility(0);
            } else {
                this.mOwnerSupplemental.setVisibility(8);
            }
        }
        string2 = siteIdentity.getVerifier();
        this.mVerifier.setText((CharSequence)string2);
    }

    private void addTrackingContentNotification(boolean bl) {
        this.removeTrackingContentNotification();
        DoorhangerConfig doorhangerConfig = new DoorhangerConfig(DoorHanger.Type.TRACKING, this.mContentButtonClickListener);
        int n = bl ? R.drawable.shield_enabled : R.drawable.shield_disabled;
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        try {
            jSONObject2.put("enabled", bl);
            jSONObject.put("tracking_protection", (Object)jSONObject2);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error adding tracking protection options", (Throwable)jSONException);
        }
        doorhangerConfig.setOptions(jSONObject);
        doorhangerConfig.setLink(this.mContext.getString(R.string.learn_more), TRACKING_CONTENT_SUPPORT_URL);
        this.addNotificationButtons(doorhangerConfig, bl);
        this.mTrackingContentNotification = DoorHanger.Get(this.mContext, doorhangerConfig);
        this.mTrackingContentNotification.setIcon(n);
        this.mContent.addView((View)this.mTrackingContentNotification);
        this.mDivider.setVisibility(0);
    }

    private void removeTrackingContentNotification() {
        if (this.mTrackingContentNotification != null) {
            this.mContent.removeView((View)this.mTrackingContentNotification);
            this.mTrackingContentNotification = null;
        }
    }

    private void addNotificationButtons(DoorhangerConfig doorhangerConfig, boolean bl) {
        if (bl) {
            doorhangerConfig.setButton(this.mContext.getString(R.string.disable_protection), ButtonType.DISABLE.ordinal(), false);
        } else {
            doorhangerConfig.setButton(this.mContext.getString(R.string.enable_protection), ButtonType.ENABLE.ordinal(), true);
        }
    }

    void setSiteIdentity(SiteIdentity siteIdentity) {
        this.mSiteIdentity = siteIdentity;
    }

    @Override
    public void show() {
        if (this.mSiteIdentity == null) {
            Log.e((String)LOGTAG, (String)"Can't show site identity popup for undefined state");
            return;
        }
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null && AboutPages.isAboutPage(tab.getURL()) && this.mSiteIdentity.getSecurityMode() != SiteIdentity.SecurityMode.CHROMEUI) {
            Log.d((String)LOGTAG, (String)"We don't show site identity popups for unverified about: pages");
            return;
        }
        this.updateIdentity(this.mSiteIdentity);
        SiteIdentity.TrackingMode trackingMode = this.mSiteIdentity.getTrackingMode();
        if (trackingMode != SiteIdentity.TrackingMode.UNKNOWN) {
            this.addTrackingContentNotification(trackingMode == SiteIdentity.TrackingMode.TRACKING_CONTENT_BLOCKED);
        }
        try {
            this.addSelectLoginDoorhanger(tab);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error adding selectLogin doorhanger", (Throwable)jSONException);
        }
        if (this.mSiteIdentity.getSecurityMode() == SiteIdentity.SecurityMode.CHROMEUI) {
            this.mTitle.setText(R.string.moz_app_displayname);
        } else {
            this.mTitle.setText((CharSequence)tab.getBaseDomain());
            Bitmap bitmap = tab.getFavicon();
            if (bitmap != null) {
                BitmapDrawable bitmapDrawable = new BitmapDrawable(this.mResources, bitmap);
                int n = (int)this.mResources.getDimension(R.dimen.browser_toolbar_favicon_size);
                bitmapDrawable.setBounds(0, 0, n, n);
                this.mTitle.setCompoundDrawables((Drawable)bitmapDrawable, null, null, null);
                this.mTitle.setCompoundDrawablePadding((int)this.mContext.getResources().getDimension(R.dimen.doorhanger_drawable_padding));
            }
        }
        this.showDividers();
        super.show();
    }

    private void showDividers() {
        int n = this.mContent.getChildCount();
        DoorHanger doorHanger = null;
        for (int i = 0; i < n; ++i) {
            View view = this.mContent.getChildAt(i);
            if (!(view instanceof DoorHanger)) continue;
            DoorHanger doorHanger2 = (DoorHanger)view;
            doorHanger2.showDivider();
            if (doorHanger2.getVisibility() != 0) continue;
            doorHanger = doorHanger2;
        }
        if (doorHanger != null) {
            doorHanger.hideDivider();
        }
    }

    void destroy() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "Doorhanger:Logins");
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "Permissions:CheckResult");
    }

    @Override
    public void dismiss() {
        super.dismiss();
        this.removeTrackingContentNotification();
        this.removeSelectLoginDoorhanger();
        this.mTitle.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
        this.mDivider.setVisibility(8);
    }

    private class ContentNotificationButtonListener
    implements DoorHanger.OnButtonClickListener {
        private ContentNotificationButtonListener() {
        }

        @Override
        public void onButtonClick(JSONObject jSONObject, DoorHanger doorHanger) {
            GeckoAppShell.notifyObservers("Session:Reload", jSONObject.toString());
            SiteIdentityPopup.this.dismiss();
        }
    }

    public static enum ButtonType {
        DISABLE,
        ENABLE,
        KEEP_BLOCKING,
        CANCEL,
        COPY;

    }
}

