/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.browserid.verifier;

import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.browserid.verifier.BrowserIDVerifierClient;
import org.mozilla.gecko.browserid.verifier.BrowserIDVerifierDelegate;
import org.mozilla.gecko.browserid.verifier.BrowserIDVerifierException;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.net.Resource;
import org.mozilla.gecko.sync.net.SyncResponse;

public abstract class AbstractBrowserIDRemoteVerifierClient
implements BrowserIDVerifierClient {
    public static final String LOG_TAG = AbstractBrowserIDRemoteVerifierClient.class.getSimpleName();
    protected final URI verifierUri;

    public AbstractBrowserIDRemoteVerifierClient(URI uRI) {
        this.verifierUri = uRI;
    }

    protected static class RemoteVerifierResourceDelegate
    extends BaseResourceDelegate {
        private final BrowserIDVerifierDelegate delegate;

        protected RemoteVerifierResourceDelegate(Resource resource, BrowserIDVerifierDelegate browserIDVerifierDelegate) {
            super(resource);
            this.delegate = browserIDVerifierDelegate;
        }

        @Override
        public String getUserAgent() {
            return null;
        }

        @Override
        public void handleHttpResponse(HttpResponse httpResponse) {
            SyncResponse syncResponse = new SyncResponse(httpResponse);
            int n = syncResponse.getStatusCode();
            Logger.debug(LOG_TAG, "Got response with status code " + n + ".");
            if (n != 200) {
                this.delegate.handleError(new BrowserIDVerifierException.BrowserIDVerifierErrorResponseException("Expected status code 200."));
                return;
            }
            ExtendedJSONObject extendedJSONObject = null;
            try {
                extendedJSONObject = syncResponse.jsonObjectBody();
            }
            catch (Exception exception) {
                this.delegate.handleError(new BrowserIDVerifierException.BrowserIDVerifierMalformedResponseException(exception));
                return;
            }
            String string = extendedJSONObject.getString("status");
            if ("failure".equals(string)) {
                this.delegate.handleFailure(extendedJSONObject);
                return;
            }
            if (!"okay".equals(string)) {
                this.delegate.handleError(new BrowserIDVerifierException.BrowserIDVerifierMalformedResponseException("Expected status okay, got '" + string + "'."));
                return;
            }
            this.delegate.handleSuccess(extendedJSONObject);
        }

        @Override
        public void handleTransportException(GeneralSecurityException generalSecurityException) {
            Logger.warn(LOG_TAG, "Got transport exception.", generalSecurityException);
            this.delegate.handleError(generalSecurityException);
        }

        @Override
        public void handleHttpProtocolException(ClientProtocolException clientProtocolException) {
            Logger.warn(LOG_TAG, "Got protocol exception.", (Throwable)clientProtocolException);
            this.delegate.handleError((Exception)clientProtocolException);
        }

        @Override
        public void handleHttpIOException(IOException iOException) {
            Logger.warn(LOG_TAG, "Got IO exception.", iOException);
            this.delegate.handleError(iOException);
        }
    }
}

