/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.background.fxa.FxAccountClientException;
import org.mozilla.gecko.fxa.FxAccountDevice;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.fxa.login.TokensAndKeysState;
import org.mozilla.gecko.sync.SharedPreferencesClientsDataDelegate;

public class FxAccountDeviceRegistrator {
    public static final Integer DEVICE_REGISTRATION_VERSION = 1;
    private static final String LOG_TAG = "FxADeviceRegistrator";

    private FxAccountDeviceRegistrator() {
    }

    public static void register(AndroidFxAccount androidFxAccount, Context context) throws InvalidFxAState {
        FxAccountDeviceRegistrator.register(androidFxAccount, context, new RegisterDelegate(){

            @Override
            public void onComplete(String string2) {
            }
        });
    }

    public static void register(final AndroidFxAccount androidFxAccount, final Context context, final RegisterDelegate registerDelegate) throws InvalidFxAState {
        FxAccountDevice fxAccountDevice;
        final byte[] byArray = FxAccountDeviceRegistrator.getSessionToken(androidFxAccount);
        String string2 = androidFxAccount.getDeviceId();
        String string3 = FxAccountDeviceRegistrator.getClientName(androidFxAccount, context);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            Log.i((String)LOG_TAG, (String)"Attempting registration for a new device");
            fxAccountDevice = FxAccountDevice.forRegister(string3, "mobile");
        } else {
            Log.i((String)LOG_TAG, (String)"Attempting registration for an existing device");
            Logger.pii(LOG_TAG, "Device ID: " + string2);
            fxAccountDevice = FxAccountDevice.forUpdate(string2, string3);
        }
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final FxAccountClient20 fxAccountClient20 = new FxAccountClient20(androidFxAccount.getAccountServerURI(), executorService);
        fxAccountClient20.registerOrUpdateDevice(byArray, fxAccountDevice, new FxAccountClient20.RequestDelegate<FxAccountDevice>(){

            @Override
            public void handleError(Exception exception) {
                Log.e((String)FxAccountDeviceRegistrator.LOG_TAG, (String)"Error while updating a device registration: ", (Throwable)exception);
                registerDelegate.onComplete(null);
            }

            @Override
            public void handleFailure(FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
                Log.e((String)FxAccountDeviceRegistrator.LOG_TAG, (String)"Error while updating a device registration: ", (Throwable)fxAccountClientRemoteException);
                if (fxAccountClientRemoteException.httpStatusCode == 400L) {
                    if (fxAccountClientRemoteException.apiErrorNumber == 123L) {
                        FxAccountDeviceRegistrator.recoverFromUnknownDevice(androidFxAccount);
                        registerDelegate.onComplete(null);
                    } else if (fxAccountClientRemoteException.apiErrorNumber == 124L) {
                        FxAccountDeviceRegistrator.recoverFromDeviceSessionConflict(fxAccountClientRemoteException, fxAccountClient20, byArray, androidFxAccount, context, registerDelegate);
                    }
                } else if (fxAccountClientRemoteException.httpStatusCode == 401L && fxAccountClientRemoteException.apiErrorNumber == 110L) {
                    FxAccountDeviceRegistrator.handleTokenError(fxAccountClientRemoteException, fxAccountClient20, androidFxAccount);
                    registerDelegate.onComplete(null);
                } else {
                    FxAccountDeviceRegistrator.logErrorAndResetDeviceRegistrationVersion(fxAccountClientRemoteException, androidFxAccount);
                    registerDelegate.onComplete(null);
                }
            }

            @Override
            public void handleSuccess(FxAccountDevice fxAccountDevice) {
                Log.i((String)FxAccountDeviceRegistrator.LOG_TAG, (String)"Device registration complete");
                Logger.pii(FxAccountDeviceRegistrator.LOG_TAG, "Registered device ID: " + fxAccountDevice.id);
                androidFxAccount.setFxAUserData(fxAccountDevice.id, DEVICE_REGISTRATION_VERSION);
                registerDelegate.onComplete(fxAccountDevice.id);
            }
        });
    }

    private static void logErrorAndResetDeviceRegistrationVersion(FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException, AndroidFxAccount androidFxAccount) {
        Log.e((String)LOG_TAG, (String)"Device registration failed", (Throwable)fxAccountClientRemoteException);
        androidFxAccount.resetDeviceRegistrationVersion();
    }

    @Nullable
    private static String getClientName(AndroidFxAccount androidFxAccount, Context context) {
        try {
            SharedPreferencesClientsDataDelegate sharedPreferencesClientsDataDelegate = new SharedPreferencesClientsDataDelegate(androidFxAccount.getSyncPrefs(), context);
            return sharedPreferencesClientsDataDelegate.getClientName();
        }
        catch (UnsupportedEncodingException | GeneralSecurityException exception) {
            Log.e((String)LOG_TAG, (String)"Unable to get client name.", (Throwable)exception);
            return null;
        }
    }

    @Nullable
    private static byte[] getSessionToken(AndroidFxAccount androidFxAccount) throws InvalidFxAState {
        State state = androidFxAccount.getState();
        State.StateLabel stateLabel = state.getStateLabel();
        if (stateLabel == State.StateLabel.Cohabiting || stateLabel == State.StateLabel.Married) {
            TokensAndKeysState tokensAndKeysState = (TokensAndKeysState)state;
            return tokensAndKeysState.getSessionToken();
        }
        throw new InvalidFxAState("Cannot get sessionToken: not in a TokensAndKeysState state");
    }

    private static void handleTokenError(FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException, FxAccountClient fxAccountClient, final AndroidFxAccount androidFxAccount) {
        Log.i((String)LOG_TAG, (String)"Recovering from invalid token error: ", (Throwable)fxAccountClientRemoteException);
        FxAccountDeviceRegistrator.logErrorAndResetDeviceRegistrationVersion(fxAccountClientRemoteException, androidFxAccount);
        fxAccountClient.accountStatus(androidFxAccount.getState().uid, new FxAccountClient20.RequestDelegate<FxAccountClient20.AccountStatusResponse>(){

            @Override
            public void handleError(Exception exception) {
            }

            @Override
            public void handleFailure(FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
            }

            @Override
            public void handleSuccess(FxAccountClient20.AccountStatusResponse accountStatusResponse) {
                State state = androidFxAccount.getState().makeDoghouseState();
                if (!accountStatusResponse.exists) {
                    Log.i((String)FxAccountDeviceRegistrator.LOG_TAG, (String)"token invalidated because the account no longer exists");
                    androidFxAccount.setState(state);
                    return;
                }
                Log.e((String)FxAccountDeviceRegistrator.LOG_TAG, (String)"sessionToken invalid");
                androidFxAccount.setState(state);
            }
        });
    }

    private static void recoverFromUnknownDevice(AndroidFxAccount androidFxAccount) {
        Log.i((String)LOG_TAG, (String)"unknown device id, clearing the cached device id");
        androidFxAccount.setDeviceId(null);
    }

    private static void recoverFromDeviceSessionConflict(final FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException, FxAccountClient fxAccountClient, byte[] byArray, final AndroidFxAccount androidFxAccount, final Context context, final RegisterDelegate registerDelegate) {
        Log.w((String)LOG_TAG, (String)"device session conflict, attempting to ascertain the correct device id");
        fxAccountClient.deviceList(byArray, new FxAccountClient20.RequestDelegate<FxAccountDevice[]>(){

            private void onError() {
                Log.e((String)FxAccountDeviceRegistrator.LOG_TAG, (String)"failed to recover from device-session conflict");
                FxAccountDeviceRegistrator.logErrorAndResetDeviceRegistrationVersion(fxAccountClientRemoteException, androidFxAccount);
                registerDelegate.onComplete(null);
            }

            @Override
            public void handleError(Exception exception) {
                this.onError();
            }

            @Override
            public void handleFailure(FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException2) {
                this.onError();
            }

            @Override
            public void handleSuccess(FxAccountDevice[] fxAccountDeviceArray) {
                for (FxAccountDevice fxAccountDevice : fxAccountDeviceArray) {
                    if (!fxAccountDevice.isCurrentDevice.booleanValue()) continue;
                    androidFxAccount.setFxAUserData(fxAccountDevice.id, 0);
                    if (!registerDelegate.allowRecursion) {
                        Log.d((String)FxAccountDeviceRegistrator.LOG_TAG, (String)"Failure to register a device on the second try");
                        break;
                    }
                    registerDelegate.allowRecursion = false;
                    try {
                        FxAccountDeviceRegistrator.register(androidFxAccount, context, registerDelegate);
                        return;
                    }
                    catch (InvalidFxAState invalidFxAState) {
                        Log.d((String)FxAccountDeviceRegistrator.LOG_TAG, (String)"Invalid state when trying to recover from a session conflict ", (Throwable)invalidFxAState);
                        break;
                    }
                }
                this.onError();
            }
        });
    }

    public static class InvalidFxAState
    extends Exception {
        private static final long serialVersionUID = -8537626959811195978L;

        public InvalidFxAState(String string2) {
            super(string2);
        }
    }

    public static abstract class RegisterDelegate {
        private boolean allowRecursion = true;

        protected abstract void onComplete(String var1);
    }
}

