/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import android.accounts.Account;
import android.content.Context;
import android.content.SharedPreferences;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.delegates.ClientsDataDelegate;
import org.mozilla.gecko.util.HardwareUtils;

public class SharedPreferencesClientsDataDelegate
implements ClientsDataDelegate {
    protected final SharedPreferences sharedPreferences;
    protected final Context context;

    public SharedPreferencesClientsDataDelegate(SharedPreferences sharedPreferences, Context context) {
        this.sharedPreferences = sharedPreferences;
        this.context = context;
        HardwareUtils.init((Context)context);
    }

    @Override
    public synchronized String getAccountGUID() {
        String string2 = this.sharedPreferences.getString("account.guid", null);
        if (string2 == null) {
            string2 = Utils.generateGuid();
            this.sharedPreferences.edit().putString("account.guid", string2).commit();
        }
        return string2;
    }

    private synchronized void saveClientNameToSharedPreferences(String string2, long l) {
        this.sharedPreferences.edit().putString("account.clientName", string2).putLong("account.clientDataTimestamp", l).apply();
    }

    @Override
    public synchronized void setClientName(String string2, long l) {
        this.saveClientNameToSharedPreferences(string2, l);
        Account account = FirefoxAccounts.getFirefoxAccount(this.context);
        if (account != null) {
            AndroidFxAccount androidFxAccount = new AndroidFxAccount(this.context, account);
            androidFxAccount.resetDeviceRegistrationVersion();
        }
    }

    @Override
    public String getDefaultClientName() {
        return FxAccountUtils.defaultClientName(this.context);
    }

    @Override
    public synchronized String getClientName() {
        String string2 = this.sharedPreferences.getString("account.clientName", null);
        if (string2 == null) {
            string2 = this.getDefaultClientName();
            long l = System.currentTimeMillis();
            this.saveClientNameToSharedPreferences(string2, l);
        }
        return string2;
    }

    @Override
    public synchronized void setClientsCount(int n) {
        this.sharedPreferences.edit().putLong("account.numClients", (long)n).commit();
    }

    @Override
    public boolean isLocalGUID(String string2) {
        return this.getAccountGUID().equals(string2);
    }

    @Override
    public synchronized int getClientsCount() {
        return (int)this.sharedPreferences.getLong("account.numClients", 0L);
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.sharedPreferences.getLong("account.clientDataTimestamp", 0L);
    }

    @Override
    public String getFormFactor() {
        if (HardwareUtils.isLargeTablet()) {
            return "largetablet";
        }
        if (HardwareUtils.isSmallTablet()) {
            return "smalltablet";
        }
        if (HardwareUtils.isTelevision()) {
            return "tv";
        }
        return "phone";
    }
}

