/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.net;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpEntityEnclosingRequest;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestBase;
import ch.boye.httpclientandroidlib.client.methods.HttpUriRequest;
import ch.boye.httpclientandroidlib.impl.client.DefaultHttpClient;
import ch.boye.httpclientandroidlib.message.BasicHeader;
import ch.boye.httpclientandroidlib.protocol.BasicHttpContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.mozilla.apache.commons.codec.binary.Base64;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;

public class HawkAuthHeaderProvider
implements AuthHeaderProvider {
    public static final String LOG_TAG = HawkAuthHeaderProvider.class.getSimpleName();
    public static final int HAWK_HEADER_VERSION = 1;
    protected static final int NONCE_LENGTH_IN_BYTES = 8;
    protected static final String HMAC_SHA256_ALGORITHM = "hmacSHA256";
    protected final String id;
    protected final byte[] key;
    protected final boolean includePayloadHash;
    protected final long skewSeconds;

    public HawkAuthHeaderProvider(String string, byte[] byArray, boolean bl, long l) {
        if (string == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.id = string;
        this.key = byArray;
        this.includePayloadHash = bl;
        this.skewSeconds = l;
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    protected long getTimestampSeconds() {
        return this.now() / 1000L + this.skewSeconds;
    }

    @Override
    public Header getAuthHeader(HttpRequestBase httpRequestBase, BasicHttpContext basicHttpContext, DefaultHttpClient defaultHttpClient) throws GeneralSecurityException {
        long l = this.getTimestampSeconds();
        String string = Base64.encodeBase64String((byte[])Utils.generateRandomBytes(8));
        String string2 = "";
        try {
            return this.getAuthHeader(httpRequestBase, basicHttpContext, defaultHttpClient, l, string, string2, this.includePayloadHash);
        }
        catch (Exception exception) {
            throw new GeneralSecurityException(exception);
        }
    }

    protected Header getAuthHeader(HttpRequestBase httpRequestBase, BasicHttpContext basicHttpContext, DefaultHttpClient defaultHttpClient, long l, String string, String string2, boolean bl) throws InvalidKeyException, NoSuchAlgorithmException, IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("timestamp must contain only [0-9].");
        }
        if (string == null) {
            throw new IllegalArgumentException("nonce must not be null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("nonce must not be empty.");
        }
        String string3 = null;
        if (bl) {
            string3 = HawkAuthHeaderProvider.getPayloadHashString(httpRequestBase);
        } else {
            Logger.debug(LOG_TAG, "Configured to not include payload hash for this request.");
        }
        String string4 = null;
        String string5 = null;
        String string6 = HawkAuthHeaderProvider.getRequestString((HttpUriRequest)httpRequestBase, "header", l, string, string3, string2, string4, string5);
        String string7 = HawkAuthHeaderProvider.getSignature(string6.getBytes("UTF-8"), this.key);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Hawk id=\"");
        stringBuilder.append(this.id);
        stringBuilder.append("\", ");
        stringBuilder.append("ts=\"");
        stringBuilder.append(l);
        stringBuilder.append("\", ");
        stringBuilder.append("nonce=\"");
        stringBuilder.append(string);
        stringBuilder.append("\", ");
        if (string3 != null) {
            stringBuilder.append("hash=\"");
            stringBuilder.append(string3);
            stringBuilder.append("\", ");
        }
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append("ext=\"");
            stringBuilder.append(HawkAuthHeaderProvider.escapeExtraHeaderAttribute(string2));
            stringBuilder.append("\", ");
        }
        stringBuilder.append("mac=\"");
        stringBuilder.append(string7);
        stringBuilder.append("\"");
        return new BasicHeader("Authorization", stringBuilder.toString());
    }

    protected static String getPayloadHashString(HttpRequestBase httpRequestBase) throws UnsupportedEncodingException, NoSuchAlgorithmException, IOException, IllegalArgumentException {
        boolean bl = httpRequestBase instanceof HttpEntityEnclosingRequest;
        if (!bl) {
            Logger.debug(LOG_TAG, "Not computing payload verification hash for non-enclosing request.");
            return null;
        }
        if (!(httpRequestBase instanceof HttpEntityEnclosingRequest)) {
            throw new IllegalArgumentException("Cannot compute payload verification hash for enclosing request without an entity");
        }
        HttpEntity httpEntity = ((HttpEntityEnclosingRequest)httpRequestBase).getEntity();
        if (httpEntity == null) {
            throw new IllegalArgumentException("Cannot compute payload verification hash for enclosing request with a null entity");
        }
        return Base64.encodeBase64String((byte[])HawkAuthHeaderProvider.getPayloadHash(httpEntity));
    }

    protected static String escapeExtraHeaderAttribute(String string) {
        return string.replaceAll("\\\\", "\\\\").replaceAll("\"", "\\\"");
    }

    protected static String escapeExtraString(String string) {
        return string.replaceAll("\\\\", "\\\\").replaceAll("\n", "\\n");
    }

    protected static String getBaseContentType(Header header) {
        if (header == null) {
            throw new IllegalArgumentException("contentTypeHeader must not be null.");
        }
        String string = header.getValue();
        if (string == null) {
            throw new IllegalArgumentException("contentTypeHeader value must not be null.");
        }
        int n = string.indexOf(";");
        if (n < 0) {
            return string.trim();
        }
        return string.substring(0, n).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] getPayloadHash(HttpEntity httpEntity) throws UnsupportedEncodingException, IOException, NoSuchAlgorithmException {
        if (!httpEntity.isRepeatable()) {
            throw new IllegalArgumentException("entity must be repeatable");
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update("hawk.1.payload\n".getBytes("UTF-8"));
        messageDigest.update(HawkAuthHeaderProvider.getBaseContentType(httpEntity.getContentType()).getBytes("UTF-8"));
        messageDigest.update("\n".getBytes("UTF-8"));
        try (InputStream inputStream = httpEntity.getContent();){
            int n;
            byte[] byArray = new byte[4096];
            while (-1 != (n = inputStream.read(byArray))) {
                if (n <= 0) continue;
                messageDigest.update(byArray, 0, n);
            }
            messageDigest.update("\n".getBytes("UTF-8"));
            byte[] byArray2 = messageDigest.digest();
            return byArray2;
        }
    }

    protected static String getRequestString(HttpUriRequest httpUriRequest, String string, long l, String string2, String string3, String string4, String string5, String string6) {
        String string7 = httpUriRequest.getMethod().toUpperCase(Locale.US);
        URI uRI = httpUriRequest.getURI();
        String string8 = uRI.getHost();
        String string9 = uRI.getRawPath();
        if (uRI.getRawQuery() != null) {
            string9 = string9 + "?";
            string9 = string9 + uRI.getRawQuery();
        }
        if (uRI.getRawFragment() != null) {
            string9 = string9 + "#";
            string9 = string9 + uRI.getRawFragment();
        }
        int n = uRI.getPort();
        String string10 = uRI.getScheme();
        if (n == -1) {
            if ("http".equalsIgnoreCase(string10)) {
                n = 80;
            } else if ("https".equalsIgnoreCase(string10)) {
                n = 443;
            } else {
                throw new IllegalArgumentException("Unsupported URI scheme: " + string10 + ".");
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("hawk.");
        stringBuilder.append(1);
        stringBuilder.append('.');
        stringBuilder.append(string);
        stringBuilder.append('\n');
        stringBuilder.append(l);
        stringBuilder.append('\n');
        stringBuilder.append(string2);
        stringBuilder.append('\n');
        stringBuilder.append(string7);
        stringBuilder.append('\n');
        stringBuilder.append(string9);
        stringBuilder.append('\n');
        stringBuilder.append(string8);
        stringBuilder.append('\n');
        stringBuilder.append(n);
        stringBuilder.append('\n');
        if (string3 != null) {
            stringBuilder.append(string3);
        }
        stringBuilder.append("\n");
        if (string4 != null && string4.length() > 0) {
            stringBuilder.append(HawkAuthHeaderProvider.escapeExtraString(string4));
        }
        stringBuilder.append("\n");
        if (string5 != null) {
            stringBuilder.append(string5);
            stringBuilder.append("\n");
            if (string6 != null) {
                stringBuilder.append(string6);
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    protected static byte[] hmacSha256(byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, HMAC_SHA256_ALGORITHM);
        Mac mac = Mac.getInstance(HMAC_SHA256_ALGORITHM);
        mac.init(secretKeySpec);
        mac.update(byArray);
        return mac.doFinal();
    }

    protected static String getSignature(byte[] byArray, byte[] byArray2) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException {
        return Base64.encodeBase64String((byte[])HawkAuthHeaderProvider.hmacSha256(byArray, byArray2));
    }
}

