/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.domain;

import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.repositories.android.RepoUtils;
import org.mozilla.gecko.sync.repositories.domain.Record;

public class FormHistoryRecord
extends Record {
    private static final String LOG_TAG = "FormHistoryRecord";
    public static final String COLLECTION_NAME = "forms";
    private static final String PAYLOAD_NAME = "name";
    private static final String PAYLOAD_VALUE = "value";
    public static final long FORMS_TTL = 94608000L;
    public String fieldName;
    public String fieldValue;

    public FormHistoryRecord(String string2, String string3, long l, boolean bl) {
        super(string2, string3, l, bl);
        this.ttl = 94608000L;
    }

    public FormHistoryRecord(String string2, String string3, long l) {
        this(string2, string3, l, false);
    }

    public FormHistoryRecord(String string2, String string3) {
        this(string2, string3, 0L, false);
    }

    public FormHistoryRecord(String string2) {
        this(string2, COLLECTION_NAME, 0L, false);
    }

    public FormHistoryRecord() {
        this(Utils.generateGuid(), COLLECTION_NAME, 0L, false);
    }

    @Override
    public Record copyWithIDs(String string2, long l) {
        FormHistoryRecord formHistoryRecord = new FormHistoryRecord(string2, this.collection, this.lastModified, this.deleted);
        formHistoryRecord.androidID = l;
        formHistoryRecord.sortIndex = this.sortIndex;
        formHistoryRecord.fieldName = this.fieldName;
        formHistoryRecord.fieldValue = this.fieldValue;
        return formHistoryRecord;
    }

    @Override
    public void populatePayload(ExtendedJSONObject extendedJSONObject) {
        this.putPayload(extendedJSONObject, PAYLOAD_NAME, this.fieldName);
        this.putPayload(extendedJSONObject, PAYLOAD_VALUE, this.fieldValue);
    }

    @Override
    public void initFromPayload(ExtendedJSONObject extendedJSONObject) {
        this.fieldName = extendedJSONObject.getString(PAYLOAD_NAME);
        this.fieldValue = extendedJSONObject.getString(PAYLOAD_VALUE);
    }

    @Override
    public boolean congruentWith(Object object) {
        if (!(object instanceof FormHistoryRecord)) {
            return false;
        }
        FormHistoryRecord formHistoryRecord = (FormHistoryRecord)object;
        if (!super.congruentWith(formHistoryRecord)) {
            return false;
        }
        return RepoUtils.stringsEqual(this.fieldName, formHistoryRecord.fieldName) && RepoUtils.stringsEqual(this.fieldValue, formHistoryRecord.fieldValue);
    }

    @Override
    public boolean equalPayloads(Object object) {
        if (!(object instanceof FormHistoryRecord)) {
            Logger.debug(LOG_TAG, "Not a FormHistoryRecord: " + object.getClass());
            return false;
        }
        FormHistoryRecord formHistoryRecord = (FormHistoryRecord)object;
        if (!super.equalPayloads(formHistoryRecord)) {
            Logger.debug(LOG_TAG, "super.equalPayloads returned false.");
            return false;
        }
        if (this.deleted) {
            if (formHistoryRecord.deleted) {
                return RepoUtils.stringsEqual(this.guid, formHistoryRecord.guid);
            }
            return false;
        }
        return RepoUtils.stringsEqual(this.fieldName, formHistoryRecord.fieldName) && RepoUtils.stringsEqual(this.fieldValue, formHistoryRecord.fieldValue);
    }

    public FormHistoryRecord log(String string2) {
        try {
            Logger.debug(string2, "Returning form history record " + this.guid + " (" + this.androidID + ")");
            Logger.debug(string2, "> Last modified: " + this.lastModified);
            if (Logger.LOG_PERSONAL_INFORMATION) {
                Logger.pii(string2, "> Field name:    " + this.fieldName);
                Logger.pii(string2, "> Field value:   " + this.fieldValue);
            }
        }
        catch (Exception exception) {
            Logger.debug(string2, "Exception logging form history record " + this, exception);
        }
        return this;
    }
}

