;; Test all the f64 comparison operators on major boundary values and all
;; special values.

(module
  (func $eq (param $x f64) (param $y f64) (result i32) (f64.eq (get_local $x) (get_local $y)))
  (func $ne (param $x f64) (param $y f64) (result i32) (f64.ne (get_local $x) (get_local $y)))
  (func $lt (param $x f64) (param $y f64) (result i32) (f64.lt (get_local $x) (get_local $y)))
  (func $le (param $x f64) (param $y f64) (result i32) (f64.le (get_local $x) (get_local $y)))
  (func $gt (param $x f64) (param $y f64) (result i32) (f64.gt (get_local $x) (get_local $y)))
  (func $ge (param $x f64) (param $y f64) (result i32) (f64.ge (get_local $x) (get_local $y)))

  (export "eq" $eq)
  (export "ne" $ne)
  (export "lt" $lt)
  (export "le" $le)
  (export "gt" $gt)
  (export "ge" $ge)
)

(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x0.0000000000001p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x0.0000000000001p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p-1) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p-1) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -infinity) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -infinity) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const infinity) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const infinity) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -infinity) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -infinity) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const infinity) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const infinity) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -infinity) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -infinity) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const infinity) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const infinity) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -infinity) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -infinity) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const infinity) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const infinity) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -infinity) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -infinity) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const infinity) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const infinity) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -infinity) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -infinity) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const infinity) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const infinity) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -infinity) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -infinity) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const infinity) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const infinity) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -infinity) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -infinity) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const infinity) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const infinity) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "eq" (f64.const -infinity) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -infinity) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const infinity) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const infinity) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const -nan) (f64.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f64.const nan) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0p+0) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0p+0) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x0.0000000000001p-1022) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x0.0000000000001p-1022) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1022) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1022) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p-1) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p-1) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1p+0) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1p+0) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -infinity) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -infinity) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const infinity) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const infinity) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -infinity) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -infinity) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const infinity) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const infinity) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -infinity) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -infinity) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const infinity) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const infinity) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -infinity) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -infinity) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const infinity) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const infinity) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -infinity) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -infinity) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const infinity) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const infinity) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -infinity) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -infinity) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const infinity) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const infinity) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -infinity) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -infinity) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const infinity) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const infinity) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -infinity) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -infinity) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const infinity) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const infinity) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "ne" (f64.const -infinity) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -infinity) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const infinity) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const infinity) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const -nan) (f64.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f64.const nan) (f64.const nan)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x0.0000000000001p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x0.0000000000001p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p-1) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p-1) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -infinity) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -infinity) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const infinity) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const infinity) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -infinity) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -infinity) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const infinity) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const infinity) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -infinity) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -infinity) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "lt" (f64.const infinity) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const infinity) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -infinity) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -infinity) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f64.const infinity) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const infinity) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -infinity) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -infinity) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f64.const infinity) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const infinity) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -infinity) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -infinity) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "lt" (f64.const infinity) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const infinity) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -infinity) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const -infinity) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "lt" (f64.const infinity) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const infinity) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -infinity) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -infinity) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f64.const infinity) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f64.const infinity) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -infinity) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -infinity) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const infinity) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const infinity) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const -nan) (f64.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f64.const nan) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x0.0000000000001p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x0.0000000000001p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p-1) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p-1) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -infinity) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -infinity) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const infinity) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const infinity) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -infinity) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -infinity) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const infinity) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const infinity) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -infinity) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const -infinity) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "le" (f64.const infinity) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const infinity) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -infinity) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const -infinity) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f64.const infinity) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const infinity) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const -infinity) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const -infinity) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f64.const infinity) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const infinity) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -infinity) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const -infinity) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "le" (f64.const infinity) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const infinity) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const -infinity) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const -infinity) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "le" (f64.const infinity) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const infinity) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const -infinity) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "le" (f64.const -infinity) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f64.const infinity) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f64.const infinity) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f64.const -infinity) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -infinity) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const infinity) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const infinity) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const -nan) (f64.const nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f64.const nan) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x0.0000000000001p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x0.0000000000001p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p-1) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p-1) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -infinity) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -infinity) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const infinity) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const infinity) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -infinity) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -infinity) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const infinity) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const infinity) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -infinity) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -infinity) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const infinity) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const infinity) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -infinity) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -infinity) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const infinity) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const infinity) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -infinity) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -infinity) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const infinity) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const infinity) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -infinity) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -infinity) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const infinity) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const infinity) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -infinity) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -infinity) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const infinity) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const infinity) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "gt" (f64.const -infinity) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -infinity) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f64.const infinity) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f64.const infinity) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -infinity) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -infinity) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const infinity) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const infinity) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const -nan) (f64.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f64.const nan) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x0.0000000000001p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x0.0000000000001p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1022) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p-1) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p-1) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1p+0) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.921fb54442d18p+2) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -infinity) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -infinity) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const infinity) (f64.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const infinity) (f64.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -infinity) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -infinity) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const infinity) (f64.const -0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const infinity) (f64.const 0x0.0000000000001p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -infinity) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -infinity) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const infinity) (f64.const -0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const infinity) (f64.const 0x1p-1022)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -infinity) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -infinity) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const infinity) (f64.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const infinity) (f64.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -infinity) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -infinity) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const infinity) (f64.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const infinity) (f64.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -infinity) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -infinity) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const infinity) (f64.const -0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const infinity) (f64.const 0x1.921fb54442d18p+2)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -infinity) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -infinity) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const infinity) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const infinity) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -infinity) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -infinity) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f64.const infinity) (f64.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f64.const infinity) (f64.const infinity)) (i32.const 1))
(assert_return (invoke "ge" (f64.const -infinity) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -infinity) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const infinity) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const infinity) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const -0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const 0x1p-1022)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const -0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const 0x1.921fb54442d18p+2)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const -0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const 0x1.fffffffffffffp+1023)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const -infinity)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const -nan) (f64.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f64.const nan) (f64.const nan)) (i32.const 0))
