/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.util.Log;
import org.mozilla.gecko.ActivityHandlerHelper;
import org.mozilla.gecko.R;
import org.mozilla.gecko.util.ActivityResultHandler;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.InputOptionsUtils;

public class DevToolsAuthHelper {
    private static final String LOGTAG = "GeckoDevToolsAuthHelper";

    public static void scan(Context context, final EventCallback eventCallback) {
        Intent intent = InputOptionsUtils.createQRCodeReaderIntent();
        intent.putExtra("PROMPT_MESSAGE", context.getString(R.string.devtools_auth_scan_header));
        PackageManager packageManager = context.getPackageManager();
        if (packageManager.resolveActivity(intent, 0) == null) {
            Log.w((String)LOGTAG, (String)"PackageManager can't resolve the activity.");
            eventCallback.sendError((Object)"PackageManager can't resolve the activity.");
            return;
        }
        ActivityHandlerHelper.startIntent(intent, new ActivityResultHandler(){

            public void onActivityResult(int n, Intent intent) {
                if (n == -1) {
                    String string2 = intent.getStringExtra("SCAN_RESULT");
                    eventCallback.sendSuccess((Object)string2);
                } else {
                    eventCallback.sendError((Object)n);
                }
            }
        });
    }
}

