/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.util.INIParser;
import org.mozilla.gecko.util.INISection;

public class GeckoProfileDirectories {
    private static final String MOZILLA_DIR_NAME = "mozilla";
    private static final INISectionPredicate sectionIsDefault = new INISectionPredicate(){

        @Override
        public boolean matches(INISection iNISection) {
            return iNISection.getIntProperty("Default") == 1;
        }
    };
    private static final INISectionPredicate sectionHasName = new INISectionPredicate(){

        @Override
        public boolean matches(INISection iNISection) {
            String string2 = iNISection.getStringProperty("Name");
            return string2 != null;
        }
    };

    @RobocopTarget
    public static INIParser getProfilesINI(File file) {
        return new INIParser(new File(file, "profiles.ini"));
    }

    public static String saltProfileName(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Cannot salt null profile name.");
        }
        int n = "abcdefghijklmnopqrstuvwxyz0123456789".length();
        StringBuilder stringBuilder = new StringBuilder(9 + string2.length());
        for (int i = 0; i < 8; ++i) {
            stringBuilder.append("abcdefghijklmnopqrstuvwxyz0123456789".charAt((int)(Math.random() * (double)n)));
        }
        stringBuilder.append('.');
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    @RobocopTarget
    public static File getMozillaDirectory(Context context) throws NoMozillaDirectoryException {
        File file = new File(context.getFilesDir(), MOZILLA_DIR_NAME);
        if (file.mkdirs() || file.isDirectory()) {
            return file;
        }
        throw new NoMozillaDirectoryException("Unable to create mozilla directory at " + file.getAbsolutePath());
    }

    static String findDefaultProfileName(Context context) throws NoMozillaDirectoryException {
        INIParser iNIParser = GeckoProfileDirectories.getProfilesINI(GeckoProfileDirectories.getMozillaDirectory(context));
        if (iNIParser.getSections() != null) {
            Enumeration enumeration = iNIParser.getSections().elements();
            while (enumeration.hasMoreElements()) {
                INISection iNISection = (INISection)enumeration.nextElement();
                if (iNISection.getIntProperty("Default") != 1) continue;
                return iNISection.getStringProperty("Name");
            }
        }
        return null;
    }

    static Map<String, String> getDefaultProfile(File file) {
        return GeckoProfileDirectories.getMatchingProfiles(file, sectionIsDefault, true);
    }

    static Map<String, String> getProfilesNamed(File file, final String string2) {
        INISectionPredicate iNISectionPredicate = new INISectionPredicate(){

            @Override
            public boolean matches(INISection iNISection) {
                return string2.equals(iNISection.getStringProperty("Name"));
            }
        };
        return GeckoProfileDirectories.getMatchingProfiles(file, iNISectionPredicate, true);
    }

    static Map<String, String> getAllProfiles(File file) {
        return GeckoProfileDirectories.getMatchingProfiles(file, sectionHasName, false);
    }

    public static Map<String, String> getMatchingProfiles(File file, INISectionPredicate iNISectionPredicate, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        INIParser iNIParser = GeckoProfileDirectories.getProfilesINI(file);
        if (iNIParser.getSections() != null) {
            Enumeration enumeration = iNIParser.getSections().elements();
            while (enumeration.hasMoreElements()) {
                INISection iNISection = (INISection)enumeration.nextElement();
                if (iNISectionPredicate != null && !iNISectionPredicate.matches(iNISection)) continue;
                String string2 = iNISection.getStringProperty("Name");
                String string3 = iNISection.getStringProperty("Path");
                boolean bl2 = iNISection.getIntProperty("IsRelative") == 1;
                File file2 = bl2 ? new File(file, string3) : new File(string3);
                hashMap.put(string2, file2.getAbsolutePath());
                if (!bl) continue;
                return hashMap;
            }
        }
        return hashMap;
    }

    public static File findProfileDir(File file, String string2) throws NoSuchProfileException {
        INIParser iNIParser = GeckoProfileDirectories.getProfilesINI(file);
        if (iNIParser.getSections() != null) {
            Enumeration enumeration = iNIParser.getSections().elements();
            while (enumeration.hasMoreElements()) {
                INISection iNISection = (INISection)enumeration.nextElement();
                String string3 = iNISection.getStringProperty("Name");
                if (string3 == null || !string3.equals(string2)) continue;
                if (iNISection.getIntProperty("IsRelative") == 1) {
                    return new File(file, iNISection.getStringProperty("Path"));
                }
                return new File(iNISection.getStringProperty("Path"));
            }
        }
        throw new NoSuchProfileException("No profile " + string2);
    }

    private static interface INISectionPredicate {
        public boolean matches(INISection var1);
    }

    public static class NoSuchProfileException
    extends Exception {
        public NoSuchProfileException(String string2, Throwable throwable) {
            super(string2, throwable);
        }

        public NoSuchProfileException(String string2) {
            super(string2);
        }
    }

    public static class NoMozillaDirectoryException
    extends Exception {
        public NoMozillaDirectoryException(Throwable throwable) {
            super(throwable);
        }

        public NoMozillaDirectoryException(String string2) {
            super(string2);
        }

        public NoMozillaDirectoryException(String string2, Throwable throwable) {
            super(string2, throwable);
        }
    }
}

