/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.NotificationHelper;
import org.mozilla.gecko.mozglue.SafeIntent;

public class NotificationReceiver
extends BroadcastReceiver {
    private static final String LOGTAG = "Gecko" + NotificationReceiver.class.getSimpleName();

    public void onReceive(Context context, Intent intent) {
        Uri uri = intent.getData();
        if (uri == null) {
            Log.e((String)LOGTAG, (String)"handleNotificationEvent: empty data");
            return;
        }
        String string2 = uri.getQueryParameter("eventType");
        if (string2 == null) {
            return;
        }
        if ("notification-cleared".equals(string2)) {
            if (GeckoThread.isRunning()) {
                NotificationHelper.getArgsAndSendNotificationIntent(new SafeIntent(intent));
            }
            return;
        }
        this.forwardMessageToActivity(intent, context);
    }

    private void forwardMessageToActivity(Intent intent, Context context) {
        ComponentName componentName = (ComponentName)intent.getExtras().getParcelable("originalComponent");
        intent.setComponent(componentName);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }
}

