/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.support.annotation.StringRes;
import android.support.design.R;
import android.support.design.widget.Snackbar;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.widget.TextView;
import java.lang.ref.WeakReference;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.R;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.NativeJSObject;

public class SnackbarBuilder {
    public static final String LOGTAG = "GeckoSnackbarBuilder";
    private static final Object currentSnackbarLock = new Object();
    private static WeakReference<Snackbar> currentSnackbar = new WeakReference<Object>(null);
    private final Activity activity;
    private String message;
    private int duration;
    private String action;
    private SnackbarCallback callback;
    private Drawable icon;
    private Integer backgroundColor;
    private Integer actionColor;

    private SnackbarBuilder(Activity activity) {
        this.activity = activity;
    }

    public static SnackbarBuilder builder(Activity activity) {
        return new SnackbarBuilder(activity);
    }

    public SnackbarBuilder message(String string2) {
        this.message = string2;
        return this;
    }

    public SnackbarBuilder message(@StringRes int n) {
        this.message = this.activity.getResources().getString(n);
        return this;
    }

    public SnackbarBuilder duration(int n) {
        this.duration = n;
        return this;
    }

    public SnackbarBuilder action(String string2) {
        this.action = string2;
        return this;
    }

    public SnackbarBuilder action(@StringRes int n) {
        this.action = this.activity.getResources().getString(n);
        return this;
    }

    public SnackbarBuilder callback(SnackbarCallback snackbarCallback) {
        this.callback = snackbarCallback;
        return this;
    }

    public SnackbarBuilder callback(EventCallback eventCallback) {
        this.callback = new SnackbarEventCallback(eventCallback);
        return this;
    }

    public SnackbarBuilder icon(Drawable drawable2) {
        this.icon = drawable2;
        return this;
    }

    public SnackbarBuilder backgroundColor(Integer n) {
        this.backgroundColor = n;
        return this;
    }

    public SnackbarBuilder actionColor(Integer n) {
        this.actionColor = n;
        return this;
    }

    public SnackbarBuilder fromEvent(NativeJSObject nativeJSObject) {
        String string2;
        this.message = nativeJSObject.getString("message");
        this.duration = nativeJSObject.getInt("duration");
        if (nativeJSObject.has("backgroundColor")) {
            string2 = nativeJSObject.getString("backgroundColor");
            try {
                this.backgroundColor = Color.parseColor((String)string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w((String)LOGTAG, (String)("Failed to parse color string: " + string2));
            }
        }
        if ((string2 = nativeJSObject.optObject("action", null)) != null) {
            this.action = string2.optString("label", null);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildAndShow() {
        View view = SnackbarBuilder.findBestParentView(this.activity);
        Snackbar snackbar = Snackbar.make((View)view, (CharSequence)this.message, (int)this.duration);
        if (this.callback != null && !TextUtils.isEmpty((CharSequence)this.action)) {
            snackbar.setAction((CharSequence)this.action, (View.OnClickListener)this.callback);
            if (this.actionColor == null) {
                snackbar.setActionTextColor(ContextCompat.getColor((Context)this.activity, (int)R.color.fennec_ui_orange));
            } else {
                snackbar.setActionTextColor(this.actionColor.intValue());
            }
            snackbar.setCallback((Snackbar.Callback)this.callback);
        }
        if (this.icon != null) {
            int n = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.activity.getResources().getDisplayMetrics());
            InsetDrawable insetDrawable = new InsetDrawable(this.icon, 0, 0, n, 0);
            insetDrawable.setBounds(0, 0, n + this.icon.getIntrinsicWidth(), this.icon.getIntrinsicHeight());
            TextView textView = (TextView)snackbar.getView().findViewById(R.id.snackbar_text);
            textView.setCompoundDrawables((Drawable)insetDrawable, null, null, null);
        }
        if (this.backgroundColor != null) {
            snackbar.getView().setBackgroundColor(this.backgroundColor.intValue());
        }
        snackbar.show();
        Object object = currentSnackbarLock;
        synchronized (object) {
            currentSnackbar = new WeakReference<Snackbar>(snackbar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dismissCurrentSnackbar() {
        Object object = currentSnackbarLock;
        synchronized (object) {
            Snackbar snackbar = (Snackbar)currentSnackbar.get();
            if (snackbar != null && snackbar.isShown()) {
                snackbar.dismiss();
            }
        }
    }

    private static View findBestParentView(Activity activity) {
        View view;
        if (activity instanceof GeckoApp && (view = activity.findViewById(R.id.root_layout)) != null) {
            return view;
        }
        return activity.findViewById(0x1020002);
    }

    private static class SnackbarEventCallback
    extends SnackbarCallback {
        private EventCallback callback;

        public SnackbarEventCallback(EventCallback eventCallback) {
            this.callback = eventCallback;
        }

        public synchronized void onClick(View view) {
            if (this.callback == null) {
                return;
            }
            this.callback.sendSuccess(null);
            this.callback = null;
        }

        public synchronized void onDismissed(Snackbar snackbar, int n) {
            if (this.callback == null || n == 1) {
                return;
            }
            this.callback.sendError(null);
            this.callback = null;
        }
    }

    public static abstract class SnackbarCallback
    extends Snackbar.Callback
    implements View.OnClickListener {
    }
}

