/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.distribution;

import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.CursorWrapper;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import java.util.HashSet;
import java.util.Set;
import org.mozilla.gecko.GeckoSharedPrefs;

public class PartnerBookmarksProviderProxy
extends ContentProvider {
    private static final String AUTHORITY_PREFIX = ".partnerbookmarks";
    private static final int URI_MATCH_BOOKMARKS = 1000;
    private static final int URI_MATCH_ICON = 1001;
    private static final int URI_MATCH_BOOKMARK = 1002;
    private static final String PREF_DELETED_PARTNER_BOOKMARKS = "distribution.partner.bookmark.deleted";
    private final UriMatcher uriMatcher = new UriMatcher(-1);

    private static String getAuthority(Context context) {
        return context.getPackageName() + AUTHORITY_PREFIX;
    }

    public static Uri getUriForBookmarks(Context context, long l) {
        return new Uri.Builder().scheme("content").authority(PartnerBookmarksProviderProxy.getAuthority(context)).appendPath("bookmarks").appendPath(String.valueOf(l)).build();
    }

    public static Uri getUriForIcon(Context context, long l) {
        return new Uri.Builder().scheme("content").authority(PartnerBookmarksProviderProxy.getAuthority(context)).appendPath("icons").appendPath(String.valueOf(l)).build();
    }

    public static Uri getUriForBookmark(Context context, long l) {
        return new Uri.Builder().scheme("content").authority(PartnerBookmarksProviderProxy.getAuthority(context)).appendPath("bookmark").appendPath(String.valueOf(l)).build();
    }

    public boolean onCreate() {
        String string2 = PartnerBookmarksProviderProxy.getAuthority(this.assertAndGetContext());
        this.uriMatcher.addURI(string2, "bookmarks/*", 1000);
        this.uriMatcher.addURI(string2, "icons/*", 1001);
        this.uriMatcher.addURI(string2, "bookmark/*", 1002);
        return true;
    }

    public Cursor query(@NonNull Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        Context context = this.assertAndGetContext();
        int n = this.uriMatcher.match(uri);
        ContentResolver contentResolver = context.getContentResolver();
        switch (n) {
            case 1000: {
                long l = ContentUris.parseId((Uri)uri);
                if (l == -1L) {
                    throw new IllegalArgumentException("Bookmark id is not a number");
                }
                Cursor cursor = this.getBookmarksInFolder(contentResolver, l);
                cursor.setNotificationUri(context.getContentResolver(), uri);
                return new FilteredCursor(this, cursor);
            }
            case 1001: {
                return this.getIcon(contentResolver, ContentUris.parseId((Uri)uri));
            }
        }
        throw new UnsupportedOperationException("Unknown URI " + uri.toString());
    }

    public int delete(@NonNull Uri uri, String string2, String[] stringArray) {
        int n = this.uriMatcher.match(uri);
        switch (n) {
            case 1002: {
                this.rememberRemovedBookmark(ContentUris.parseId((Uri)uri));
                this.notifyBookmarkChange();
                return 1;
            }
        }
        throw new UnsupportedOperationException("Unknown URI " + uri.toString());
    }

    private void notifyBookmarkChange() {
        Context context = this.assertAndGetContext();
        context.getContentResolver().notifyChange(new Uri.Builder().scheme("content").authority(PartnerBookmarksProviderProxy.getAuthority(context)).appendPath("bookmarks").build(), null);
    }

    private synchronized void rememberRemovedBookmark(long l) {
        Set<String> set = this.getRemovedBookmarkIds();
        set.add(String.valueOf(l));
        GeckoSharedPrefs.forProfile(this.assertAndGetContext()).edit().putStringSet(PREF_DELETED_PARTNER_BOOKMARKS, set).apply();
    }

    private synchronized Set<String> getRemovedBookmarkIds() {
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forProfile(this.assertAndGetContext());
        return sharedPreferences.getStringSet(PREF_DELETED_PARTNER_BOOKMARKS, new HashSet());
    }

    private Cursor getBookmarksInFolder(ContentResolver contentResolver, long l) {
        long l2 = l == 0L ? 0L : -1000L - l;
        String string2 = TextUtils.join((CharSequence)",", this.getRemovedBookmarkIds());
        return contentResolver.query(PartnerContract.CONTENT_URI, new String[]{"(-1000 - _id) as _id", "(-1000 - _id) as bookmark_id", "title as title", "url as url", "(-1000 - parent) as parent", "(2 - type) as type", "_id as guid"}, "parent = ? AND type IN (?,?) AND title <> '' AND bookmark_id NOT IN (" + string2 + ")", new String[]{String.valueOf(l2), String.valueOf(1), String.valueOf(2)}, "type ASC, _id ASC");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFolderEmpty(long l) {
        Context context = this.assertAndGetContext();
        Cursor cursor = this.getBookmarksInFolder(context.getContentResolver(), l);
        if (cursor == null) {
            return true;
        }
        try {
            boolean bl = cursor.getCount() == 0;
            return bl;
        }
        finally {
            cursor.close();
        }
    }

    private Cursor getIcon(ContentResolver contentResolver, long l) {
        long l2 = -1000L - l;
        return contentResolver.query(PartnerContract.CONTENT_URI, new String[]{"touchicon", "favicon"}, "_id = ?", new String[]{String.valueOf(l2)}, null);
    }

    private Context assertAndGetContext() {
        Context context = super.getContext();
        if (context == null) {
            throw new AssertionError((Object)"Context is null");
        }
        return context;
    }

    public String getType(@NonNull Uri uri) {
        throw new UnsupportedOperationException();
    }

    public Uri insert(@NonNull Uri uri, ContentValues contentValues) {
        throw new UnsupportedOperationException();
    }

    public int update(@NonNull Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        throw new UnsupportedOperationException();
    }

    private static class FilteredCursor
    extends CursorWrapper {
        private HashSet<Integer> emptyFolderPositions = new HashSet();
        private int count;

        public FilteredCursor(PartnerBookmarksProviderProxy partnerBookmarksProviderProxy, Cursor cursor) {
            super(cursor);
            this.count = cursor.getCount();
            for (int i = 0; i < cursor.getCount(); ++i) {
                cursor.moveToPosition(i);
                long l = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
                int n = cursor.getInt(cursor.getColumnIndexOrThrow("type"));
                if (n != 0 || !partnerBookmarksProviderProxy.isFolderEmpty(l)) continue;
                --this.count;
                this.emptyFolderPositions.add(i);
            }
        }

        public int getCount() {
            return this.count;
        }

        public boolean moveToPosition(int n) {
            Cursor cursor = this.getWrappedCursor();
            int n2 = cursor.getCount();
            while (n < n2 && this.emptyFolderPositions.contains(n)) {
                ++n;
            }
            return n < n2 && cursor.moveToPosition(n);
        }
    }

    public static class PartnerContract {
        public static final Uri CONTENT_URI = Uri.parse((String)"content://com.android.partnerbookmarks/bookmarks");
        public static final int TYPE_BOOKMARK = 1;
        public static final int TYPE_FOLDER = 2;
        public static final int PARENT_ROOT_ID = 0;
        public static final String ID = "_id";
        public static final String TYPE = "type";
        public static final String URL = "url";
        public static final String TITLE = "title";
        public static final String FAVICON = "favicon";
        public static final String TOUCHICON = "touchicon";
        public static final String PARENT = "parent";
    }
}

