/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.distribution;

import android.net.Uri;
import org.mozilla.gecko.annotation.RobocopTarget;

@RobocopTarget
public class ReferrerDescriptor {
    public final String source;
    public final String medium;
    public final String term;
    public final String content;
    public final String campaign;

    public ReferrerDescriptor(String string2) {
        if (string2 == null) {
            this.source = null;
            this.medium = null;
            this.term = null;
            this.content = null;
            this.campaign = null;
            return;
        }
        Uri uri = new Uri.Builder().scheme("http").authority("local").path("/").encodedQuery(string2).build();
        this.source = uri.getQueryParameter("utm_source");
        this.medium = uri.getQueryParameter("utm_medium");
        this.term = uri.getQueryParameter("utm_term");
        this.content = uri.getQueryParameter("utm_content");
        this.campaign = uri.getQueryParameter("utm_campaign");
    }

    public String toString() {
        return "{s: " + this.source + ", m: " + this.medium + ", t: " + this.term + ", c: " + this.content + ", c: " + this.campaign + "}";
    }
}

