/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.dlc.catalog;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import org.mozilla.gecko.dlc.catalog.DownloadContentBuilder;

public class DownloadContent {
    public static final int STATE_NONE = 0;
    public static final int STATE_SCHEDULED = 1;
    public static final int STATE_DOWNLOADED = 2;
    public static final int STATE_FAILED = 3;
    public static final int STATE_UPDATED = 4;
    public static final int STATE_DELETED = 5;
    public static final String TYPE_ASSET_ARCHIVE = "asset-archive";
    public static final String KIND_FONT = "font";
    public static final String KIND_HYPHENATION_DICTIONARY = "hyphenation";
    private final String id;
    private final String location;
    private final String filename;
    private final String checksum;
    private final String downloadChecksum;
    private final long lastModified;
    private final String type;
    private final String kind;
    private final long size;
    private final String appVersionPattern;
    private final String androidApiPattern;
    private final String appIdPattern;
    private int state;
    private int failures;
    private int lastFailureType;

    DownloadContent(@NonNull String string2, @NonNull String string3, @NonNull String string4, @NonNull String string5, @NonNull String string6, @NonNull long l, @NonNull String string7, @NonNull String string8, long l2, int n, int n2, @Nullable String string9, @Nullable String string10, @Nullable String string11) {
        this.id = string2;
        this.location = string3;
        this.filename = string4;
        this.checksum = string5;
        this.downloadChecksum = string6;
        this.lastModified = l;
        this.type = string7;
        this.kind = string8;
        this.size = l2;
        this.state = 0;
        this.failures = n;
        this.lastFailureType = n2;
        this.appVersionPattern = string9;
        this.androidApiPattern = string10;
        this.appIdPattern = string11;
    }

    public String getId() {
        return this.id;
    }

    void setState(@State int n) {
        this.state = n;
    }

    @State
    public int getState() {
        return this.state;
    }

    public boolean isStateIn(int ... nArray) {
        for (int n : nArray) {
            if (this.state != n) continue;
            return true;
        }
        return false;
    }

    @Kind
    public String getKind() {
        return this.kind;
    }

    @Type
    public String getType() {
        return this.type;
    }

    public String getLocation() {
        return this.location;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public String getDownloadChecksum() {
        return this.downloadChecksum;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isFont() {
        return KIND_FONT.equals(this.kind);
    }

    public boolean isHyphenationDictionary() {
        return KIND_HYPHENATION_DICTIONARY.equals(this.kind);
    }

    public boolean isKnownContent() {
        return (this.isFont() || this.isHyphenationDictionary()) && this.isAssetArchive();
    }

    public boolean isAssetArchive() {
        return TYPE_ASSET_ARCHIVE.equals(this.type);
    }

    int getFailures() {
        return this.failures;
    }

    int getLastFailureType() {
        return this.lastFailureType;
    }

    void rememberFailure(int n) {
        if (this.lastFailureType != n) {
            this.lastFailureType = n;
            this.failures = 1;
        } else {
            ++this.failures;
        }
    }

    void resetFailures() {
        this.failures = 0;
        this.lastFailureType = 0;
    }

    public String getAppVersionPattern() {
        return this.appVersionPattern;
    }

    public String getAndroidApiPattern() {
        return this.androidApiPattern;
    }

    public String getAppIdPattern() {
        return this.appIdPattern;
    }

    public DownloadContentBuilder buildUpon() {
        return DownloadContentBuilder.buildUpon(this);
    }

    public String toString() {
        return String.format("[%s,%s] %s (%d bytes) %s", this.getType(), this.getKind(), this.getId(), this.getSize(), this.getChecksum());
    }

    public static @interface Kind {
    }

    public static @interface Type {
    }

    public static @interface State {
    }
}

