/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.feeds;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.Nullable;
import android.support.v4.net.ConnectivityManagerCompat;
import android.util.Log;
import com.keepsafe.switchboard.SwitchBoard;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.feeds.FeedAlarmReceiver;
import org.mozilla.gecko.feeds.action.CheckForUpdatesAction;
import org.mozilla.gecko.feeds.action.EnrollSubscriptionsAction;
import org.mozilla.gecko.feeds.action.FeedAction;
import org.mozilla.gecko.feeds.action.SetupAlarmsAction;
import org.mozilla.gecko.feeds.action.SubscribeToFeedAction;
import org.mozilla.gecko.feeds.action.WithdrawSubscriptionsAction;

public class FeedService
extends IntentService {
    private static final String LOGTAG = "GeckoFeedService";
    public static final String ACTION_SETUP = "org.mozilla.fennec.FEEDS.SETUP";
    public static final String ACTION_SUBSCRIBE = "org.mozilla.fennec.FEEDS.SUBSCRIBE";
    public static final String ACTION_CHECK = "org.mozilla.fennec.FEEDS.CHECK";
    public static final String ACTION_ENROLL = "org.mozilla.fennec.FEEDS.ENROLL";
    public static final String ACTION_WITHDRAW = "org.mozilla.fennec.FEEDS.WITHDRAW";
    private BrowserDB browserDB;

    public static void setup(Context context) {
        Intent intent = new Intent(context, FeedService.class);
        intent.setAction(ACTION_SETUP);
        context.startService(intent);
    }

    public static void subscribe(Context context, String string2) {
        Intent intent = new Intent(context, FeedService.class);
        intent.setAction(ACTION_SUBSCRIBE);
        intent.putExtra("feed_url", string2);
        context.startService(intent);
    }

    public FeedService() {
        super(LOGTAG);
    }

    public void onCreate() {
        super.onCreate();
        this.browserDB = GeckoProfile.get((Context)this).getDB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onHandleIntent(Intent intent) {
        try {
            if (intent == null) {
                return;
            }
            Log.d((String)LOGTAG, (String)("Service started with action: " + intent.getAction()));
            if (!FeedService.isInExperiment((Context)this)) {
                Log.d((String)LOGTAG, (String)"Not in content notifications experiment. Skipping.");
                return;
            }
            FeedAction feedAction = this.createActionForIntent(intent);
            if (feedAction == null) {
                Log.d((String)LOGTAG, (String)"No action to process");
                return;
            }
            if (feedAction.requiresPreferenceEnabled() && !this.isPreferenceEnabled()) {
                Log.d((String)LOGTAG, (String)"Preference is disabled. Skipping.");
                return;
            }
            if (feedAction.requiresNetwork() && !this.isConnectedToUnmeteredNetwork()) {
                Log.d((String)LOGTAG, (String)"Not connected to a network or network is metered. Skipping.");
                return;
            }
            feedAction.perform(this.browserDB, intent);
        }
        finally {
            FeedAlarmReceiver.completeWakefulIntent((Intent)intent);
        }
        Log.d((String)LOGTAG, (String)"Done.");
    }

    @Nullable
    private FeedAction createActionForIntent(Intent intent) {
        Context context = this.getApplicationContext();
        switch (intent.getAction()) {
            case "org.mozilla.fennec.FEEDS.SETUP": {
                return new SetupAlarmsAction(context);
            }
            case "org.mozilla.fennec.FEEDS.SUBSCRIBE": {
                return new SubscribeToFeedAction(context);
            }
            case "org.mozilla.fennec.FEEDS.CHECK": {
                return new CheckForUpdatesAction(context);
            }
            case "org.mozilla.fennec.FEEDS.ENROLL": {
                return new EnrollSubscriptionsAction(context);
            }
            case "org.mozilla.fennec.FEEDS.WITHDRAW": {
                return new WithdrawSubscriptionsAction(context);
            }
        }
        throw new AssertionError((Object)("Unknown action: " + intent.getAction()));
    }

    private boolean isConnectedToUnmeteredNetwork() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            return false;
        }
        return !ConnectivityManagerCompat.isActiveNetworkMetered((ConnectivityManager)connectivityManager);
    }

    public static boolean isInExperiment(Context context) {
        return SwitchBoard.isInExperiment((Context)context, (String)"content-notifications-12hrs") || SwitchBoard.isInExperiment((Context)context, (String)"content-notifications-5pm") || SwitchBoard.isInExperiment((Context)context, (String)"content-notifications-8am");
    }

    public static String getEnabledExperiment(Context context) {
        String string2 = null;
        if (SwitchBoard.isInExperiment((Context)context, (String)"content-notifications-12hrs")) {
            string2 = "content-notifications-12hrs";
        } else if (SwitchBoard.isInExperiment((Context)context, (String)"content-notifications-8am")) {
            string2 = "content-notifications-8am";
        } else if (SwitchBoard.isInExperiment((Context)context, (String)"content-notifications-5pm")) {
            string2 = "content-notifications-5pm";
        }
        return string2;
    }

    private boolean isPreferenceEnabled() {
        return GeckoSharedPrefs.forApp((Context)this).getBoolean("android.not_a_preference.notifications.content", true);
    }
}

