/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.feeds.action;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.db.UrlAnnotations;
import org.mozilla.gecko.feeds.FeedFetcher;
import org.mozilla.gecko.feeds.FeedService;
import org.mozilla.gecko.feeds.action.FeedAction;
import org.mozilla.gecko.feeds.subscriptions.FeedSubscription;

public class SubscribeToFeedAction
extends FeedAction {
    private static final String LOGTAG = "FeedSubscribeAction";
    public static final String EXTRA_FEED_URL = "feed_url";
    private Context context;

    public SubscribeToFeedAction(Context context) {
        this.context = context;
    }

    @Override
    public void perform(BrowserDB browserDB, Intent intent) {
        UrlAnnotations urlAnnotations = browserDB.getUrlAnnotations();
        Bundle bundle = intent.getExtras();
        String string2 = bundle.getString(EXTRA_FEED_URL);
        if (urlAnnotations.hasFeedSubscription(this.context.getContentResolver(), string2)) {
            this.log("Already subscribed to " + string2 + ". Skipping.");
            return;
        }
        this.log("Subscribing to feed: " + string2);
        this.subscribe(urlAnnotations, string2);
    }

    @Override
    public boolean requiresNetwork() {
        return true;
    }

    @Override
    public boolean requiresPreferenceEnabled() {
        return true;
    }

    private void subscribe(UrlAnnotations urlAnnotations, String string2) {
        FeedFetcher.FeedResponse feedResponse = FeedFetcher.fetchAndParseFeed(string2);
        if (feedResponse == null) {
            this.log(String.format("Could not fetch feed (%s). Not subscribing for now.", string2));
            return;
        }
        this.log("Subscribing to feed: " + feedResponse.feed.getTitle());
        this.log("          Last item: " + feedResponse.feed.getLastItem().getTitle());
        FeedSubscription feedSubscription = FeedSubscription.create(string2, feedResponse);
        urlAnnotations.insertFeedSubscription(this.context.getContentResolver(), feedSubscription);
        Telemetry.startUISession(TelemetryContract.Session.EXPERIMENT, FeedService.getEnabledExperiment(this.context));
        Telemetry.sendUIEvent(TelemetryContract.Event.SAVE, TelemetryContract.Method.SERVICE, "content_update");
        Telemetry.stopUISession(TelemetryContract.Session.EXPERIMENT, FeedService.getEnabledExperiment(this.context));
    }
}

