/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.feeds.action;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import org.json.JSONException;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.db.UrlAnnotations;
import org.mozilla.gecko.feeds.FeedService;
import org.mozilla.gecko.feeds.action.FeedAction;
import org.mozilla.gecko.feeds.subscriptions.FeedSubscription;

public class WithdrawSubscriptionsAction
extends FeedAction {
    private static final String LOGTAG = "FeedWithdrawAction";
    private Context context;

    public WithdrawSubscriptionsAction(Context context) {
        this.context = context;
    }

    @Override
    public void perform(BrowserDB browserDB, Intent intent) {
        this.log("Searching for subscriptions to remove..");
        UrlAnnotations urlAnnotations = browserDB.getUrlAnnotations();
        ContentResolver contentResolver = this.context.getContentResolver();
        this.removeFeedsOfUnknownUrls(browserDB, urlAnnotations, contentResolver);
        this.removeSubscriptionsOfRemovedFeeds(urlAnnotations, contentResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFeedsOfUnknownUrls(BrowserDB browserDB, UrlAnnotations urlAnnotations, ContentResolver contentResolver) {
        Cursor cursor = urlAnnotations.getWebsitesWithFeedUrl(contentResolver);
        if (cursor == null) {
            return;
        }
        try {
            while (cursor.moveToNext()) {
                String string2 = cursor.getString(cursor.getColumnIndex("url"));
                if (browserDB.isBookmark(contentResolver, string2)) continue;
                this.log("Removing feed for unknown URL: " + string2);
                urlAnnotations.deleteFeedUrl(contentResolver, string2);
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSubscriptionsOfRemovedFeeds(UrlAnnotations urlAnnotations, ContentResolver contentResolver) {
        Cursor cursor = urlAnnotations.getFeedSubscriptions(contentResolver);
        if (cursor == null) {
            return;
        }
        try {
            while (cursor.moveToNext()) {
                FeedSubscription feedSubscription = FeedSubscription.fromCursor(cursor);
                if (urlAnnotations.hasWebsiteForFeedUrl(contentResolver, feedSubscription.getFeedUrl())) continue;
                this.log("Removing subscription for feed: " + feedSubscription.getFeedUrl());
                urlAnnotations.deleteFeedSubscription(contentResolver, feedSubscription);
                Telemetry.startUISession(TelemetryContract.Session.EXPERIMENT, FeedService.getEnabledExperiment(this.context));
                Telemetry.sendUIEvent(TelemetryContract.Event.UNSAVE, TelemetryContract.Method.SERVICE, "content_update");
                Telemetry.stopUISession(TelemetryContract.Session.EXPERIMENT, FeedService.getEnabledExperiment(this.context));
            }
        }
        catch (JSONException jSONException) {
            this.log("Could not deserialize subscription", jSONException);
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public boolean requiresNetwork() {
        return false;
    }

    @Override
    public boolean requiresPreferenceEnabled() {
        return true;
    }
}

