/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.firstrun;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.firstrun.FirstrunPanel;

public class DataPanel
extends FirstrunPanel {
    private boolean isEnabled = false;

    @Override
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = super.onCreateView(layoutInflater, viewGroup, bundle);
        ImageView imageView = (ImageView)view.findViewById(R.id.firstrun_image);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DataPanel.this.isEnabled = !DataPanel.this.isEnabled;
                int n = DataPanel.this.isEnabled ? R.drawable.firstrun_data_on : R.drawable.firstrun_data_off;
                ((ImageView)view).setImageResource(n);
                if (DataPanel.this.isEnabled) {
                    PrefsHelper.setPref("browser.image_blocking", 0);
                } else {
                    PrefsHelper.setPref("browser.image_blocking", 1);
                }
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.BUTTON, "firstrun-datasaving-" + DataPanel.this.isEnabled);
            }
        });
        return view;
    }
}

