/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.firstrun;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.SwitchCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.firstrun.FirstrunPanel;
import org.mozilla.gecko.tabqueue.TabQueueHelper;
import org.mozilla.gecko.tabqueue.TabQueuePrompt;

public class TabQueuePanel
extends FirstrunPanel {
    private static final int REQUEST_CODE_TAB_QUEUE = 1;
    private SwitchCompat toggleSwitch;
    private ImageView imageView;
    private TextView messageTextView;
    private TextView subtextTextView;
    private Context context;

    @Override
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.context = this.getContext();
        View view = super.onCreateView(layoutInflater, viewGroup, bundle);
        this.imageView = (ImageView)view.findViewById(R.id.firstrun_image);
        this.messageTextView = (TextView)view.findViewById(R.id.firstrun_text);
        this.subtextTextView = (TextView)view.findViewById(R.id.firstrun_subtext);
        this.toggleSwitch = (SwitchCompat)view.findViewById(R.id.firstrun_switch);
        this.toggleSwitch.setVisibility(0);
        this.toggleSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.DIALOG, "firstrun_tabqueue-permissions");
                if (bl && !TabQueueHelper.canDrawOverlays(TabQueuePanel.this.context)) {
                    Intent intent = new Intent(TabQueuePanel.this.context, TabQueuePrompt.class);
                    TabQueuePanel.this.startActivityForResult(intent, 1);
                    return;
                }
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.BUTTON, "firstrun-tabqueue-" + bl);
                SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp(TabQueuePanel.this.context);
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.putBoolean("android.not_a_preference.tab_queue", bl).apply();
                TabQueuePanel.this.imageView.setImageResource(bl ? R.drawable.firstrun_tabqueue_on : R.drawable.firstrun_tabqueue_off);
                TabQueuePanel.this.messageTextView.setText(bl ? R.string.firstrun_tabqueue_message_on : R.string.firstrun_tabqueue_message_off);
                TabQueuePanel.this.messageTextView.setTypeface(bl ? Typeface.DEFAULT_BOLD : Typeface.DEFAULT);
                TabQueuePanel.this.subtextTextView.setText(bl ? R.string.firstrun_tabqueue_subtext_on : R.string.firstrun_tabqueue_subtext_off);
                TabQueuePanel.this.subtextTextView.setTypeface(bl ? Typeface.defaultFromStyle((int)2) : Typeface.DEFAULT);
                TabQueuePanel.this.subtextTextView.setTextColor(bl ? ContextCompat.getColor((Context)TabQueuePanel.this.context, (int)R.color.fennec_ui_orange) : ContextCompat.getColor((Context)TabQueuePanel.this.context, (int)R.color.placeholder_grey));
            }
        });
        return view;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        switch (n) {
            case 1: {
                boolean bl = TabQueueHelper.processTabQueuePromptResponse(n2, this.context);
                if (bl) {
                    Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.DIALOG, "firstrun_tabqueue-permissions-yes");
                    this.toggleSwitch.setChecked(true);
                    Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.BUTTON, "firstrun-tabqueue-true");
                }
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.DIALOG, "firstrun_tabqueue-permissions-" + (bl ? "accepted" : "rejected"));
            }
        }
    }
}

