/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import org.mozilla.gecko.annotation.WrapForJNI;
import org.mozilla.gecko.gfx.GeckoLayerClient;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.gfx.NativePanZoomController;
import org.mozilla.gecko.mozglue.JNIObject;
import org.mozilla.gecko.util.ThreadUtils;

public class GLController
extends JNIObject {
    private static final String LOGTAG = "GeckoGLController";
    LayerView mView;
    private boolean mServerSurfaceValid;
    private int mWidth;
    private int mHeight;
    private volatile boolean mCompositorCreated;

    @WrapForJNI
    protected native void disposeNative();

    @WrapForJNI
    native void attachToJava(GeckoLayerClient var1, NativePanZoomController var2);

    @WrapForJNI
    native void onSizeChanged(int var1, int var2, int var3, int var4);

    @WrapForJNI
    private native void createCompositor(int var1, int var2);

    @WrapForJNI
    private native void pauseCompositor();

    @WrapForJNI
    private native void syncResumeResizeCompositor(int var1, int var2);

    @WrapForJNI
    private native void syncInvalidateAndScheduleComposite();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serverSurfaceDestroyed() {
        ThreadUtils.assertOnUiThread();
        if (this.mCompositorCreated) {
            this.pauseCompositor();
        }
        GLController gLController = this;
        synchronized (gLController) {
            this.mServerSurfaceValid = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serverSurfaceChanged(int n, int n2) {
        ThreadUtils.assertOnUiThread();
        GLController gLController = this;
        synchronized (gLController) {
            this.mWidth = n;
            this.mHeight = n2;
            this.mServerSurfaceValid = true;
        }
        this.updateCompositor();
    }

    void updateCompositor() {
        ThreadUtils.assertOnUiThread();
        if (this.mView == null) {
            return;
        }
        if (this.mCompositorCreated) {
            this.resumeCompositor(this.mWidth, this.mHeight);
            return;
        }
        if (this.isServerSurfaceValid() && this.mView.getLayerClient().isGeckoReady()) {
            this.createCompositor(this.mWidth, this.mHeight);
            this.compositorCreated();
        }
    }

    void compositorCreated() {
        this.mCompositorCreated = true;
    }

    public boolean isServerSurfaceValid() {
        return this.mServerSurfaceValid;
    }

    @WrapForJNI(allowMultithread=true)
    private synchronized Object getSurface() {
        if (this.mView != null && this.isServerSurfaceValid()) {
            return this.mView.getSurface();
        }
        return null;
    }

    void resumeCompositor(int n, int n2) {
        if (this.isServerSurfaceValid() && this.mCompositorCreated) {
            this.syncResumeResizeCompositor(n, n2);
            this.mView.requestRender();
        }
    }

    void invalidateAndScheduleComposite() {
        if (this.mCompositorCreated) {
            this.syncInvalidateAndScheduleComposite();
        }
    }

    @WrapForJNI
    private void destroy() {
        this.mCompositorCreated = false;
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GLController.this.disposeNative();
            }
        });
    }

    public static class GLControllerException
    extends RuntimeException {
        public static final long serialVersionUID = 1L;

        GLControllerException(String string2) {
            super(string2);
        }
    }
}

