/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.ZoomConstraints;
import org.mozilla.gecko.annotation.WrapForJNI;
import org.mozilla.gecko.gfx.DisplayPortCalculator;
import org.mozilla.gecko.gfx.DisplayPortMetrics;
import org.mozilla.gecko.gfx.DrawTimingQueue;
import org.mozilla.gecko.gfx.DynamicToolbarAnimator;
import org.mozilla.gecko.gfx.FloatSize;
import org.mozilla.gecko.gfx.FullScreenState;
import org.mozilla.gecko.gfx.GLController;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;
import org.mozilla.gecko.gfx.IntSize;
import org.mozilla.gecko.gfx.Layer;
import org.mozilla.gecko.gfx.LayerRenderer;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.gfx.Overscroll;
import org.mozilla.gecko.gfx.PanZoomController;
import org.mozilla.gecko.gfx.PanZoomTarget;
import org.mozilla.gecko.gfx.ProgressiveUpdateData;
import org.mozilla.gecko.gfx.RectUtils;
import org.mozilla.gecko.gfx.RenderTask;
import org.mozilla.gecko.gfx.ViewTransform;
import org.mozilla.gecko.gfx.VirtualLayer;
import org.mozilla.gecko.util.FloatUtils;

class GeckoLayerClient
implements LayerView.Listener,
PanZoomTarget {
    private static final String LOGTAG = "GeckoLayerClient";
    private static int sPaintSyncId = 1;
    private LayerRenderer mLayerRenderer;
    private boolean mLayerRendererInitialized;
    private final Context mContext;
    private IntSize mScreenSize;
    private IntSize mWindowSize;
    private DisplayPortMetrics mDisplayPort;
    private boolean mRecordDrawTimes;
    private final DrawTimingQueue mDrawTimingQueue;
    private VirtualLayer mRootLayer;
    private ImmutableViewportMetrics mGeckoViewport;
    private ImmutableViewportMetrics mFrameMetrics;
    private final List<LayerView.DrawListener> mDrawListeners;
    private final ViewTransform mCurrentViewTransform;
    private final ProgressiveUpdateData mProgressiveUpdateData;
    private DisplayPortMetrics mProgressiveUpdateDisplayPort;
    private boolean mLastProgressiveUpdateWasLowPrecision;
    private boolean mProgressiveUpdateWasInDanger;
    private boolean mForceRedraw;
    private volatile ImmutableViewportMetrics mViewportMetrics;
    private ZoomConstraints mZoomConstraints;
    private volatile boolean mGeckoIsReady;
    private final PanZoomController mPanZoomController;
    private final DynamicToolbarAnimator mToolbarAnimator;
    private final LayerView mView;
    private volatile boolean mContentDocumentIsDisplayed;
    private SynthesizedEventState mPointerState;

    public GeckoLayerClient(Context context, LayerView layerView, EventDispatcher eventDispatcher) {
        this.mContext = context;
        this.mScreenSize = new IntSize(0, 0);
        this.mWindowSize = new IntSize(0, 0);
        this.mDisplayPort = new DisplayPortMetrics();
        this.mRecordDrawTimes = true;
        this.mDrawTimingQueue = new DrawTimingQueue();
        this.mCurrentViewTransform = new ViewTransform(0.0f, 0.0f, 1.0f);
        this.mProgressiveUpdateData = new ProgressiveUpdateData();
        this.mProgressiveUpdateDisplayPort = new DisplayPortMetrics();
        this.mForceRedraw = true;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mViewportMetrics = new ImmutableViewportMetrics(displayMetrics).setViewportSize(layerView.getWidth(), layerView.getHeight());
        this.mZoomConstraints = new ZoomConstraints(false);
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null) {
            this.mZoomConstraints = tab.getZoomConstraints();
            this.mViewportMetrics = this.mViewportMetrics.setIsRTL(tab.getIsRTL());
        }
        this.mFrameMetrics = this.mViewportMetrics;
        this.mDrawListeners = new ArrayList<LayerView.DrawListener>();
        this.mToolbarAnimator = new DynamicToolbarAnimator(this);
        this.mPanZoomController = PanZoomController.Factory.create(this, (View)layerView, eventDispatcher);
        this.mView = layerView;
        this.mView.setListener(this);
        this.mContentDocumentIsDisplayed = true;
    }

    public void setOverscrollHandler(Overscroll overscroll) {
        this.mPanZoomController.setOverscrollHandler(overscroll);
    }

    boolean isGeckoReady() {
        return this.mGeckoIsReady;
    }

    @WrapForJNI
    private void onGeckoReady() {
        this.mGeckoIsReady = true;
        this.mRootLayer = new VirtualLayer(new IntSize(this.mView.getWidth(), this.mView.getHeight()));
        this.mLayerRenderer = this.mView.getRenderer();
        this.sendResizeEventIfNecessary(true, null);
        DisplayPortCalculator.initPrefs();
        this.mView.post(new Runnable(){

            @Override
            public void run() {
                GeckoLayerClient.this.mView.getGLController().updateCompositor();
            }
        });
    }

    public void destroy() {
        this.mPanZoomController.destroy();
        this.mToolbarAnimator.destroy();
        this.mDrawListeners.clear();
    }

    private boolean getRedrawHint() {
        if (this.mForceRedraw) {
            this.mForceRedraw = false;
            return true;
        }
        if (!this.mPanZoomController.getRedrawHint()) {
            return false;
        }
        return DisplayPortCalculator.aboutToCheckerboard(this.mViewportMetrics, this.mPanZoomController.getVelocityVector(), this.mDisplayPort);
    }

    Layer getRoot() {
        return this.mGeckoIsReady ? this.mRootLayer : null;
    }

    public LayerView getView() {
        return this.mView;
    }

    public FloatSize getViewportSize() {
        return this.mViewportMetrics.getSize();
    }

    boolean setViewportSize(int n, int n2, PointF pointF) {
        if (this.mViewportMetrics.viewportRectWidth == n && this.mViewportMetrics.viewportRectHeight == n2 && (pointF == null || pointF.x == 0.0f && pointF.y == 0.0f)) {
            return false;
        }
        this.mViewportMetrics = this.mViewportMetrics.setViewportSize(n, n2);
        if (pointF != null) {
            this.mViewportMetrics = this.mPanZoomController.adjustScrollForSurfaceShift(this.mViewportMetrics, pointF);
        }
        if (this.mGeckoIsReady) {
            this.sendResizeEventIfNecessary(true, pointF);
            GeckoAppShell.viewSizeChanged();
        }
        return true;
    }

    PanZoomController getPanZoomController() {
        return this.mPanZoomController;
    }

    DynamicToolbarAnimator getDynamicToolbarAnimator() {
        return this.mToolbarAnimator;
    }

    private void sendResizeEventIfNecessary(boolean bl, PointF pointF) {
        boolean bl2;
        DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
        IntSize intSize = new IntSize(displayMetrics.widthPixels, displayMetrics.heightPixels);
        IntSize intSize2 = new IntSize(this.mViewportMetrics.viewportRectWidth, this.mViewportMetrics.viewportRectHeight);
        boolean bl3 = !this.mScreenSize.equals(intSize);
        boolean bl4 = bl2 = !this.mWindowSize.equals(intSize2);
        if (!(bl || bl3 || bl2)) {
            return;
        }
        this.mScreenSize = intSize;
        this.mWindowSize = intSize2;
        if (bl3) {
            Log.d((String)LOGTAG, (String)("Screen-size changed to " + this.mScreenSize));
        }
        if (bl2) {
            Log.d((String)LOGTAG, (String)("Window-size changed to " + this.mWindowSize));
        }
        if (this.mView != null) {
            this.mView.getGLController().onSizeChanged(this.mWindowSize.width, this.mWindowSize.height, this.mScreenSize.width, this.mScreenSize.height);
        }
        String string2 = "";
        try {
            if (pointF != null) {
                int n;
                ++sPaintSyncId;
                if ((n = sPaintSyncId++) == 0) {
                    n = sPaintSyncId;
                }
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("x", (double)(pointF.x / this.mViewportMetrics.zoomFactor));
                jSONObject.put("y", (double)(pointF.y / this.mViewportMetrics.zoomFactor));
                jSONObject.put("id", n);
                string2 = jSONObject.toString();
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Unable to convert point to JSON", (Throwable)exception);
        }
        GeckoAppShell.notifyObservers("Window:Resize", string2);
    }

    private void setPageRect(RectF rectF, RectF rectF2) {
        if (this.mViewportMetrics.getCssPageRect().equals((Object)rectF2)) {
            return;
        }
        this.mViewportMetrics = this.mViewportMetrics.setPageRect(rectF, rectF2);
        this.post(new Runnable(){

            @Override
            public void run() {
                GeckoLayerClient.this.mPanZoomController.pageRectUpdated();
                GeckoLayerClient.this.mView.requestRender();
            }
        });
    }

    private void adjustViewport(DisplayPortMetrics displayPortMetrics) {
    }

    private void abortPanZoomAnimation() {
        if (this.mPanZoomController != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    GeckoLayerClient.this.mPanZoomController.abortAnimation();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DisplayPortMetrics handleViewportMessage(ImmutableViewportMetrics immutableViewportMetrics, ViewportMessageType viewportMessageType) {
        Object object = this.getLock();
        synchronized (object) {
            ImmutableViewportMetrics immutableViewportMetrics2;
            ImmutableViewportMetrics immutableViewportMetrics3 = this.getViewportMetrics();
            switch (viewportMessageType) {
                default: {
                    immutableViewportMetrics2 = immutableViewportMetrics.setViewportSize(immutableViewportMetrics3.viewportRectWidth, immutableViewportMetrics3.viewportRectHeight);
                    if (this.mToolbarAnimator.isResizing()) {
                        immutableViewportMetrics2 = immutableViewportMetrics2.setViewportOrigin(immutableViewportMetrics3.viewportRectLeft, immutableViewportMetrics3.viewportRectTop);
                        break;
                    }
                    if (immutableViewportMetrics3.fuzzyEquals(immutableViewportMetrics2)) break;
                    this.abortPanZoomAnimation();
                    break;
                }
                case PAGE_SIZE: {
                    float f = immutableViewportMetrics3.zoomFactor / immutableViewportMetrics.zoomFactor;
                    immutableViewportMetrics2 = immutableViewportMetrics3.setPageRect(RectUtils.scale(immutableViewportMetrics.getPageRect(), f), immutableViewportMetrics.getCssPageRect());
                }
            }
            final ImmutableViewportMetrics immutableViewportMetrics4 = immutableViewportMetrics2.clamp();
            this.post(new Runnable(){

                @Override
                public void run() {
                    GeckoLayerClient.this.mGeckoViewport = immutableViewportMetrics4;
                }
            });
            this.setViewportMetrics(immutableViewportMetrics2, viewportMessageType == ViewportMessageType.UPDATE);
            this.mDisplayPort = DisplayPortCalculator.calculate(this.getViewportMetrics(), null);
        }
        return this.mDisplayPort;
    }

    @WrapForJNI
    DisplayPortMetrics getDisplayPort(boolean bl, boolean bl2, int n, ImmutableViewportMetrics immutableViewportMetrics) {
        Tabs tabs = Tabs.getInstance();
        if (bl2 && tabs.isSelectedTabId(n)) {
            return this.handleViewportMessage(immutableViewportMetrics, bl ? ViewportMessageType.PAGE_SIZE : ViewportMessageType.UPDATE);
        }
        return DisplayPortCalculator.calculate(immutableViewportMetrics, null);
    }

    @WrapForJNI
    void contentDocumentChanged() {
        this.mContentDocumentIsDisplayed = false;
    }

    @WrapForJNI
    boolean isContentDocumentDisplayed() {
        return this.mContentDocumentIsDisplayed;
    }

    @WrapForJNI(allowMultithread=true)
    public ProgressiveUpdateData progressiveUpdateCallback(boolean bl, float f, float f2, float f3, float f4, float f5, boolean bl2) {
        if (bl2 && !this.mLastProgressiveUpdateWasLowPrecision) {
            if (!this.mProgressiveUpdateWasInDanger) {
                this.mProgressiveUpdateData.abort = true;
                return this.mProgressiveUpdateData;
            }
            this.mProgressiveUpdateWasInDanger = false;
        }
        this.mLastProgressiveUpdateWasLowPrecision = bl2;
        DisplayPortMetrics displayPortMetrics = this.mDisplayPort;
        ImmutableViewportMetrics immutableViewportMetrics = this.mViewportMetrics;
        this.mProgressiveUpdateData.setViewport(immutableViewportMetrics);
        this.mProgressiveUpdateData.abort = false;
        if (!FloatUtils.fuzzyEquals((float)f5, (float)immutableViewportMetrics.zoomFactor)) {
            Log.d((String)LOGTAG, (String)("Aborting draw due to resolution change: " + f5 + " != " + immutableViewportMetrics.zoomFactor));
            this.mProgressiveUpdateData.abort = true;
            return this.mProgressiveUpdateData;
        }
        if (!(bl2 || FloatUtils.fuzzyEquals((float)f5, (float)this.mProgressiveUpdateDisplayPort.resolution) && FloatUtils.fuzzyEquals((float)f, (float)this.mProgressiveUpdateDisplayPort.getLeft()) && FloatUtils.fuzzyEquals((float)f2, (float)this.mProgressiveUpdateDisplayPort.getTop()) && FloatUtils.fuzzyEquals((float)(f + f3), (float)this.mProgressiveUpdateDisplayPort.getRight()) && FloatUtils.fuzzyEquals((float)(f2 + f4), (float)this.mProgressiveUpdateDisplayPort.getBottom()))) {
            this.mProgressiveUpdateDisplayPort = new DisplayPortMetrics(f, f2, f + f3, f2 + f4, f5);
        }
        if (!bl2 && !this.mProgressiveUpdateWasInDanger && DisplayPortCalculator.aboutToCheckerboard(immutableViewportMetrics, this.mPanZoomController.getVelocityVector(), this.mProgressiveUpdateDisplayPort)) {
            this.mProgressiveUpdateWasInDanger = true;
        }
        if (Math.abs(displayPortMetrics.getLeft() - this.mProgressiveUpdateDisplayPort.getLeft()) <= 2.0f && Math.abs(displayPortMetrics.getTop() - this.mProgressiveUpdateDisplayPort.getTop()) <= 2.0f && Math.abs(displayPortMetrics.getBottom() - this.mProgressiveUpdateDisplayPort.getBottom()) <= 2.0f && Math.abs(displayPortMetrics.getRight() - this.mProgressiveUpdateDisplayPort.getRight()) <= 2.0f) {
            return this.mProgressiveUpdateData;
        }
        if (Math.max(immutableViewportMetrics.viewportRectLeft, immutableViewportMetrics.pageRectLeft) + 1.0f < f || Math.max(immutableViewportMetrics.viewportRectTop, immutableViewportMetrics.pageRectTop) + 1.0f < f2 || Math.min(immutableViewportMetrics.viewportRectRight(), immutableViewportMetrics.pageRectRight) - 1.0f > f + f3 || Math.min(immutableViewportMetrics.viewportRectBottom(), immutableViewportMetrics.pageRectBottom) - 1.0f > f2 + f4) {
            Log.d((String)LOGTAG, (String)"Aborting update due to viewport not in display-port");
            this.mProgressiveUpdateData.abort = true;
            this.mProgressiveUpdateWasInDanger = true;
            return this.mProgressiveUpdateData;
        }
        if (bl2 && !bl) {
            this.mProgressiveUpdateData.abort = true;
        }
        return this.mProgressiveUpdateData;
    }

    void setZoomConstraints(ZoomConstraints zoomConstraints) {
        this.mZoomConstraints = zoomConstraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIsRTL(boolean bl) {
        Object object = this.getLock();
        synchronized (object) {
            ImmutableViewportMetrics immutableViewportMetrics = this.getViewportMetrics().setIsRTL(bl);
            this.setViewportMetrics(immutableViewportMetrics, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapForJNI(allowMultithread=true)
    public void setFirstPaintViewport(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        Object object = this.getLock();
        synchronized (object) {
            ImmutableViewportMetrics immutableViewportMetrics = this.getViewportMetrics();
            Tab tab = Tabs.getInstance().getSelectedTab();
            RectF rectF = new RectF(f4, f5, f6, f7);
            RectF rectF2 = RectUtils.scaleAndRound(rectF, f3);
            final ImmutableViewportMetrics immutableViewportMetrics2 = immutableViewportMetrics.setViewportOrigin(f, f2).setZoomFactor(f3).setPageRect(rectF2, rectF).setIsRTL(tab != null ? tab.getIsRTL() : false);
            this.post(new Runnable(){

                @Override
                public void run() {
                    GeckoLayerClient.this.mGeckoViewport = immutableViewportMetrics2;
                }
            });
            this.setViewportMetrics(immutableViewportMetrics2);
            if (tab != null) {
                this.mView.setBackgroundColor(tab.getBackgroundColor());
                this.setZoomConstraints(tab.getZoomConstraints());
            }
            this.abortPanZoomAnimation();
            if (this.mView.getPaintState() == 0) {
                this.mView.setPaintState(1);
            }
        }
        DisplayPortCalculator.resetPageState();
        this.mDrawTimingQueue.reset();
        this.mContentDocumentIsDisplayed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapForJNI(allowMultithread=true)
    public void setPageRect(float f, float f2, float f3, float f4) {
        Object object = this.getLock();
        synchronized (object) {
            RectF rectF = new RectF(f, f2, f3, f4);
            float f5 = this.getViewportMetrics().zoomFactor;
            this.setPageRect(RectUtils.scale(rectF, f5), rectF);
        }
    }

    @WrapForJNI(allowMultithread=true)
    public ViewTransform syncViewportInfo(int n, int n2, int n3, int n4, float f, boolean bl, int n5) {
        Object object;
        long l;
        this.mFrameMetrics = this.getViewportMetrics();
        if (n5 == sPaintSyncId) {
            this.mToolbarAnimator.scrollChangeResizeCompleted();
        }
        this.mToolbarAnimator.populateViewTransform(this.mCurrentViewTransform, this.mFrameMetrics);
        if (this.mRootLayer != null) {
            this.mRootLayer.setPositionAndResolution(n, n2, n + n3, n2 + n4, f);
        }
        if (bl && this.mRecordDrawTimes && (l = this.mDrawTimingQueue.findTimeFor((DisplayPortMetrics)(object = new DisplayPortMetrics(n, n2, n + n3, n2 + n4, f)))) >= 0L) {
            long l2 = SystemClock.uptimeMillis();
            l = l2 - l;
            this.mRecordDrawTimes = DisplayPortCalculator.drawTimeUpdate(l, n3 * n4);
        }
        if (bl) {
            for (LayerView.DrawListener drawListener : this.mDrawListeners) {
                drawListener.drawFinished();
            }
        }
        return this.mCurrentViewTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapForJNI(allowMultithread=true)
    public ViewTransform syncFrameMetrics(float f, float f2, float f3, float f4, float f5, float f6, float f7, int n, int n2, int n3, int n4, float f8, boolean bl, int n5) {
        RectF rectF = new RectF(f4, f5, f6, f7);
        Object object = this.getLock();
        synchronized (object) {
            this.mViewportMetrics = this.mViewportMetrics.setViewportOrigin(f, f2).setZoomFactor(f3).setPageRect(RectUtils.scale(rectF, f3), rectF);
        }
        return this.syncViewportInfo(n, n2, n3, n4, f8, bl, n5);
    }

    private void synthesizeNativePointer(int n, int n2, int n3, int n4, int n5, double d, int n6) {
        Log.d((String)LOGTAG, (String)("Synthesizing pointer from " + n + " id " + n2 + " at " + n4 + ", " + n5));
        if (this.mPointerState == null) {
            this.mPointerState = new SynthesizedEventState();
        }
        int n7 = this.mPointerState.getPointerIndex(n2);
        switch (n3) {
            case 6: {
                if (n7 < 0) {
                    Log.d((String)LOGTAG, (String)"Requested synthesis of a pointer-up for a pointer that doesn't exist!");
                    return;
                }
                if (this.mPointerState.pointers.size() != 1) break;
                n3 = 1;
                break;
            }
            case 3: {
                if (n7 >= 0) break;
                Log.d((String)LOGTAG, (String)"Requested synthesis of a pointer-cancel for a pointer that doesn't exist!");
                return;
            }
            case 5: {
                if (n7 < 0) {
                    n7 = this.mPointerState.addPointer(n2, n);
                    if (n7 != 0) break;
                    n3 = 0;
                    this.mPointerState.downTime = SystemClock.uptimeMillis();
                    break;
                }
                n3 = 2;
                break;
            }
            case 7: {
                if (n7 < 0) {
                    n7 = this.mPointerState.addPointer(n2, n);
                    break;
                }
                n3 = 2;
            }
        }
        PointerInfo pointerInfo = this.mPointerState.pointers.get(n7);
        pointerInfo.screenX = n4;
        pointerInfo.screenY = n5;
        pointerInfo.pressure = d;
        pointerInfo.orientation = n6;
        int n8 = n7 << 8;
        n8 &= 0xFF00;
        boolean bl = n == 8194 && (n3 == 0 || n3 == 2);
        final MotionEvent motionEvent = MotionEvent.obtain((long)this.mPointerState.downTime, (long)SystemClock.uptimeMillis(), (int)(n8 |= n3 & 0xFF), (int)this.mPointerState.getPointerCount(n), (MotionEvent.PointerProperties[])this.mPointerState.getPointerProperties(n), (MotionEvent.PointerCoords[])this.mPointerState.getPointerCoords(n), (int)0, (int)(bl ? 1 : 0), (float)0.0f, (float)0.0f, (int)0, (int)0, (int)n, (int)0);
        this.mView.post(new Runnable(){

            @Override
            public void run() {
                motionEvent.offsetLocation(0.0f, GeckoLayerClient.this.mView.getSurfaceTranslation());
                GeckoLayerClient.this.mView.dispatchTouchEvent(motionEvent);
            }
        });
        if (n3 == 6 || n3 == 1 || n3 == 3 || n3 == 7) {
            this.mPointerState.pointers.remove(n7);
        }
    }

    @WrapForJNI
    public void synthesizeNativeTouchPoint(int n, int n2, int n3, int n4, double d, int n5) {
        if (n == 100000) {
            throw new IllegalArgumentException("Use a different pointer ID in your test, this one is reserved for mouse");
        }
        this.synthesizeNativePointer(4098, n, n2, n3, n4, d, n5);
    }

    @WrapForJNI
    public void synthesizeNativeMouseEvent(int n, int n2, int n3) {
        this.synthesizeNativePointer(8194, 100000, n, n2, n3, 0.0, 0);
    }

    @WrapForJNI(allowMultithread=true)
    public LayerRenderer.Frame createFrame() {
        if (!this.mLayerRendererInitialized) {
            if (this.mLayerRenderer == null) {
                return null;
            }
            this.mLayerRenderer.checkMonitoringEnabled();
            this.mLayerRenderer.createDefaultProgram();
            this.mLayerRendererInitialized = true;
        }
        try {
            return this.mLayerRenderer.createFrame(this.mFrameMetrics);
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (Throwable)exception);
            return null;
        }
    }

    @WrapForJNI(allowMultithread=true)
    public void activateProgram() {
        this.mLayerRenderer.activateDefaultProgram();
    }

    @WrapForJNI(allowMultithread=true)
    public void deactivateProgramAndRestoreState(boolean bl, int n, int n2, int n3, int n4) {
        this.mLayerRenderer.deactivateDefaultProgram();
        this.mLayerRenderer.restoreState(bl, n, n2, n3, n4);
    }

    private void geometryChanged(DisplayPortMetrics displayPortMetrics) {
        this.sendResizeEventIfNecessary(false, null);
        if (this.getRedrawHint()) {
            this.adjustViewport(displayPortMetrics);
        }
    }

    @Override
    public void renderRequested() {
        GLController gLController = this.mView.getGLController();
        if (gLController != null) {
            gLController.invalidateAndScheduleComposite();
        }
    }

    @Override
    public void sizeChanged(int n, int n2) {
        this.mView.getGLController().resumeCompositor(n, n2);
    }

    @Override
    public void surfaceChanged(int n, int n2) {
        IntSize intSize = this.mToolbarAnimator.getViewportSize();
        this.setViewportSize(intSize.width, intSize.height, null);
    }

    @Override
    public ImmutableViewportMetrics getViewportMetrics() {
        return this.mViewportMetrics;
    }

    @Override
    public ZoomConstraints getZoomConstraints() {
        return this.mZoomConstraints;
    }

    @Override
    public FullScreenState getFullScreenState() {
        return this.mView.getFullScreenState();
    }

    @Override
    public PointF getVisibleEndOfLayerView() {
        return this.mToolbarAnimator.getVisibleEndOfLayerView();
    }

    @Override
    public void setAnimationTarget(ImmutableViewportMetrics immutableViewportMetrics) {
        if (this.mGeckoIsReady) {
            DisplayPortMetrics displayPortMetrics = DisplayPortCalculator.calculate(immutableViewportMetrics, null);
            this.adjustViewport(displayPortMetrics);
        }
    }

    @Override
    public void setViewportMetrics(ImmutableViewportMetrics immutableViewportMetrics) {
        this.setViewportMetrics(immutableViewportMetrics, true);
    }

    private void setViewportMetrics(ImmutableViewportMetrics immutableViewportMetrics, boolean bl) {
        this.mViewportMetrics = immutableViewportMetrics = immutableViewportMetrics.setViewportSize(this.mViewportMetrics.viewportRectWidth, this.mViewportMetrics.viewportRectHeight);
        this.viewportMetricsChanged(bl);
    }

    private void viewportMetricsChanged(boolean bl) {
        this.mToolbarAnimator.onMetricsChanged(this.mViewportMetrics);
        this.mView.requestRender();
        if (bl && this.mGeckoIsReady) {
            this.geometryChanged(null);
        }
    }

    void forceViewportMetrics(ImmutableViewportMetrics immutableViewportMetrics, boolean bl, boolean bl2) {
        if (bl2) {
            this.mForceRedraw = true;
        }
        this.mViewportMetrics = immutableViewportMetrics;
        this.viewportMetricsChanged(bl);
    }

    @Override
    public void scrollBy(float f, float f2) {
        this.mViewportMetrics = this.mViewportMetrics.offsetViewportBy(f, f2);
        this.viewportMetricsChanged(true);
    }

    @Override
    public void panZoomStopped() {
        this.mToolbarAnimator.onPanZoomStopped();
    }

    @Override
    public void forceRedraw(DisplayPortMetrics displayPortMetrics) {
        this.mForceRedraw = true;
        if (this.mGeckoIsReady) {
            this.geometryChanged(displayPortMetrics);
        }
    }

    @Override
    public boolean post(Runnable runnable) {
        return this.mView.post(runnable);
    }

    @Override
    public void postRenderTask(RenderTask renderTask) {
        this.mView.postRenderTask(renderTask);
    }

    @Override
    public void removeRenderTask(RenderTask renderTask) {
        this.mView.removeRenderTask(renderTask);
    }

    @Override
    public Object getLock() {
        return this;
    }

    @Override
    public PointF convertViewPointToLayerPoint(PointF pointF) {
        if (!this.mGeckoIsReady) {
            return null;
        }
        ImmutableViewportMetrics immutableViewportMetrics = this.mViewportMetrics;
        PointF pointF2 = immutableViewportMetrics.getOrigin();
        float f = immutableViewportMetrics.zoomFactor;
        ImmutableViewportMetrics immutableViewportMetrics2 = this.mViewportMetrics;
        PointF pointF3 = immutableViewportMetrics2.getOrigin();
        float f2 = immutableViewportMetrics2.zoomFactor;
        PointF pointF4 = new PointF((pointF.x + pointF2.x) / f - pointF3.x / f2, (pointF.y + pointF2.y) / f - pointF3.y / f2);
        return pointF4;
    }

    @Override
    public Matrix getMatrixForLayerRectToViewRect() {
        if (!this.mGeckoIsReady) {
            return null;
        }
        ImmutableViewportMetrics immutableViewportMetrics = this.mViewportMetrics;
        PointF pointF = immutableViewportMetrics.getOrigin();
        float f = immutableViewportMetrics.zoomFactor;
        ImmutableViewportMetrics immutableViewportMetrics2 = this.mViewportMetrics;
        PointF pointF2 = immutableViewportMetrics2.getOrigin();
        float f2 = immutableViewportMetrics2.zoomFactor;
        Matrix matrix = new Matrix();
        matrix.postTranslate(pointF2.x / f2, pointF2.y / f2);
        matrix.postScale(f, f);
        matrix.postTranslate(-pointF.x, -pointF.y);
        return matrix;
    }

    @Override
    public void setScrollingRootContent(boolean bl) {
        this.mToolbarAnimator.setScrollingRootContent(bl);
    }

    public void addDrawListener(LayerView.DrawListener drawListener) {
        this.mDrawListeners.add(drawListener);
    }

    public void removeDrawListener(LayerView.DrawListener drawListener) {
        this.mDrawListeners.remove(drawListener);
    }

    class SynthesizedEventState {
        public final ArrayList<PointerInfo> pointers = new ArrayList();
        public long downTime;

        SynthesizedEventState() {
        }

        int getPointerIndex(int n) {
            for (int i = 0; i < this.pointers.size(); ++i) {
                if (this.pointers.get((int)i).pointerId != n) continue;
                return i;
            }
            return -1;
        }

        int addPointer(int n, int n2) {
            PointerInfo pointerInfo = new PointerInfo();
            pointerInfo.pointerId = n;
            pointerInfo.source = n2;
            this.pointers.add(pointerInfo);
            return this.pointers.size() - 1;
        }

        int getPointerCount(int n) {
            int n2 = 0;
            for (int i = 0; i < this.pointers.size(); ++i) {
                if (this.pointers.get((int)i).source != n) continue;
                ++n2;
            }
            return n2;
        }

        MotionEvent.PointerProperties[] getPointerProperties(int n) {
            MotionEvent.PointerProperties[] pointerPropertiesArray = new MotionEvent.PointerProperties[this.getPointerCount(n)];
            int n2 = 0;
            for (int i = 0; i < this.pointers.size(); ++i) {
                if (this.pointers.get((int)i).source != n) continue;
                MotionEvent.PointerProperties pointerProperties = new MotionEvent.PointerProperties();
                pointerProperties.id = this.pointers.get((int)i).pointerId;
                switch (n) {
                    case 4098: {
                        pointerProperties.toolType = 1;
                        break;
                    }
                    case 8194: {
                        pointerProperties.toolType = 3;
                    }
                }
                pointerPropertiesArray[n2++] = pointerProperties;
            }
            return pointerPropertiesArray;
        }

        MotionEvent.PointerCoords[] getPointerCoords(int n) {
            MotionEvent.PointerCoords[] pointerCoordsArray = new MotionEvent.PointerCoords[this.getPointerCount(n)];
            int n2 = 0;
            for (int i = 0; i < this.pointers.size(); ++i) {
                if (this.pointers.get((int)i).source != n) continue;
                pointerCoordsArray[n2++] = this.pointers.get(i).getCoords();
            }
            return pointerCoordsArray;
        }
    }

    class PointerInfo {
        public static final int RESERVED_MOUSE_POINTER_ID = 100000;
        public int pointerId;
        public int source;
        public int screenX;
        public int screenY;
        public double pressure;
        public int orientation;

        PointerInfo() {
        }

        public MotionEvent.PointerCoords getCoords() {
            MotionEvent.PointerCoords pointerCoords = new MotionEvent.PointerCoords();
            pointerCoords.orientation = this.orientation;
            pointerCoords.pressure = (float)this.pressure;
            pointerCoords.x = this.screenX;
            pointerCoords.y = this.screenY;
            return pointerCoords;
        }
    }

    private static enum ViewportMessageType {
        UPDATE,
        PAGE_SIZE;

    }
}

