/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.HeaderViewListAdapter;
import android.widget.ListAdapter;
import java.util.EnumSet;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.home.BookmarksListAdapter;
import org.mozilla.gecko.home.HomeListView;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.reader.SavedReaderViewHelper;
import org.mozilla.gecko.util.NetworkUtils;

public class BookmarksListView
extends HomeListView
implements AdapterView.OnItemClickListener {
    public static final String LOGTAG = "GeckoBookmarksListView";

    public BookmarksListView(Context context) {
        this(context, null);
    }

    public BookmarksListView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.bookmarksListViewStyle);
    }

    public BookmarksListView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setOnItemClickListener(this);
        this.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View view, int n, KeyEvent keyEvent) {
                int n2 = keyEvent.getAction();
                if (n2 == 1 && n == 4) {
                    return BookmarksListView.this.getBookmarksListAdapter().moveToParentFolder();
                }
                return false;
            }
        });
    }

    private String getTelemetryExtraForFolder(int n, int n2) {
        if (n == -1) {
            return "folder_desktop";
        }
        if (n == -4) {
            return "folder_screenshots";
        }
        if (n == -5) {
            return "folder_reading_list";
        }
        if (n2 == -1) {
            return "folder_desktop_subfolder";
        }
        return "folder_mobile_subfolder";
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
        Cursor cursor;
        BookmarksListAdapter bookmarksListAdapter = this.getBookmarksListAdapter();
        if (bookmarksListAdapter.isShowingChildFolder()) {
            if (n == 0) {
                List<BookmarksListAdapter.FolderInfo> list = ((BookmarksListAdapter)this.getAdapter()).getParentStack();
                if (list.size() < 2) {
                    throw new IllegalStateException("Cannot move to parent folder if we are already in the root folder");
                }
                BookmarksListAdapter.FolderInfo folderInfo = list.get(1);
                int n2 = folderInfo.id;
                int n3 = list.size() > 2 ? list.get((int)(list.size() - 2)).id : 0;
                String string2 = this.getTelemetryExtraForFolder(n2, n3);
                bookmarksListAdapter.moveToParentFolder();
                Telemetry.sendUIEvent(TelemetryContract.Event.SHOW, TelemetryContract.Method.LIST_ITEM, string2);
                return;
            }
            --n;
        }
        if ((cursor = bookmarksListAdapter.getCursor()) == null) {
            return;
        }
        cursor.moveToPosition(n);
        if (bookmarksListAdapter.getOpenFolderType() == BookmarksListAdapter.FolderType.SCREENSHOTS) {
            Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.LIST_ITEM, "bookmarks-screenshot");
            String string3 = "file://" + cursor.getString(cursor.getColumnIndex("value"));
            this.getOnUrlOpenListener().onUrlOpen(string3, EnumSet.of(HomePager.OnUrlOpenListener.Flags.ALLOW_SWITCH_TO_TAB));
            return;
        }
        int n4 = cursor.getInt(cursor.getColumnIndexOrThrow("type"));
        if (n4 == 0) {
            int n5 = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
            String string4 = bookmarksListAdapter.getFolderTitle(adapterView.getContext(), cursor);
            bookmarksListAdapter.moveToChildFolder(n5, string4);
            List<BookmarksListAdapter.FolderInfo> list = ((BookmarksListAdapter)this.getAdapter()).getParentStack();
            int n6 = list.size() > 2 ? list.get((int)(list.size() - 2)).id : 0;
            String string5 = this.getTelemetryExtraForFolder(n5, n6);
            Telemetry.sendUIEvent(TelemetryContract.Event.SHOW, TelemetryContract.Method.LIST_ITEM, string5);
        } else {
            String string6 = cursor.getString(cursor.getColumnIndexOrThrow("url"));
            SavedReaderViewHelper savedReaderViewHelper = SavedReaderViewHelper.getSavedReaderViewHelper(this.getContext());
            String string7 = savedReaderViewHelper.isURLCached(string6) ? "bookmarks-reader" : "bookmarks";
            Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.LIST_ITEM, string7);
            Telemetry.addToHistogram("FENNEC_LOAD_SAVED_PAGE", NetworkUtils.isConnected((Context)this.getContext()) ? 2 : 3);
            this.getOnUrlOpenListener().onUrlOpen(string6, EnumSet.of(HomePager.OnUrlOpenListener.Flags.ALLOW_SWITCH_TO_TAB));
        }
    }

    @Override
    public boolean onItemLongClick(AdapterView<?> adapterView, View view, int n, long l) {
        BookmarksListAdapter bookmarksListAdapter = this.getBookmarksListAdapter();
        if (bookmarksListAdapter.isShowingChildFolder()) {
            --n;
        }
        if (bookmarksListAdapter.getOpenFolderType() == BookmarksListAdapter.FolderType.SCREENSHOTS) {
            return false;
        }
        return super.onItemLongClick(adapterView, view, n, l);
    }

    private BookmarksListAdapter getBookmarksListAdapter() {
        ListAdapter listAdapter = this.getAdapter();
        BookmarksListAdapter bookmarksListAdapter = listAdapter instanceof HeaderViewListAdapter ? (BookmarksListAdapter)((HeaderViewListAdapter)listAdapter).getWrappedAdapter() : (BookmarksListAdapter)listAdapter;
        return bookmarksListAdapter;
    }
}

