/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.accounts.Account;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.UnderlineSpan;
import android.util.Log;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.R;
import org.mozilla.gecko.RemoteClientsDialogFragment;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.db.RemoteClient;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.SyncStatusListener;
import org.mozilla.gecko.home.ClientsAdapter;
import org.mozilla.gecko.home.CombinedHistoryAdapter;
import org.mozilla.gecko.home.CombinedHistoryRecyclerView;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.RecentTabsAdapter;
import org.mozilla.gecko.home.SimpleCursorLoader;
import org.mozilla.gecko.restrictions.Restrictable;
import org.mozilla.gecko.restrictions.Restrictions;
import org.mozilla.gecko.widget.HistoryDividerItemDecoration;

public class CombinedHistoryPanel
extends HomeFragment
implements RemoteClientsDialogFragment.RemoteClientsListener {
    private static final String LOGTAG = "GeckoCombinedHistoryPnl";
    private static final String[] STAGES_TO_SYNC_ON_REFRESH = new String[]{"clients", "tabs"};
    private final int LOADER_ID_HISTORY = 0;
    private final int LOADER_ID_REMOTE = 1;
    private static final String FORMAT_S1 = "%1$s";
    private static final String FORMAT_S2 = "%2$s";
    public static final int NUM_SMART_FOLDERS = 2;
    private CombinedHistoryRecyclerView mRecyclerView;
    private CombinedHistoryAdapter mHistoryAdapter;
    private ClientsAdapter mClientsAdapter;
    private RecentTabsAdapter mRecentTabsAdapter;
    private CursorLoaderCallbacks mCursorLoaderCallbacks;
    private Bundle mSavedRestoreBundle;
    private OnPanelLevelChangeListener.PanelLevel mPanelLevel;
    private Button mPanelFooterButton;
    private PanelStateUpdateHandler mPanelStateUpdateHandler;
    protected SwipeRefreshLayout mRefreshLayout;
    protected RemoteTabsSyncListener mSyncStatusListener;
    private View mHistoryEmptyView;
    private View mClientsEmptyView;
    private View mRecentTabsEmptyView;

    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mHistoryAdapter = new CombinedHistoryAdapter(this.getResources());
        this.mClientsAdapter = new ClientsAdapter(this.getContext());
        this.mRecentTabsAdapter = new RecentTabsAdapter(this.getContext(), this.mHistoryAdapter.getRecentTabsUpdateHandler(), this.getPanelStateUpdateHandler());
        this.mSyncStatusListener = new RemoteTabsSyncListener();
        FirefoxAccounts.addSyncStatusListener((SyncStatusListener)this.mSyncStatusListener);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return layoutInflater.inflate(R.layout.home_combined_history_panel, viewGroup, false);
    }

    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.mRecyclerView = (CombinedHistoryRecyclerView)view.findViewById(R.id.combined_recycler_view);
        this.setUpRecyclerView();
        this.mRefreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.refresh_layout);
        this.setUpRefreshLayout();
        this.mClientsEmptyView = view.findViewById(R.id.home_clients_empty_view);
        this.mHistoryEmptyView = view.findViewById(R.id.home_history_empty_view);
        this.mRecentTabsEmptyView = view.findViewById(R.id.home_recent_tabs_empty_view);
        this.setUpEmptyViews();
        this.mPanelFooterButton = (Button)view.findViewById(R.id.history_panel_footer_button);
        this.mPanelFooterButton.setText(R.string.home_clear_history_button);
        this.mPanelFooterButton.setOnClickListener((View.OnClickListener)new OnFooterButtonClickListener());
        this.mRecentTabsAdapter.startListeningForClosedTabs();
        if (this.mSavedRestoreBundle != null) {
            this.setPanelStateFromBundle(this.mSavedRestoreBundle);
            this.mSavedRestoreBundle = null;
        }
    }

    private void setUpRecyclerView() {
        if (this.mPanelLevel == null) {
            this.mPanelLevel = OnPanelLevelChangeListener.PanelLevel.PARENT;
        }
        this.mRecyclerView.setAdapter(this.mPanelLevel == OnPanelLevelChangeListener.PanelLevel.PARENT ? this.mHistoryAdapter : (this.mPanelLevel == OnPanelLevelChangeListener.PanelLevel.CHILD_SYNC ? this.mClientsAdapter : this.mRecentTabsAdapter));
        DefaultItemAnimator defaultItemAnimator = new DefaultItemAnimator();
        defaultItemAnimator.setAddDuration(100L);
        defaultItemAnimator.setChangeDuration(100L);
        defaultItemAnimator.setMoveDuration(100L);
        defaultItemAnimator.setRemoveDuration(100L);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mRecyclerView.setItemAnimator((RecyclerView.ItemAnimator)defaultItemAnimator);
        this.mRecyclerView.addItemDecoration(new HistoryDividerItemDecoration(this.getContext()));
        this.mRecyclerView.setOnHistoryClickedListener(this.mUrlOpenListener);
        this.mRecyclerView.setOnPanelLevelChangeListener(new OnLevelChangeListener());
        this.mRecyclerView.setHiddenClientsDialogBuilder(new HiddenClientsHelper());
        this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int n, int n2) {
                super.onScrolled(recyclerView, n, n2);
                LinearLayoutManager linearLayoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
                if (CombinedHistoryPanel.this.mPanelLevel == OnPanelLevelChangeListener.PanelLevel.PARENT && linearLayoutManager.findLastCompletelyVisibleItemPosition() == 100) {
                    Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.LIST, "history_scroll_max");
                }
            }
        });
        this.registerForContextMenu((View)this.mRecyclerView);
    }

    private void setUpRefreshLayout() {
        this.mRefreshLayout.setColorSchemeResources(new int[]{R.color.fennec_ui_orange, R.color.action_orange});
        this.mRefreshLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)new RemoteTabsRefreshListener());
        this.mRefreshLayout.setEnabled(false);
    }

    private void setUpEmptyViews() {
        SpannableStringBuilder spannableStringBuilder;
        String string2;
        ImageView imageView = (ImageView)this.mHistoryEmptyView.findViewById(R.id.home_empty_image);
        imageView.setVisibility(8);
        TextView textView = (TextView)this.mHistoryEmptyView.findViewById(R.id.home_empty_text);
        textView.setText(R.string.home_most_recent_empty);
        TextView textView2 = (TextView)this.mHistoryEmptyView.findViewById(R.id.home_empty_hint);
        if (!Restrictions.isAllowed((Context)this.getActivity(), Restrictable.PRIVATE_BROWSING)) {
            textView2.setVisibility(8);
        } else {
            string2 = this.getResources().getString(R.string.home_most_recent_emptyhint);
            spannableStringBuilder = this.formatHintText(string2);
            if (spannableStringBuilder != null) {
                textView2.setText((CharSequence)spannableStringBuilder);
                textView2.setMovementMethod(LinkMovementMethod.getInstance());
                textView2.setVisibility(0);
            }
        }
        string2 = (Button)this.mClientsEmptyView.findViewById(R.id.sync_setup_button);
        string2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.BUTTON, "history_syncsetup");
                Intent intent = new Intent("org.mozilla.fennec.ACTION_FXA_GET_STARTED");
                CombinedHistoryPanel.this.startActivity(intent);
            }
        });
        spannableStringBuilder = (ImageView)this.mRecentTabsEmptyView.findViewById(R.id.home_empty_image);
        spannableStringBuilder.setImageResource(R.drawable.icon_remote_tabs_empty);
        TextView textView3 = (TextView)this.mRecentTabsEmptyView.findViewById(R.id.home_empty_text);
        textView3.setText(R.string.home_last_tabs_empty);
    }

    @Override
    public void restoreData(Bundle bundle) {
        if (this.mRecyclerView != null) {
            this.setPanelStateFromBundle(bundle);
        } else {
            this.mSavedRestoreBundle = bundle;
        }
    }

    private void setPanelStateFromBundle(Bundle bundle) {
        if (bundle != null && bundle.getBoolean("goToRecentTabs", false) && this.mPanelLevel != OnPanelLevelChangeListener.PanelLevel.CHILD_RECENT_TABS) {
            this.mPanelLevel = OnPanelLevelChangeListener.PanelLevel.CHILD_RECENT_TABS;
            this.mRecyclerView.swapAdapter(this.mRecentTabsAdapter, true);
            this.updateEmptyView();
            this.updateButtonFromLevel();
        }
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        this.mCursorLoaderCallbacks = new CursorLoaderCallbacks();
    }

    @Override
    protected void load() {
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
        this.getLoaderManager().initLoader(1, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
    }

    public PanelStateUpdateHandler getPanelStateUpdateHandler() {
        if (this.mPanelStateUpdateHandler == null) {
            this.mPanelStateUpdateHandler = new PanelStateUpdateHandler(){

                @Override
                public void onPanelStateUpdated() {
                    CombinedHistoryPanel.this.updateEmptyView();
                    CombinedHistoryPanel.this.updateButtonFromLevel();
                }
            };
        }
        return this.mPanelStateUpdateHandler;
    }

    private void updateButtonFromLevel() {
        switch (this.mPanelLevel) {
            case PARENT: {
                boolean bl;
                boolean bl2 = bl = !Restrictions.isAllowed((Context)this.getActivity(), Restrictable.CLEAR_HISTORY);
                if (bl || this.mHistoryAdapter.getItemCount() == 2) {
                    this.mPanelFooterButton.setVisibility(8);
                    break;
                }
                this.mPanelFooterButton.setText(R.string.home_clear_history_button);
                this.mPanelFooterButton.setVisibility(0);
                break;
            }
            case CHILD_RECENT_TABS: {
                if (this.mRecentTabsAdapter.getClosedTabsCount() > 1) {
                    this.mPanelFooterButton.setText(R.string.home_restore_all);
                    this.mPanelFooterButton.setVisibility(0);
                    break;
                }
                this.mPanelFooterButton.setVisibility(8);
                break;
            }
            case CHILD_SYNC: {
                this.mPanelFooterButton.setVisibility(8);
            }
        }
    }

    private void updateEmptyView() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        switch (this.mPanelLevel) {
            case PARENT: {
                bl = this.mHistoryAdapter.getItemCount() == 2;
                break;
            }
            case CHILD_SYNC: {
                bl2 = this.mClientsAdapter.getItemCount() == 1;
                break;
            }
            case CHILD_RECENT_TABS: {
                bl3 = this.mRecentTabsAdapter.getClosedTabsCount() == 0;
            }
        }
        boolean bl4 = bl2 || bl || bl3;
        this.mRecyclerView.setOverScrollMode(bl4 ? 2 : 1);
        this.mClientsEmptyView.setVisibility(bl2 ? 0 : 8);
        this.mHistoryEmptyView.setVisibility(bl ? 0 : 8);
        this.mRecentTabsEmptyView.setVisibility(bl3 ? 0 : 8);
    }

    private SpannableStringBuilder formatHintText(String string2) {
        int n;
        int n2 = string2.indexOf(FORMAT_S1);
        if (n2 >= (n = string2.indexOf(FORMAT_S2))) {
            return null;
        }
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)string2);
        ClickableSpan clickableSpan = new ClickableSpan(){

            public void onClick(View view) {
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.BUTTON, "hint_private_browsing");
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("type", (Object)"Menu:Open");
                    EventDispatcher.getInstance().dispatchEvent(jSONObject, null);
                }
                catch (JSONException jSONException) {
                    Log.e((String)CombinedHistoryPanel.LOGTAG, (String)"Error forming JSON for Private Browsing contextual hint", (Throwable)jSONException);
                }
            }
        };
        spannableStringBuilder.setSpan((Object)clickableSpan, 0, string2.length(), 0);
        UnderlineSpan underlineSpan = new UnderlineSpan(){

            public void updateDrawState(TextPaint textPaint) {
                textPaint.setUnderlineText(false);
            }
        };
        spannableStringBuilder.setSpan((Object)underlineSpan, 0, string2.length(), 0);
        spannableStringBuilder.setSpan((Object)new UnderlineSpan(), n2, n, 0);
        spannableStringBuilder.delete(n, n + FORMAT_S2.length());
        spannableStringBuilder.delete(n2, n2 + FORMAT_S1.length());
        return spannableStringBuilder;
    }

    @Override
    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
        if (!(contextMenuInfo instanceof RemoteTabsClientContextMenuInfo)) {
            super.onCreateContextMenu(contextMenu, view, contextMenuInfo);
            return;
        }
        MenuInflater menuInflater = new MenuInflater(view.getContext());
        menuInflater.inflate(R.menu.home_remote_tabs_client_contextmenu, (Menu)contextMenu);
        RemoteTabsClientContextMenuInfo remoteTabsClientContextMenuInfo = (RemoteTabsClientContextMenuInfo)contextMenuInfo;
        contextMenu.setHeaderTitle((CharSequence)remoteTabsClientContextMenuInfo.client.name);
    }

    @Override
    public boolean onContextItemSelected(MenuItem menuItem) {
        if (super.onContextItemSelected(menuItem)) {
            return true;
        }
        ContextMenu.ContextMenuInfo contextMenuInfo = menuItem.getMenuInfo();
        if (!(contextMenuInfo instanceof RemoteTabsClientContextMenuInfo)) {
            return false;
        }
        RemoteTabsClientContextMenuInfo remoteTabsClientContextMenuInfo = (RemoteTabsClientContextMenuInfo)contextMenuInfo;
        int n = menuItem.getItemId();
        if (n == R.id.home_remote_tabs_hide_client) {
            this.mClientsAdapter.removeItem(remoteTabsClientContextMenuInfo.position);
            return true;
        }
        return false;
    }

    @Override
    public void onClients(List<RemoteClient> list) {
        this.mClientsAdapter.unhideClients(list);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mRecentTabsAdapter.stopListeningForClosedTabs();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.mSyncStatusListener != null) {
            FirefoxAccounts.removeSyncStatusListener((SyncStatusListener)this.mSyncStatusListener);
            this.mSyncStatusListener = null;
        }
    }

    protected class RemoteTabsSyncListener
    implements SyncStatusListener {
        protected RemoteTabsSyncListener() {
        }

        public Context getContext() {
            return CombinedHistoryPanel.this.getActivity();
        }

        public Account getAccount() {
            return FirefoxAccounts.getFirefoxAccount((Context)this.getContext());
        }

        public void onSyncStarted() {
        }

        public void onSyncFinished() {
            CombinedHistoryPanel.this.mRefreshLayout.setRefreshing(false);
        }
    }

    protected class RemoteTabsRefreshListener
    implements SwipeRefreshLayout.OnRefreshListener {
        protected RemoteTabsRefreshListener() {
        }

        public void onRefresh() {
            if (FirefoxAccounts.firefoxAccountsExist((Context)CombinedHistoryPanel.this.getActivity())) {
                Account account = FirefoxAccounts.getFirefoxAccount((Context)CombinedHistoryPanel.this.getActivity());
                FirefoxAccounts.requestImmediateSync((Account)account, (String[])STAGES_TO_SYNC_ON_REFRESH, null);
            } else {
                Log.wtf((String)CombinedHistoryPanel.LOGTAG, (String)"No Firefox Account found; this should never happen. Ignoring.");
                CombinedHistoryPanel.this.mRefreshLayout.setRefreshing(false);
            }
        }
    }

    protected static class RemoteTabsClientContextMenuInfo
    extends HomeContextMenuInfo {
        protected final RemoteClient client;

        public RemoteTabsClientContextMenuInfo(View view, int n, long l, RemoteClient remoteClient) {
            super(view, n, l);
            this.client = remoteClient;
        }
    }

    protected class HiddenClientsHelper
    implements DialogBuilder<RemoteClient> {
        protected HiddenClientsHelper() {
        }

        @Override
        public void createAndShowDialog(List<RemoteClient> list) {
            RemoteClientsDialogFragment remoteClientsDialogFragment = RemoteClientsDialogFragment.newInstance(CombinedHistoryPanel.this.getResources().getString(R.string.home_remote_tabs_hidden_devices_title), CombinedHistoryPanel.this.getResources().getString(R.string.home_remote_tabs_unhide_selected_devices), RemoteClientsDialogFragment.ChoiceMode.MULTIPLE, new ArrayList<RemoteClient>(list));
            remoteClientsDialogFragment.setTargetFragment(CombinedHistoryPanel.this, 0);
            remoteClientsDialogFragment.show(CombinedHistoryPanel.this.getActivity().getSupportFragmentManager(), "show-clients");
        }
    }

    static interface DialogBuilder<E> {
        public void createAndShowDialog(List<E> var1);
    }

    private class OnFooterButtonClickListener
    implements View.OnClickListener {
        private OnFooterButtonClickListener() {
        }

        public void onClick(View view) {
            switch (CombinedHistoryPanel.this.mPanelLevel) {
                case PARENT: {
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)CombinedHistoryPanel.this.getActivity());
                    builder.setMessage(R.string.home_clear_history_confirm);
                    builder.setNegativeButton(R.string.button_cancel, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int n) {
                            dialogInterface.dismiss();
                        }
                    });
                    builder.setPositiveButton(R.string.button_ok, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int n) {
                            dialogInterface.dismiss();
                            JSONObject jSONObject = new JSONObject();
                            try {
                                jSONObject.put("history", true);
                            }
                            catch (JSONException jSONException) {
                                Log.e((String)CombinedHistoryPanel.LOGTAG, (String)"JSON error", (Throwable)jSONException);
                            }
                            GeckoAppShell.notifyObservers("Sanitize:ClearData", jSONObject.toString());
                            CombinedHistoryPanel.this.mRecentTabsAdapter.clearLastSessionData();
                            Telemetry.sendUIEvent(TelemetryContract.Event.SANITIZE, TelemetryContract.Method.BUTTON, "history");
                        }
                    });
                    builder.show();
                    break;
                }
                case CHILD_RECENT_TABS: {
                    String string2 = CombinedHistoryPanel.this.mRecentTabsAdapter.restoreAllTabs();
                    if (string2 == null) break;
                    Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.BUTTON, string2);
                }
            }
        }
    }

    protected class OnLevelChangeListener
    implements OnPanelLevelChangeListener {
        protected OnLevelChangeListener() {
        }

        @Override
        public boolean changeLevel(OnPanelLevelChangeListener.PanelLevel panelLevel) {
            if (panelLevel == CombinedHistoryPanel.this.mPanelLevel) {
                return false;
            }
            CombinedHistoryPanel.this.mPanelLevel = panelLevel;
            switch (panelLevel) {
                case PARENT: {
                    CombinedHistoryPanel.this.mRecyclerView.swapAdapter(CombinedHistoryPanel.this.mHistoryAdapter, true);
                    CombinedHistoryPanel.this.mRefreshLayout.setEnabled(false);
                    break;
                }
                case CHILD_SYNC: {
                    CombinedHistoryPanel.this.mRecyclerView.swapAdapter(CombinedHistoryPanel.this.mClientsAdapter, true);
                    CombinedHistoryPanel.this.mRefreshLayout.setEnabled(CombinedHistoryPanel.this.mClientsAdapter.getClientsCount() > 0);
                    break;
                }
                case CHILD_RECENT_TABS: {
                    CombinedHistoryPanel.this.mRecyclerView.swapAdapter(CombinedHistoryPanel.this.mRecentTabsAdapter, true);
                }
            }
            CombinedHistoryPanel.this.updateEmptyView();
            CombinedHistoryPanel.this.updateButtonFromLevel();
            return true;
        }
    }

    public static interface PanelStateUpdateHandler {
        public void onPanelStateUpdated();
    }

    private class CursorLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private BrowserDB mDB;

        private CursorLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            if (this.mDB == null) {
                this.mDB = GeckoProfile.get((Context)CombinedHistoryPanel.this.getActivity()).getDB();
            }
            switch (n) {
                case 0: {
                    return new HistoryCursorLoader(CombinedHistoryPanel.this.getContext());
                }
                case 1: {
                    return new RemoteTabsCursorLoader(CombinedHistoryPanel.this.getContext());
                }
            }
            Log.e((String)CombinedHistoryPanel.LOGTAG, (String)"Unknown loader id!");
            return null;
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
            int n = loader.getId();
            switch (n) {
                case 0: {
                    CombinedHistoryPanel.this.mHistoryAdapter.setHistory(cursor);
                    break;
                }
                case 1: {
                    List<RemoteClient> list = this.mDB.getTabsAccessor().getClientsFromCursor(cursor);
                    CombinedHistoryPanel.this.mHistoryAdapter.getDeviceUpdateHandler().onDeviceCountUpdated(list.size());
                    CombinedHistoryPanel.this.mClientsAdapter.setClients(list);
                }
            }
            CombinedHistoryPanel.this.updateEmptyView();
            CombinedHistoryPanel.this.updateButtonFromLevel();
        }

        public void onLoaderReset(Loader<Cursor> loader) {
            CombinedHistoryPanel.this.mClientsAdapter.setClients(Collections.emptyList());
            CombinedHistoryPanel.this.mHistoryAdapter.setHistory(null);
        }
    }

    private static class HistoryCursorLoader
    extends SimpleCursorLoader {
        public static final int HISTORY_LIMIT = 100;
        private final BrowserDB mDB;

        public HistoryCursorLoader(Context context) {
            super(context);
            this.mDB = GeckoProfile.get(context).getDB();
        }

        @Override
        public Cursor loadCursor() {
            ContentResolver contentResolver = this.getContext().getContentResolver();
            return this.mDB.getRecentHistory(contentResolver, 100);
        }
    }

    private static class RemoteTabsCursorLoader
    extends SimpleCursorLoader {
        private final GeckoProfile mProfile;

        public RemoteTabsCursorLoader(Context context) {
            super(context);
            this.mProfile = GeckoProfile.get(context);
        }

        @Override
        public Cursor loadCursor() {
            return this.mProfile.getDB().getTabsAccessor().getRemoteTabsCursor(this.getContext());
        }
    }

    public static interface OnPanelLevelChangeListener {
        public boolean changeLevel(PanelLevel var1);

        public static enum PanelLevel {
            PARENT,
            CHILD_SYNC,
            CHILD_RECENT_TABS;

        }
    }
}

