/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.R;
import org.mozilla.gecko.SessionParser;
import org.mozilla.gecko.home.CombinedHistoryAdapter;
import org.mozilla.gecko.home.CombinedHistoryItem;
import org.mozilla.gecko.home.CombinedHistoryPanel;
import org.mozilla.gecko.home.CombinedHistoryRecyclerView;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.ThreadUtils;

public class RecentTabsAdapter
extends RecyclerView.Adapter<CombinedHistoryItem>
implements CombinedHistoryRecyclerView.AdapterContextMenuBuilder,
NativeEventListener {
    private static final String LOGTAG = "GeckoRecentTabsAdapter";
    private static final int NAVIGATION_BACK_BUTTON_INDEX = 0;
    private static final String TELEMETRY_EXTRA_LAST_TIME = "recent_tabs_last_time";
    private static final String TELEMETRY_EXTRA_RECENTY_CLOSED = "recent_closed_tabs";
    private static final String TELEMETRY_EXTRA_MIXED = "recent_tabs_mixed";
    private ClosedTab[] recentlyClosedTabs;
    private ClosedTab[] lastSessionTabs;
    private final Context context;
    private final CombinedHistoryAdapter.RecentTabsUpdateHandler recentTabsUpdateHandler;
    private final CombinedHistoryPanel.PanelStateUpdateHandler panelStateUpdateHandler;

    public RecentTabsAdapter(Context context, CombinedHistoryAdapter.RecentTabsUpdateHandler recentTabsUpdateHandler, CombinedHistoryPanel.PanelStateUpdateHandler panelStateUpdateHandler) {
        this.context = context;
        this.recentTabsUpdateHandler = recentTabsUpdateHandler;
        this.panelStateUpdateHandler = panelStateUpdateHandler;
        this.recentlyClosedTabs = new ClosedTab[0];
        this.lastSessionTabs = new ClosedTab[0];
        this.readPreviousSessionData();
    }

    public void startListeningForClosedTabs() {
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "ClosedTabs:Data");
        GeckoAppShell.notifyObservers("ClosedTabs:StartNotifications", null);
    }

    public void stopListeningForClosedTabs() {
        GeckoAppShell.notifyObservers("ClosedTabs:StopNotifications", null);
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "ClosedTabs:Data");
    }

    public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        NativeJSObject[] nativeJSObjectArray = nativeJSObject.getObjectArray("tabs");
        int n = nativeJSObjectArray.length;
        final ClosedTab[] closedTabArray = new ClosedTab[n];
        for (int i = 0; i < n; ++i) {
            NativeJSObject nativeJSObject2 = nativeJSObjectArray[i];
            closedTabArray[i] = new ClosedTab(nativeJSObject2.getString("url"), nativeJSObject2.getString("title"), nativeJSObject2.getObject("data").toString());
        }
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                int n = RecentTabsAdapter.this.recentlyClosedTabs.length;
                boolean bl = RecentTabsAdapter.this.isSectionHeaderVisible();
                int n2 = RecentTabsAdapter.this.getSectionHeaderIndex();
                RecentTabsAdapter.access$002(RecentTabsAdapter.this, closedTabArray);
                RecentTabsAdapter.this.recentTabsUpdateHandler.onRecentTabsCountUpdated(RecentTabsAdapter.this.getClosedTabsCount());
                RecentTabsAdapter.this.panelStateUpdateHandler.onPanelStateUpdated();
                RecentTabsAdapter.this.updateHeaderVisibility(bl, n2);
                RecentTabsAdapter.this.updateTabsList(n, RecentTabsAdapter.this.recentlyClosedTabs.length, RecentTabsAdapter.this.getFirstRecentTabIndex(), RecentTabsAdapter.this.getLastRecentTabIndex());
            }
        });
    }

    private void readPreviousSessionData() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                GeckoProfile.get(RecentTabsAdapter.this.context).waitForOldSessionDataProcessing();
                String string2 = GeckoProfile.get(RecentTabsAdapter.this.context).readSessionFile(true);
                if (string2 == null) {
                    return;
                }
                final ArrayList arrayList = new ArrayList();
                new SessionParser(){

                    @Override
                    public void onTabRead(SessionParser.SessionTab sessionTab) {
                        String string2 = sessionTab.getUrl();
                        if (AboutPages.isAboutHome(string2)) {
                            return;
                        }
                        arrayList.add(new ClosedTab(string2, sessionTab.getTitle(), sessionTab.getTabObject().toString()));
                    }
                }.parse(string2);
                final ClosedTab[] closedTabArray = arrayList.toArray(new ClosedTab[arrayList.size()]);
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        int n = RecentTabsAdapter.this.lastSessionTabs.length;
                        boolean bl = RecentTabsAdapter.this.isSectionHeaderVisible();
                        int n2 = RecentTabsAdapter.this.getSectionHeaderIndex();
                        RecentTabsAdapter.access$1002(RecentTabsAdapter.this, closedTabArray);
                        RecentTabsAdapter.this.recentTabsUpdateHandler.onRecentTabsCountUpdated(RecentTabsAdapter.this.getClosedTabsCount());
                        RecentTabsAdapter.this.panelStateUpdateHandler.onPanelStateUpdated();
                        RecentTabsAdapter.this.updateHeaderVisibility(bl, n2);
                        RecentTabsAdapter.this.updateTabsList(n, RecentTabsAdapter.this.lastSessionTabs.length, RecentTabsAdapter.this.getFirstLastSessionTabIndex(), RecentTabsAdapter.this.getLastLastSessionTabIndex());
                    }
                });
            }
        }, "LastSessionTabsThread");
        thread.start();
    }

    public void clearLastSessionData() {
        final ClosedTab[] closedTabArray = new ClosedTab[]{};
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                int n = RecentTabsAdapter.this.lastSessionTabs.length;
                boolean bl = RecentTabsAdapter.this.isSectionHeaderVisible();
                int n2 = RecentTabsAdapter.this.getSectionHeaderIndex();
                RecentTabsAdapter.access$1002(RecentTabsAdapter.this, closedTabArray);
                RecentTabsAdapter.this.recentTabsUpdateHandler.onRecentTabsCountUpdated(RecentTabsAdapter.this.getClosedTabsCount());
                RecentTabsAdapter.this.panelStateUpdateHandler.onPanelStateUpdated();
                RecentTabsAdapter.this.updateHeaderVisibility(bl, n2);
                if (n > 0) {
                    RecentTabsAdapter.this.notifyItemRangeRemoved(RecentTabsAdapter.this.getFirstLastSessionTabIndex(), n);
                }
            }
        });
    }

    private void updateHeaderVisibility(boolean bl, int n) {
        if (bl && !this.isSectionHeaderVisible()) {
            this.notifyItemRemoved(n);
        } else if (!bl && this.isSectionHeaderVisible()) {
            this.notifyItemInserted(this.getSectionHeaderIndex());
        }
    }

    private void updateTabsList(int n, int n2, int n3, int n4) {
        int n5 = n2 - n;
        if (n5 <= 0) {
            this.notifyItemRangeRemoved(n4 + 1, -n5);
            this.notifyItemRangeChanged(n3, n2);
        } else {
            this.notifyItemRangeInserted(n3, n5);
            this.notifyItemRangeChanged(n3 + n5, n);
        }
    }

    public String restoreTabFromPosition(int n) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(this.getClosedTabForPosition((int)n).data);
        String string2 = n > this.getLastRecentTabIndex() ? TELEMETRY_EXTRA_LAST_TIME : TELEMETRY_EXTRA_RECENTY_CLOSED;
        RecentTabsAdapter.restoreSessionWithHistory(arrayList);
        return string2;
    }

    public String restoreAllTabs() {
        if (this.recentlyClosedTabs.length == 0 && this.lastSessionTabs.length == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.getClosedTabsCount());
        this.addTabDataToList(arrayList, this.recentlyClosedTabs);
        this.addTabDataToList(arrayList, this.lastSessionTabs);
        String string2 = this.recentlyClosedTabs.length > 0 && this.lastSessionTabs.length > 0 ? TELEMETRY_EXTRA_MIXED : (this.recentlyClosedTabs.length > 0 ? TELEMETRY_EXTRA_RECENTY_CLOSED : TELEMETRY_EXTRA_LAST_TIME);
        RecentTabsAdapter.restoreSessionWithHistory(arrayList);
        return string2;
    }

    private void addTabDataToList(List<String> list, ClosedTab[] closedTabArray) {
        for (ClosedTab closedTab : closedTabArray) {
            list.add(closedTab.data);
        }
    }

    private static void restoreSessionWithHistory(List<String> list) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("tabs", (Object)new JSONArray(list));
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"JSON error", (Throwable)jSONException);
        }
        GeckoAppShell.notifyObservers("Session:RestoreRecentTabs", jSONObject.toString());
    }

    public CombinedHistoryItem onCreateViewHolder(ViewGroup viewGroup, int n) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)viewGroup.getContext());
        CombinedHistoryItem.ItemType itemType = CombinedHistoryItem.ItemType.viewTypeToItemType(n);
        switch (itemType) {
            case NAVIGATION_BACK: {
                View view = layoutInflater.inflate(R.layout.home_combined_back_item, viewGroup, false);
                return new CombinedHistoryItem.HistoryItem(view);
            }
            case SECTION_HEADER: {
                View view = layoutInflater.inflate(R.layout.home_header_row, viewGroup, false);
                return new CombinedHistoryItem.BasicItem(view);
            }
            case CLOSED_TAB: {
                View view = layoutInflater.inflate(R.layout.home_item_row, viewGroup, false);
                return new CombinedHistoryItem.HistoryItem(view);
            }
        }
        return null;
    }

    public void onBindViewHolder(CombinedHistoryItem combinedHistoryItem, int n) {
        CombinedHistoryItem.ItemType itemType = this.getItemTypeForPosition(n);
        switch (itemType) {
            case SECTION_HEADER: {
                ((TextView)combinedHistoryItem.itemView).setText((CharSequence)this.context.getString(R.string.home_closed_tabs_title2));
                break;
            }
            case CLOSED_TAB: {
                ClosedTab closedTab = this.getClosedTabForPosition(n);
                ((CombinedHistoryItem.HistoryItem)combinedHistoryItem).bind(closedTab);
            }
        }
    }

    public int getItemCount() {
        int n = 1;
        if (this.isSectionHeaderVisible()) {
            ++n;
        }
        return n += this.getClosedTabsCount();
    }

    private CombinedHistoryItem.ItemType getItemTypeForPosition(int n) {
        if (n == 0) {
            return CombinedHistoryItem.ItemType.NAVIGATION_BACK;
        }
        if (n == this.getSectionHeaderIndex() && this.isSectionHeaderVisible()) {
            return CombinedHistoryItem.ItemType.SECTION_HEADER;
        }
        return CombinedHistoryItem.ItemType.CLOSED_TAB;
    }

    public int getItemViewType(int n) {
        return CombinedHistoryItem.ItemType.itemTypeToViewType(this.getItemTypeForPosition(n));
    }

    public int getClosedTabsCount() {
        return this.recentlyClosedTabs.length + this.lastSessionTabs.length;
    }

    private boolean isSectionHeaderVisible() {
        return this.recentlyClosedTabs.length > 0 || this.lastSessionTabs.length > 0;
    }

    private int getSectionHeaderIndex() {
        return this.isSectionHeaderVisible() ? 1 : 0;
    }

    private int getFirstRecentTabIndex() {
        return this.getSectionHeaderIndex() + 1;
    }

    private int getLastRecentTabIndex() {
        return this.getSectionHeaderIndex() + this.recentlyClosedTabs.length;
    }

    private int getFirstLastSessionTabIndex() {
        return this.getLastRecentTabIndex() + 1;
    }

    private int getLastLastSessionTabIndex() {
        return this.getLastRecentTabIndex() + this.lastSessionTabs.length;
    }

    private ClosedTab getClosedTabForPosition(int n) {
        ClosedTab closedTab = n <= this.getLastRecentTabIndex() ? this.recentlyClosedTabs[n - this.getFirstRecentTabIndex()] : this.lastSessionTabs[n - this.getFirstLastSessionTabIndex()];
        return closedTab;
    }

    @Override
    public HomeContextMenuInfo makeContextMenuInfoFromPosition(View view, int n) {
        CombinedHistoryItem.ItemType itemType = this.getItemTypeForPosition(n);
        switch (itemType) {
            case CLOSED_TAB: {
                HomeContextMenuInfo homeContextMenuInfo = new HomeContextMenuInfo(view, n, -1L);
                ClosedTab closedTab = this.getClosedTabForPosition(n);
                return RecentTabsAdapter.populateChildInfoFromTab(homeContextMenuInfo, closedTab);
            }
        }
        return null;
    }

    protected static HomeContextMenuInfo populateChildInfoFromTab(HomeContextMenuInfo homeContextMenuInfo, ClosedTab closedTab) {
        homeContextMenuInfo.url = closedTab.url;
        homeContextMenuInfo.title = closedTab.title;
        return homeContextMenuInfo;
    }

    static /* synthetic */ ClosedTab[] access$002(RecentTabsAdapter recentTabsAdapter, ClosedTab[] closedTabArray) {
        recentTabsAdapter.recentlyClosedTabs = closedTabArray;
        return closedTabArray;
    }

    static /* synthetic */ ClosedTab[] access$1002(RecentTabsAdapter recentTabsAdapter, ClosedTab[] closedTabArray) {
        recentTabsAdapter.lastSessionTabs = closedTabArray;
        return closedTabArray;
    }

    public static final class ClosedTab {
        public final String url;
        public final String title;
        public final String data;

        public ClosedTab(String string2, String string3, String string4) {
            this.url = string2;
            this.title = string3;
            this.data = string4;
        }
    }
}

