/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.javaaddons;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.javaaddons.JavaAddonManagerV1;
import org.mozilla.gecko.util.GeckoEventListener;

public class JavaAddonManager
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoJavaAddonManager";
    private static JavaAddonManager sInstance;
    private final EventDispatcher mDispatcher = EventDispatcher.getInstance();
    private final Map<String, Map<String, GeckoEventListener>> mAddonCallbacks = new HashMap<String, Map<String, GeckoEventListener>>();
    private Context mApplicationContext;

    public static JavaAddonManager getInstance() {
        if (sInstance == null) {
            sInstance = new JavaAddonManager();
        }
        return sInstance;
    }

    private JavaAddonManager() {
    }

    public void init(Context context) {
        if (this.mApplicationContext != null) {
            return;
        }
        this.mApplicationContext = context;
        this.mDispatcher.registerGeckoThreadListener(this, "Dex:Load", "Dex:Unload");
        JavaAddonManagerV1.getInstance().init(context);
    }

    public void handleMessage(String string, JSONObject jSONObject) {
        block8: {
            try {
                if (string.equals("Dex:Load")) {
                    String string2 = jSONObject.getString("zipfile");
                    String string3 = jSONObject.getString("impl");
                    Log.d((String)LOGTAG, (String)("Attempting to load classes.dex file from " + string2 + " and instantiate " + string3));
                    try {
                        File file = this.mApplicationContext.getDir("dex", 0);
                        DexClassLoader dexClassLoader = new DexClassLoader(string2, file.getAbsolutePath(), null, this.mApplicationContext.getClassLoader());
                        Class clazz = dexClassLoader.loadClass(string3);
                        try {
                            Constructor constructor = clazz.getDeclaredConstructor(Map.class);
                            HashMap<String, Handler.Callback> hashMap = new HashMap<String, Handler.Callback>();
                            constructor.newInstance(hashMap);
                            this.registerCallbacks(string2, hashMap);
                            break block8;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            Log.d((String)LOGTAG, (String)"Did not find constructor with parameters Map<String, Handler.Callback>. Falling back to default constructor...");
                            clazz.newInstance();
                        }
                    }
                    catch (Exception exception) {
                        Log.e((String)LOGTAG, (String)"Unable to load dex successfully", (Throwable)exception);
                    }
                    break block8;
                }
                if (string.equals("Dex:Unload")) {
                    String string4 = jSONObject.getString("zipfile");
                    this.unregisterCallbacks(string4);
                }
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)("Exception handling message [" + string + "]:"), (Throwable)jSONException);
            }
        }
    }

    private void registerCallbacks(String string, Map<String, Handler.Callback> map) {
        Map<String, GeckoEventListener> map2 = this.mAddonCallbacks.get(string);
        if (map2 != null) {
            Log.w((String)LOGTAG, (String)("Found pre-existing callbacks for zipfile [" + string + "]; aborting re-registration!"));
            return;
        }
        map2 = new HashMap<String, GeckoEventListener>();
        for (String string2 : map.keySet()) {
            CallbackWrapper callbackWrapper = new CallbackWrapper(map.get(string2));
            this.mDispatcher.registerGeckoThreadListener(callbackWrapper, string2);
            map2.put(string2, callbackWrapper);
        }
        this.mAddonCallbacks.put(string, map2);
    }

    private void unregisterCallbacks(String string) {
        Map<String, GeckoEventListener> map = this.mAddonCallbacks.remove(string);
        if (map == null) {
            Log.w((String)LOGTAG, (String)("Attempting to unregister callbacks from zipfile [" + string + "] which has no callbacks registered."));
            return;
        }
        for (String string2 : map.keySet()) {
            this.mDispatcher.unregisterGeckoThreadListener(map.get(string2), string2);
        }
    }

    private static class CallbackWrapper
    implements GeckoEventListener {
        private final Handler.Callback mDelegate;
        private Bundle mBundle;

        CallbackWrapper(Handler.Callback callback) {
            this.mDelegate = callback;
        }

        private Bundle jsonToBundle(JSONObject jSONObject) {
            Bundle bundle = new Bundle();
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                try {
                    String string = (String)iterator.next();
                    Object object = jSONObject.get(string);
                    if (object instanceof Integer) {
                        bundle.putInt(string, ((Integer)object).intValue());
                        continue;
                    }
                    if (object instanceof String) {
                        bundle.putString(string, (String)object);
                        continue;
                    }
                    if (object instanceof Boolean) {
                        bundle.putBoolean(string, ((Boolean)object).booleanValue());
                        continue;
                    }
                    if (object instanceof Long) {
                        bundle.putLong(string, ((Long)object).longValue());
                        continue;
                    }
                    if (!(object instanceof Double)) continue;
                    bundle.putDouble(string, ((Double)object).doubleValue());
                }
                catch (JSONException jSONException) {
                    Log.d((String)JavaAddonManager.LOGTAG, (String)"Error during JSON->bundle conversion", (Throwable)jSONException);
                }
            }
            return bundle;
        }

        public void handleMessage(String string, JSONObject jSONObject) {
            try {
                if (this.mBundle != null) {
                    Log.w((String)JavaAddonManager.LOGTAG, (String)("Event [" + string + "] handler is re-entrant; response messages may be lost"));
                }
                this.mBundle = this.jsonToBundle(jSONObject);
                Message message = new Message();
                message.setData(this.mBundle);
                this.mDelegate.handleMessage(message);
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("response", (Object)this.mBundle.getString("response"));
                EventDispatcher.sendResponse(jSONObject, jSONObject2);
                this.mBundle = null;
            }
            catch (Exception exception) {
                Log.e((String)JavaAddonManager.LOGTAG, (String)"Caught exception thrown from wrapped addon message handler", (Throwable)exception);
            }
        }
    }
}

