/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.menu;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.R;
import org.mozilla.gecko.menu.GeckoMenuItem;
import org.mozilla.gecko.menu.GeckoSubMenu;
import org.mozilla.gecko.menu.MenuItemActionBar;
import org.mozilla.gecko.menu.MenuItemDefault;
import org.mozilla.gecko.menu.MenuItemSwitcherLayout;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.GeckoActionProvider;

public class GeckoMenu
extends ListView
implements Menu,
AdapterView.OnItemClickListener,
GeckoMenuItem.OnShowAsActionChangedListener {
    private static final String LOGTAG = "GeckoMenu";
    private static final ThreadUtils.AssertBehavior THREAD_ASSERT_BEHAVIOR = ThreadUtils.AssertBehavior.THROW;
    protected static final int NO_ID = 0;
    private final List<GeckoMenuItem> mItems;
    private final SparseArray<MenuItem> mItemsById;
    private final Map<GeckoMenuItem, View> mPrimaryActionItems;
    private final Map<GeckoMenuItem, View> mSecondaryActionItems;
    private final Map<GeckoMenuItem, View> mQuickShareActionItems;
    private Callback mCallback;
    private MenuPresenter mMenuPresenter;
    private ActionItemBarPresenter mPrimaryActionItemBar;
    private final ActionItemBarPresenter mSecondaryActionItemBar;
    private final ActionItemBarPresenter mQuickShareActionItemBar;
    private final MenuItemsAdapter mAdapter;
    boolean mShowIcons;

    public GeckoMenu(Context context) {
        this(context, null);
    }

    public GeckoMenu(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.geckoMenuListViewStyle);
    }

    public GeckoMenu(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -1));
        this.mAdapter = new MenuItemsAdapter();
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setOnItemClickListener(this);
        this.mItems = new ArrayList<GeckoMenuItem>();
        this.mItemsById = new SparseArray();
        this.mPrimaryActionItems = new HashMap<GeckoMenuItem, View>();
        this.mSecondaryActionItems = new HashMap<GeckoMenuItem, View>();
        this.mQuickShareActionItems = new HashMap<GeckoMenuItem, View>();
        this.mPrimaryActionItemBar = (DefaultActionItemBar)LayoutInflater.from((Context)context).inflate(R.layout.menu_action_bar, null);
        this.mSecondaryActionItemBar = (DefaultActionItemBar)LayoutInflater.from((Context)context).inflate(R.layout.menu_secondary_action_bar, null);
        this.mQuickShareActionItemBar = (DefaultActionItemBar)LayoutInflater.from((Context)context).inflate(R.layout.menu_secondary_action_bar, null);
    }

    private static void assertOnUiThread() {
        ThreadUtils.assertOnUiThread((ThreadUtils.AssertBehavior)THREAD_ASSERT_BEHAVIOR);
    }

    public MenuItem add(CharSequence charSequence) {
        GeckoMenuItem geckoMenuItem = new GeckoMenuItem(this, 0, 0, charSequence);
        this.addItem(geckoMenuItem);
        return geckoMenuItem;
    }

    public MenuItem add(int n, int n2, int n3, int n4) {
        GeckoMenuItem geckoMenuItem = new GeckoMenuItem(this, n2, n3, n4);
        this.addItem(geckoMenuItem);
        return geckoMenuItem;
    }

    public MenuItem add(int n) {
        GeckoMenuItem geckoMenuItem = new GeckoMenuItem(this, 0, 0, n);
        this.addItem(geckoMenuItem);
        return geckoMenuItem;
    }

    public MenuItem add(int n, int n2, int n3, CharSequence charSequence) {
        GeckoMenuItem geckoMenuItem = new GeckoMenuItem(this, n2, n3, charSequence);
        this.addItem(geckoMenuItem);
        return geckoMenuItem;
    }

    private void addItem(GeckoMenuItem geckoMenuItem) {
        GeckoMenu.assertOnUiThread();
        geckoMenuItem.setOnShowAsActionChangedListener(this);
        this.mAdapter.addMenuItem(geckoMenuItem);
        this.mItems.add(geckoMenuItem);
    }

    private boolean addActionItem(final GeckoMenuItem geckoMenuItem) {
        MenuItemSwitcherLayout menuItemSwitcherLayout;
        GeckoMenu.assertOnUiThread();
        geckoMenuItem.setOnShowAsActionChangedListener(this);
        View view = geckoMenuItem.getActionView();
        int n = geckoMenuItem.getActionEnum();
        boolean bl = false;
        if (n == 2) {
            if (this.mPrimaryActionItems.size() == 0 && this.mPrimaryActionItemBar instanceof DefaultActionItemBar) {
                this.setAdapter(null);
                this.addHeaderView((View)((DefaultActionItemBar)this.mPrimaryActionItemBar));
                this.setAdapter((ListAdapter)this.mAdapter);
            }
            if (bl = this.mPrimaryActionItemBar.addActionItem(view)) {
                this.mPrimaryActionItems.put(geckoMenuItem, view);
                this.mItems.add(geckoMenuItem);
            }
        } else if (n == 1) {
            if (this.mSecondaryActionItems.size() == 0) {
                this.setAdapter(null);
                this.addHeaderView((View)((DefaultActionItemBar)this.mSecondaryActionItemBar));
                this.setAdapter((ListAdapter)this.mAdapter);
            }
            if (bl = this.mSecondaryActionItemBar.addActionItem(view)) {
                this.mSecondaryActionItems.put(geckoMenuItem, view);
                this.mItems.add(geckoMenuItem);
            }
        } else if (n == 8 && view instanceof MenuItemSwitcherLayout && (menuItemSwitcherLayout = (MenuItemSwitcherLayout)view).getActionButtonCount() > 0 && (bl = this.mQuickShareActionItemBar.addActionItem((View)menuItemSwitcherLayout))) {
            if (this.mQuickShareActionItems.size() == 0) {
                this.setAdapter(null);
                this.addHeaderView((View)((DefaultActionItemBar)this.mQuickShareActionItemBar));
                this.setAdapter((ListAdapter)this.mAdapter);
            }
            this.mQuickShareActionItems.put(geckoMenuItem, (View)menuItemSwitcherLayout);
            this.mItems.add(geckoMenuItem);
        }
        if (view instanceof MenuItemActionBar) {
            ((MenuItemActionBar)view).setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    GeckoMenu.this.handleMenuItemClick(geckoMenuItem);
                }
            });
            ((MenuItemActionBar)view).setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View view) {
                    if (GeckoMenu.this.handleMenuItemLongClick(geckoMenuItem)) {
                        GeckoAppShell.vibrateOnHapticFeedbackEnabled(GeckoMenu.this.getResources().getIntArray(R.array.long_press_vibrate_msec));
                        return true;
                    }
                    return false;
                }
            });
        } else if (view instanceof MenuItemSwitcherLayout) {
            ((MenuItemSwitcherLayout)view).setMenuItemClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    GeckoMenu.this.handleMenuItemClick(geckoMenuItem);
                }
            });
            ((MenuItemSwitcherLayout)view).setMenuItemLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View view) {
                    if (GeckoMenu.this.handleMenuItemLongClick(geckoMenuItem)) {
                        GeckoAppShell.vibrateOnHapticFeedbackEnabled(GeckoMenu.this.getResources().getIntArray(R.array.long_press_vibrate_msec));
                        return true;
                    }
                    return false;
                }
            });
        }
        return bl;
    }

    public int addIntentOptions(int n, int n2, int n3, ComponentName componentName, Intent[] intentArray, Intent intent, int n4, MenuItem[] menuItemArray) {
        return 0;
    }

    public SubMenu addSubMenu(int n, int n2, int n3, CharSequence charSequence) {
        MenuItem menuItem = this.add(n, n2, n3, charSequence);
        return this.addSubMenu(menuItem);
    }

    public SubMenu addSubMenu(int n, int n2, int n3, int n4) {
        MenuItem menuItem = this.add(n, n2, n3, n4);
        return this.addSubMenu(menuItem);
    }

    public SubMenu addSubMenu(CharSequence charSequence) {
        MenuItem menuItem = this.add(charSequence);
        return this.addSubMenu(menuItem);
    }

    public SubMenu addSubMenu(int n) {
        MenuItem menuItem = this.add(n);
        return this.addSubMenu(menuItem);
    }

    private SubMenu addSubMenu(MenuItem menuItem) {
        GeckoSubMenu geckoSubMenu = new GeckoSubMenu(this.getContext());
        geckoSubMenu.setMenuItem(menuItem);
        geckoSubMenu.setCallback(this.mCallback);
        geckoSubMenu.setMenuPresenter(this.mMenuPresenter);
        ((GeckoMenuItem)menuItem).setSubMenu(geckoSubMenu);
        return geckoSubMenu;
    }

    private void removePrimaryActionBarView() {
        this.setAdapter(null);
        this.removeHeaderView((View)((DefaultActionItemBar)this.mPrimaryActionItemBar));
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    private void removeSecondaryActionBarView() {
        this.setAdapter(null);
        this.removeHeaderView((View)((DefaultActionItemBar)this.mSecondaryActionItemBar));
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    private void removeQuickShareActionBarView() {
        this.setAdapter(null);
        this.removeHeaderView((View)((DefaultActionItemBar)this.mQuickShareActionItemBar));
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    public void clear() {
        GeckoMenu.assertOnUiThread();
        for (GeckoMenuItem geckoMenuItem : this.mItems) {
            SubMenu subMenu;
            if (!geckoMenuItem.hasSubMenu() || (subMenu = geckoMenuItem.getSubMenu()) == null) continue;
            try {
                subMenu.clear();
            }
            catch (Exception exception) {
                Log.e((String)LOGTAG, (String)"Couldn't clear submenu.", (Throwable)exception);
            }
        }
        this.mAdapter.clear();
        this.mItems.clear();
        if (this.mPrimaryActionItemBar != null) {
            for (View view : this.mPrimaryActionItems.values()) {
                this.mPrimaryActionItemBar.removeActionItem(view);
            }
        }
        this.mPrimaryActionItems.clear();
        if (this.mSecondaryActionItemBar != null) {
            for (View view : this.mSecondaryActionItems.values()) {
                this.mSecondaryActionItemBar.removeActionItem(view);
            }
        }
        this.mSecondaryActionItems.clear();
        if (this.mQuickShareActionItemBar != null) {
            for (View view : this.mQuickShareActionItems.values()) {
                this.mQuickShareActionItemBar.removeActionItem(view);
            }
        }
        this.mQuickShareActionItems.clear();
        if (this.mPrimaryActionItemBar instanceof DefaultActionItemBar) {
            this.removePrimaryActionBarView();
        }
        this.removeSecondaryActionBarView();
        this.removeQuickShareActionBarView();
    }

    public void close() {
        if (this.mMenuPresenter != null) {
            this.mMenuPresenter.closeMenu();
        }
    }

    private void showMenu(View view) {
        if (this.mMenuPresenter != null) {
            this.mMenuPresenter.showMenu(view);
        }
    }

    public MenuItem findItem(int n) {
        GeckoMenu.assertOnUiThread();
        MenuItem menuItem = (MenuItem)this.mItemsById.get(n);
        if (menuItem != null) {
            return menuItem;
        }
        for (GeckoMenuItem geckoMenuItem : this.mItems) {
            SubMenu subMenu;
            MenuItem menuItem2;
            if (geckoMenuItem.getItemId() == n) {
                this.mItemsById.put(n, (Object)geckoMenuItem);
                return geckoMenuItem;
            }
            if (!geckoMenuItem.hasSubMenu() || geckoMenuItem.hasActionProvider() || (menuItem2 = (subMenu = geckoMenuItem.getSubMenu()).findItem(n)) == null) continue;
            this.mItemsById.put(n, (Object)menuItem2);
            return menuItem2;
        }
        return null;
    }

    public MenuItem getItem(int n) {
        if (n < this.mItems.size()) {
            return this.mItems.get(n);
        }
        return null;
    }

    public boolean hasVisibleItems() {
        GeckoMenu.assertOnUiThread();
        for (GeckoMenuItem geckoMenuItem : this.mItems) {
            if (!geckoMenuItem.isVisible() || this.mPrimaryActionItems.containsKey(geckoMenuItem) || this.mSecondaryActionItems.containsKey(geckoMenuItem) || this.mQuickShareActionItems.containsKey(geckoMenuItem)) continue;
            return true;
        }
        return false;
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (n == 82 && this.isShown()) {
            this.close();
            return true;
        }
        return super.onKeyDown(n, keyEvent);
    }

    public boolean isShortcutKey(int n, KeyEvent keyEvent) {
        return true;
    }

    public boolean performIdentifierAction(int n, int n2) {
        return false;
    }

    public boolean performShortcut(int n, KeyEvent keyEvent, int n2) {
        return false;
    }

    public void removeGroup(int n) {
    }

    public void removeItem(int n) {
        GeckoMenu.assertOnUiThread();
        GeckoMenuItem geckoMenuItem = (GeckoMenuItem)this.findItem(n);
        if (geckoMenuItem == null) {
            return;
        }
        this.mItemsById.remove(n);
        for (GeckoMenuItem geckoMenuItem2 : this.mItems) {
            SubMenu subMenu;
            if (!geckoMenuItem2.hasSubMenu() || (subMenu = geckoMenuItem2.getSubMenu()) == null || subMenu.findItem(n) == null) continue;
            subMenu.removeItem(n);
            return;
        }
        if (this.mPrimaryActionItems.containsKey(geckoMenuItem)) {
            if (this.mPrimaryActionItemBar != null) {
                this.mPrimaryActionItemBar.removeActionItem(this.mPrimaryActionItems.get(geckoMenuItem));
            }
            this.mPrimaryActionItems.remove(geckoMenuItem);
            this.mItems.remove(geckoMenuItem);
            if (this.mPrimaryActionItems.size() == 0 && this.mPrimaryActionItemBar instanceof DefaultActionItemBar) {
                this.removePrimaryActionBarView();
            }
            return;
        }
        if (this.mSecondaryActionItems.containsKey(geckoMenuItem)) {
            if (this.mSecondaryActionItemBar != null) {
                this.mSecondaryActionItemBar.removeActionItem(this.mSecondaryActionItems.get(geckoMenuItem));
            }
            this.mSecondaryActionItems.remove(geckoMenuItem);
            this.mItems.remove(geckoMenuItem);
            if (this.mSecondaryActionItems.size() == 0) {
                this.removeSecondaryActionBarView();
            }
            return;
        }
        if (this.mQuickShareActionItems.containsKey(geckoMenuItem)) {
            if (this.mQuickShareActionItemBar != null) {
                this.mQuickShareActionItemBar.removeActionItem(this.mQuickShareActionItems.get(geckoMenuItem));
            }
            this.mQuickShareActionItems.remove(geckoMenuItem);
            this.mItems.remove(geckoMenuItem);
            if (this.mQuickShareActionItems.size() == 0) {
                this.removeQuickShareActionBarView();
            }
            return;
        }
        this.mAdapter.removeMenuItem(geckoMenuItem);
        this.mItems.remove(geckoMenuItem);
    }

    public void setGroupCheckable(int n, boolean bl, boolean bl2) {
    }

    public void setGroupEnabled(int n, boolean bl) {
    }

    public void setGroupVisible(int n, boolean bl) {
    }

    public void setQwertyMode(boolean bl) {
    }

    public int size() {
        return this.mItems.size();
    }

    @Override
    public boolean hasActionItemBar() {
        return this.mPrimaryActionItemBar != null && this.mSecondaryActionItemBar != null && this.mQuickShareActionItemBar != null;
    }

    @Override
    public void onShowAsActionChanged(GeckoMenuItem geckoMenuItem) {
        this.removeItem(geckoMenuItem.getItemId());
        if (geckoMenuItem.isActionItem() && this.addActionItem(geckoMenuItem)) {
            return;
        }
        this.addItem(geckoMenuItem);
    }

    public void onItemChanged(GeckoMenuItem geckoMenuItem) {
        GeckoMenu.assertOnUiThread();
        if (geckoMenuItem.isActionItem()) {
            int n = geckoMenuItem.getActionEnum();
            View view = n == 2 ? this.mPrimaryActionItems.get(geckoMenuItem) : (n == 1 ? this.mSecondaryActionItems.get(geckoMenuItem) : this.mQuickShareActionItems.get(geckoMenuItem));
            if (view != null) {
                if (geckoMenuItem.isVisible()) {
                    view.setVisibility(0);
                    if (view instanceof MenuItemActionBar) {
                        ((MenuItemActionBar)view).initialize(geckoMenuItem);
                    } else {
                        ((MenuItemSwitcherLayout)view).initialize(geckoMenuItem);
                    }
                } else {
                    view.setVisibility(8);
                }
            }
        } else {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
        GeckoMenuItem geckoMenuItem = this.mAdapter.getItem(n -= this.getHeaderViewsCount());
        this.handleMenuItemClick(geckoMenuItem);
    }

    void handleMenuItemClick(GeckoMenuItem geckoMenuItem) {
        if (!geckoMenuItem.isEnabled()) {
            return;
        }
        if (geckoMenuItem.invoke()) {
            this.close();
        } else if (geckoMenuItem.hasSubMenu()) {
            GeckoSubMenu geckoSubMenu;
            GeckoActionProvider geckoActionProvider = geckoMenuItem.getGeckoActionProvider();
            if (geckoActionProvider != null) {
                geckoSubMenu = new GeckoSubMenu(this.getContext());
                geckoSubMenu.setShowIcons(true);
                geckoActionProvider.onPrepareSubMenu(geckoSubMenu);
                geckoMenuItem.setSubMenu(geckoSubMenu);
            }
            geckoSubMenu = (GeckoSubMenu)geckoMenuItem.getSubMenu();
            this.showMenu((View)geckoSubMenu);
        } else {
            this.close();
            this.mCallback.onMenuItemClick(geckoMenuItem);
        }
    }

    boolean handleMenuItemLongClick(GeckoMenuItem geckoMenuItem) {
        if (!geckoMenuItem.isEnabled()) {
            return false;
        }
        if (this.mCallback != null && this.mCallback.onMenuItemLongClick(geckoMenuItem)) {
            this.close();
            return true;
        }
        return false;
    }

    public Callback getCallback() {
        return this.mCallback;
    }

    public MenuPresenter getMenuPresenter() {
        return this.mMenuPresenter;
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
        for (GeckoMenuItem geckoMenuItem : this.mItems) {
            if (!geckoMenuItem.hasSubMenu()) continue;
            GeckoSubMenu geckoSubMenu = (GeckoSubMenu)geckoMenuItem.getSubMenu();
            geckoSubMenu.setCallback(this.mCallback);
        }
    }

    public void setMenuPresenter(MenuPresenter menuPresenter) {
        this.mMenuPresenter = menuPresenter;
        for (GeckoMenuItem geckoMenuItem : this.mItems) {
            if (!geckoMenuItem.hasSubMenu()) continue;
            GeckoSubMenu geckoSubMenu = (GeckoSubMenu)geckoMenuItem.getSubMenu();
            geckoSubMenu.setMenuPresenter(this.mMenuPresenter);
        }
    }

    public void setActionItemBarPresenter(ActionItemBarPresenter actionItemBarPresenter) {
        this.mPrimaryActionItemBar = actionItemBarPresenter;
    }

    public void setShowIcons(boolean bl) {
        if (this.mShowIcons != bl) {
            this.mShowIcons = bl;
            this.mAdapter.notifyDataSetChanged();
        }
    }

    private class MenuItemsAdapter
    extends BaseAdapter {
        private static final int VIEW_TYPE_DEFAULT = 0;
        private static final int VIEW_TYPE_ACTION_MODE = 1;
        private final List<GeckoMenuItem> mItems = new ArrayList<GeckoMenuItem>();

        public int getCount() {
            if (this.mItems == null) {
                return 0;
            }
            int n = 0;
            for (GeckoMenuItem geckoMenuItem : this.mItems) {
                if (!geckoMenuItem.isVisible()) continue;
                ++n;
            }
            return n;
        }

        public GeckoMenuItem getItem(int n) {
            for (GeckoMenuItem geckoMenuItem : this.mItems) {
                if (!geckoMenuItem.isVisible() || --n >= 0) continue;
                return geckoMenuItem;
            }
            return null;
        }

        public long getItemId(int n) {
            return n;
        }

        public View getView(int n, View view, ViewGroup viewGroup) {
            GeckoMenuItem geckoMenuItem = this.getItem(n);
            GeckoMenuItem.Layout layout2 = null;
            layout2 = view == null && this.getItemViewType(n) == 0 ? new MenuItemDefault(viewGroup.getContext(), null) : (GeckoMenuItem.Layout)view;
            if (layout2 == null || layout2 instanceof MenuItemSwitcherLayout) {
                layout2 = (MenuItemSwitcherLayout)geckoMenuItem.getActionView();
                final View view2 = (View)layout2;
                final int n2 = n;
                final long l = this.getItemId(n);
                ((MenuItemSwitcherLayout)layout2).setMenuItemClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        GeckoMenu geckoMenu = GeckoMenu.this;
                        geckoMenu.performItemClick(view2, n2 + geckoMenu.getHeaderViewsCount(), l);
                    }
                });
            }
            layout2.setShowIcon(GeckoMenu.this.mShowIcons);
            layout2.initialize(geckoMenuItem);
            return (View)layout2;
        }

        public int getItemViewType(int n) {
            return this.getItem(n).getGeckoActionProvider() == null ? 0 : 1;
        }

        public int getViewTypeCount() {
            return 2;
        }

        public boolean hasStableIds() {
            return false;
        }

        public boolean areAllItemsEnabled() {
            return true;
        }

        public boolean isEnabled(int n) {
            return true;
        }

        public void addMenuItem(GeckoMenuItem geckoMenuItem) {
            if (this.mItems.contains(geckoMenuItem)) {
                return;
            }
            int n = 0;
            for (GeckoMenuItem geckoMenuItem2 : this.mItems) {
                if (geckoMenuItem2.getOrder() > geckoMenuItem.getOrder()) {
                    this.mItems.add(n, geckoMenuItem);
                    this.notifyDataSetChanged();
                    return;
                }
                ++n;
            }
            this.mItems.add(geckoMenuItem);
            this.notifyDataSetChanged();
        }

        public void removeMenuItem(GeckoMenuItem geckoMenuItem) {
            this.mItems.remove(geckoMenuItem);
            this.notifyDataSetChanged();
        }

        public void clear() {
            GeckoMenu.this.mItemsById.clear();
            this.mItems.clear();
            this.notifyDataSetChanged();
        }

        public GeckoMenuItem getMenuItem(int n) {
            for (GeckoMenuItem geckoMenuItem : this.mItems) {
                if (geckoMenuItem.getItemId() != n) continue;
                return geckoMenuItem;
            }
            return null;
        }
    }

    public static class DefaultActionItemBar
    extends LinearLayout
    implements ActionItemBarPresenter {
        private final int mRowHeight = this.getResources().getDimensionPixelSize(R.dimen.menu_item_row_height);
        private float mWeightSum;

        public DefaultActionItemBar(Context context) {
            this(context, null);
        }

        public DefaultActionItemBar(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        @Override
        public boolean addActionItem(View view) {
            LinearLayout.LayoutParams layoutParams;
            ViewGroup.LayoutParams layoutParams2 = view.getLayoutParams();
            if (layoutParams2 != null) {
                layoutParams = new LinearLayout.LayoutParams(view.getLayoutParams());
                layoutParams.width = 0;
            } else {
                layoutParams = new LinearLayout.LayoutParams(0, this.mRowHeight);
            }
            layoutParams.weight = view instanceof MenuItemSwitcherLayout ? (float)((MenuItemSwitcherLayout)view).getChildCount() : 1.0f;
            this.mWeightSum += layoutParams.weight;
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.addView(view);
            this.setWeightSum(this.mWeightSum);
            return true;
        }

        @Override
        public void removeActionItem(View view) {
            if (this.indexOfChild(view) != -1) {
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view.getLayoutParams();
                this.mWeightSum -= layoutParams.weight;
                this.removeView(view);
            }
        }
    }

    public static interface ActionItemBarPresenter {
        public boolean addActionItem(View var1);

        public void removeActionItem(View var1);
    }

    public static interface MenuPresenter {
        public void openMenu();

        public void showMenu(View var1);

        public void closeMenu();
    }

    public static interface Callback {
        public boolean onMenuItemClick(MenuItem var1);

        public boolean onMenuItemLongClick(MenuItem var1);
    }
}

