/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.accounts.Account;
import android.app.Activity;
import android.app.LoaderManager;
import android.content.Context;
import android.content.Loader;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Bundle;
import android.preference.PreferenceFragment;
import android.preference.PreferenceGroup;
import android.preference.PreferenceScreen;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import java.util.Locale;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.BrowserLocaleManager;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.LocaleManager;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.fxa.AccountLoader;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.preferences.GeckoPreferences;
import org.mozilla.gecko.preferences.SyncPreference;

public class GeckoPreferenceFragment
extends PreferenceFragment {
    public static final int ACCOUNT_LOADER_ID = 1;
    private AccountLoaderCallbacks accountLoaderCallbacks;
    private SyncPreference syncPreference;
    private static final String LOGTAG = "GeckoPreferenceFragment";
    private PrefsHelper.PrefHandler mPrefsRequest;
    private Locale lastLocale = Locale.getDefault();

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        Log.d((String)LOGTAG, (String)("onConfigurationChanged: " + configuration.locale));
        Activity activity = this.getActivity();
        LocaleManager localeManager = BrowserLocaleManager.getInstance();
        Locale locale = localeManager.onSystemConfigurationChanged((Context)activity, this.getResources(), configuration, this.lastLocale);
        if (locale != null) {
            this.applyLocale(locale);
        }
    }

    public void onCreate(Bundle bundle) {
        String string2;
        super.onCreate(bundle);
        this.getPreferenceManager().setSharedPreferencesName("GeckoApp");
        int n = this.getResource();
        if (n == R.xml.preferences) {
            Telemetry.startUISession(TelemetryContract.Session.SETTINGS);
        } else {
            string2 = this.getArguments().getString("resource");
            Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.SETTINGS, string2);
        }
        if (n == R.xml.preferences_search) {
            this.setHasOptionsMenu(true);
        }
        this.addPreferencesFromResource(n);
        string2 = this.getPreferenceScreen();
        this.setPreferenceScreen((PreferenceScreen)string2);
        this.mPrefsRequest = ((GeckoPreferences)this.getActivity()).setupPreferences((PreferenceGroup)string2);
        this.syncPreference = (SyncPreference)this.findPreference("android.not_a_preference.sync");
    }

    private String getTitle() {
        int n = this.getResource();
        if (n == R.xml.preferences) {
            return this.getString(R.string.settings_title);
        }
        if (n == R.xml.preferences_privacy) {
            return this.getString(R.string.pref_category_privacy_short);
        }
        if (n == R.xml.preferences_search) {
            return this.getString(R.string.pref_category_search);
        }
        if (n == R.xml.preferences_notifications) {
            return this.getString(R.string.pref_category_notifications);
        }
        return null;
    }

    private int getHeader() {
        int n = this.getResource();
        if (n == R.xml.preferences) {
            return R.id.pref_header_general;
        }
        if (n == R.xml.preferences_privacy) {
            return R.id.pref_header_privacy;
        }
        if (n == R.xml.preferences_search) {
            return R.id.pref_header_search;
        }
        if (n == R.xml.preferences_notifications) {
            return R.id.pref_header_notifications;
        }
        return -1;
    }

    private void updateTitle() {
        String string2 = this.getTitle();
        if (string2 == null) {
            Log.d((String)LOGTAG, (String)"No new title to show.");
            return;
        }
        GeckoPreferences geckoPreferences = (GeckoPreferences)this.getActivity();
        if (AppConstants.Versions.feature11Plus && geckoPreferences.isMultiPane()) {
            geckoPreferences.showBreadCrumbs(string2, string2);
            geckoPreferences.switchToHeader(this.getHeader());
            return;
        }
        Log.v((String)LOGTAG, (String)("Setting activity title to " + string2));
        geckoPreferences.setTitle(string2);
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        this.accountLoaderCallbacks = new AccountLoaderCallbacks();
        this.getLoaderManager().initLoader(1, null, (LoaderManager.LoaderCallbacks)this.accountLoaderCallbacks);
    }

    public void onResume() {
        this.applyLocale(Locale.getDefault());
        super.onResume();
        this.getLoaderManager().restartLoader(1, null, (LoaderManager.LoaderCallbacks)this.accountLoaderCallbacks);
    }

    private void applyLocale(Locale locale) {
        Context context = this.getActivity().getApplicationContext();
        BrowserLocaleManager.getInstance().updateConfiguration(context, locale);
        if (!locale.equals(this.lastLocale)) {
            Log.d((String)LOGTAG, (String)("Locale changed: " + locale));
            this.lastLocale = locale;
            this.getPreferenceScreen().removeAll();
            this.addPreferencesFromResource(this.getResource());
        }
        this.updateTitle();
    }

    private int getResource() {
        int n = 0;
        String string2 = this.getArguments().getString("resource");
        Activity activity = this.getActivity();
        if (string2 != null) {
            Resources resources = activity.getResources();
            String string3 = activity.getPackageName();
            n = resources.getIdentifier(string2, "xml", string3);
        }
        if (n == 0) {
            Log.e((String)LOGTAG, (String)("Failed to find resource: " + string2 + ". Displaying default settings."));
            boolean bl = AppConstants.Versions.feature11Plus && ((GeckoPreferences)activity).isMultiPane();
            n = bl ? R.xml.preferences_general_tablet : R.xml.preferences;
        }
        return n;
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater menuInflater) {
        super.onCreateOptionsMenu(menu2, menuInflater);
        menuInflater.inflate(R.menu.preferences_search_menu, menu2);
    }

    public void onDestroy() {
        int n;
        super.onDestroy();
        if (this.mPrefsRequest != null) {
            PrefsHelper.removeObserver(this.mPrefsRequest);
            this.mPrefsRequest = null;
        }
        if ((n = this.getResource()) == R.xml.preferences) {
            Telemetry.stopUISession(TelemetryContract.Session.SETTINGS);
        }
        GeckoApplication.watchReference((Context)this.getActivity(), (Object)this);
    }

    private class AccountLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Account> {
        private AccountLoaderCallbacks() {
        }

        public Loader<Account> onCreateLoader(int n, Bundle bundle) {
            return new AccountLoader((Context)GeckoPreferenceFragment.this.getActivity());
        }

        public void onLoadFinished(Loader<Account> loader, Account account) {
            if (GeckoPreferenceFragment.this.syncPreference == null) {
                return;
            }
            if (account == null) {
                GeckoPreferenceFragment.this.syncPreference.update(null);
                return;
            }
            GeckoPreferenceFragment.this.syncPreference.update(new AndroidFxAccount((Context)GeckoPreferenceFragment.this.getActivity(), account));
        }

        public void onLoaderReset(Loader<Account> loader) {
            if (GeckoPreferenceFragment.this.syncPreference != null) {
                GeckoPreferenceFragment.this.syncPreference.update(null);
            }
        }
    }
}

