/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.content.Context;
import android.content.Intent;
import android.preference.Preference;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Target;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.fxa.activities.PicassoPreferenceIconTarget;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.util.ThreadUtils;

class SyncPreference
extends Preference {
    private final Context mContext;
    private final Target profileAvatarTarget;

    public SyncPreference(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
        float f = this.mContext.getResources().getDimension(R.dimen.fxaccount_profile_image_width) / 2.0f;
        this.profileAvatarTarget = new PicassoPreferenceIconTarget(this.mContext.getResources(), (Preference)this, f);
    }

    private void launchFxASetup() {
        Intent intent = new Intent("org.mozilla.fennec.ACTION_FXA_GET_STARTED");
        intent.putExtra("entrypoint", "preferences");
        intent.setFlags(0x10000000);
        intent.setFlags(65536);
        this.mContext.startActivity(intent);
    }

    public void update(final AndroidFxAccount androidFxAccount) {
        if (androidFxAccount == null) {
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    SyncPreference.this.setTitle(R.string.pref_sync);
                    SyncPreference.this.setSummary(R.string.pref_sync_summary);
                    if (AppConstants.Versions.feature11Plus) {
                        Picasso.with((Context)SyncPreference.this.mContext).cancelRequest(SyncPreference.this.profileAvatarTarget);
                        SyncPreference.this.setIcon(R.drawable.sync_avatar_default);
                    }
                }
            });
            return;
        }
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SyncPreference.this.setTitle(androidFxAccount.getEmail());
                SyncPreference.this.setSummary("");
            }
        });
        if (!AppConstants.Versions.feature11Plus) {
            return;
        }
        ExtendedJSONObject extendedJSONObject = androidFxAccount.getProfileJSON();
        if (extendedJSONObject == null) {
            return;
        }
        String string2 = extendedJSONObject.getString("avatar");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        Picasso.with((Context)this.mContext).load(string2).centerInside().resizeDimen(R.dimen.fxaccount_profile_image_width, R.dimen.fxaccount_profile_image_height).placeholder(R.drawable.sync_avatar_default).error(R.drawable.sync_avatar_default).into(this.profileAvatarTarget);
    }

    protected void onClick() {
        this.launchFxASetup();
        Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.SETTINGS, "sync_setup");
    }
}

